/* This file is mig output hacked by Roland McGrath for the GNU C library/Hurd.

   It defines the function `_hurd_exec_startup' as a special user stub for
   the `exec_startup' RPC.  This function deals with the reply either coming
   (in the normal case) from the exec server, or coming from the kernel when
   this program is the startup task.  If called from the startup task,
   _hurd_exec_startup will store the host privileged and device master ports
   in the variables `_hurd_host_priv' and `_hurd_dev_master', respectively,
   and return XXX.  */

#include "__exec.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/mig_support.h>
#include <mach/msg_type.h>


/* Set when we are the startup task.  */
mach_port_t _hurd_host_priv, _hurd_dev_master;


#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#define	UseExternRCSId		1
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine exec_startup */
mig_external kern_return_t
_hurd_exec_startup (mach_port_t execserver,
		    int *flags,
		    data_t *argv,
		    mach_msg_type_number_t *argvCnt,
		    data_t *envp,
		    mach_msg_type_number_t *envpCnt,
		    portarray_t *dtable,
		    mach_msg_type_number_t *dtableCnt,
		    portarray_t *portarray,
		    mach_msg_type_number_t *portarrayCnt,
		    intarray_t *intarray,
		    mach_msg_type_number_t *intarrayCnt
		    )
{
  /* This is what the kernel startup task reply looks like.  */
  typedef struct
    {
      mach_msg_header_t header;
      mach_msg_type_t dev_master_type;
      mach_port_t dev_master;
      mach_msg_type_t host_priv_type;
      mach_port_t host_priv;
    } kern_startup_reply_t;
  /* Correct value for dev_master_type and host_priv_type.  */
  static const mach_msg_type_t sendright_type =
    {
      /* msgt_name = */ MACH_MSG_TYPE_PORT_SEND,
      /* msgt_size = */ 32,
      /* msgt_number = */ 1,
      /* msgt_inline = */ TRUE,
      /* msgt_longform = */ FALSE,
      /* msgt_deallocate = */ FALSE,
      /* msgt_unused = */ 0
    };

  typedef struct
    {
      mach_msg_header_t Head;
    }
  Request;

  typedef struct
    {
      mach_msg_header_t Head;
      mach_msg_type_t RetCodeType;
      kern_return_t RetCode;
      mach_msg_type_t flagsType;
      int flags;
      mach_msg_type_long_t argvType;
      char argv[2048];
      mach_msg_type_long_t envpType;
      char envp[2048];
      mach_msg_type_long_t dtableType;
      mach_port_t dtable[512];
      mach_msg_type_long_t portarrayType;
      mach_port_t portarray[512];
      mach_msg_type_long_t intarrayType;
      int intarray[512];
    }
  Reply;

  union
    {
      Request In;
      Reply Out;
      kern_startup_reply_t startup_reply;
    }
  Mess;

  register Request *InP = &Mess.In;
  register Reply *OutP = &Mess.Out;

  mach_msg_return_t msg_result;
#if	TypeCheck
  boolean_t msgh_simple;
#endif				/* TypeCheck */
#if	TypeCheck
  unsigned int msgh_size;
#endif				/* TypeCheck */
  unsigned int msgh_size_delta;

  static const mach_msg_type_t RetCodeCheck =
    {
      /* msgt_name = */ MACH_MSG_TYPE_INTEGER_32,
      /* msgt_size = */ 32,
      /* msgt_number = */ 1,
      /* msgt_inline = */ TRUE,
      /* msgt_longform = */ FALSE,
      /* msgt_deallocate = */ FALSE,
      /* msgt_unused = */ 0
    };

  static const mach_msg_type_t flagsCheck =
    {
      /* msgt_name = */ 2,
      /* msgt_size = */ 32,
      /* msgt_number = */ 1,
      /* msgt_inline = */ TRUE,
      /* msgt_longform = */ FALSE,
      /* msgt_deallocate = */ FALSE,
      /* msgt_unused = */ 0
    };

  InP->Head.msgh_bits = MACH_MSGH_BITS (19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
  /* msgh_size passed as argument */
  InP->Head.msgh_request_port = execserver;
  InP->Head.msgh_reply_port = __mig_get_reply_port ();
  InP->Head.msgh_seqno = 0;
  InP->Head.msgh_id = 30001;

  msg_result = __mach_msg (&InP->Head,
			   MACH_SEND_MSG | MACH_RCV_MSG | MACH_MSG_OPTION_NONE,
			   24, sizeof (Reply), InP->Head.msgh_reply_port,
			   MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
  if (msg_result != MACH_MSG_SUCCESS)
    {
      if ((msg_result == MACH_SEND_INVALID_REPLY) ||
	  (msg_result == MACH_RCV_INVALID_NAME))
	__mig_dealloc_reply_port ();
      return msg_result;
    }

  /* The kernel always simply adds 100 to the request msgid,
     so this check will not catch the kernel startup task reply.  */

  if (OutP->Head.msgh_id != 30101)
    {
      if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
	return MIG_SERVER_DIED;
      else
	return MIG_REPLY_MISMATCH;
    }

  msgh_size = OutP->Head.msgh_size;
  msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

  if (! msgh_simple && msgh_size == sizeof (kern_startup_reply_t))
    {
      kern_startup_reply_t *const r = &Mess.startup_reply;

      if (*(int *) &r->host_priv_type == *(int *) &sendright_type &&
	  *(int *) &r->dev_master_type == *(int *) &sendright_type)
	{
	  /* This is the kernel's reply to the startup task.
	     Squirrel away the host privileged and device master ports,
	     and then return success after filling in all the arguments
	     with empty information.  */

	  _hurd_host_priv = r->host_priv;
	  _hurd_dev_master = r->dev_master;

	  *flags = 0;
	  *argv = *envp = NULL;
	  *argvCnt = *envpCnt = 0;
	  *dtable = *portarray = NULL;
	  *dtableCnt = *portarrayCnt = 0;
	  *intarray = NULL;
	  *intarrayCnt = 0;

	  return KERN_SUCCESS;
	}
    }

#if	TypeCheck
  if (((msgh_size < 100) || msgh_simple) &&
      ((msgh_size != sizeof (mig_reply_header_t)) ||
       !msgh_simple ||
       (OutP->RetCode == KERN_SUCCESS)))
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

#if	TypeCheck
  if (*(int *) &OutP->RetCodeType != *(int *) &RetCodeCheck)
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

  if (OutP->RetCode != KERN_SUCCESS)
    return OutP->RetCode;

#if	TypeCheck
  if (*(int *) &OutP->flagsType != *(int *) &flagsCheck)
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

  *flags = OutP->flags;

#if	TypeCheck
  if ((OutP->argvType.msgtl_header.msgt_longform != TRUE) ||
      (OutP->argvType.msgtl_name != 8) ||
      (OutP->argvType.msgtl_size != 8))
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

  msgh_size_delta = (OutP->argvType.msgtl_header.msgt_inline) ? (OutP->argvType.msgtl_number + 3) & ~3 : sizeof (char *);
#if	TypeCheck
  if (msgh_size < 100 + msgh_size_delta)
    return MIG_TYPE_ERROR;
  msgh_size -= msgh_size_delta;
#endif				/* TypeCheck */

  if (!OutP->argvType.msgtl_header.msgt_inline)
    *argv = *((char **) OutP->argv);
  else if (OutP->argvType.msgtl_number > *argvCnt)
    {
      __mig_allocate ((vm_offset_t *) argv,
		      OutP->argvType.msgtl_number);
      memcpy (*argv, OutP->argv, OutP->argvType.msgtl_number);
    }
  else
    {
      memcpy (*argv, OutP->argv, OutP->argvType.msgtl_number);
    }

  *argvCnt = OutP->argvType.msgtl_number;

  OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
  if ((OutP->envpType.msgtl_header.msgt_longform != TRUE) ||
      (OutP->envpType.msgtl_name != 8) ||
      (OutP->envpType.msgtl_size != 8))
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

  msgh_size_delta = (OutP->envpType.msgtl_header.msgt_inline) ? (OutP->envpType.msgtl_number + 3) & ~3 : sizeof (char *);
#if	TypeCheck
  if (msgh_size < 100 + msgh_size_delta)
    return MIG_TYPE_ERROR;
  msgh_size -= msgh_size_delta;
#endif				/* TypeCheck */

  if (!OutP->envpType.msgtl_header.msgt_inline)
    *envp = *((char **) OutP->envp);
  else if (OutP->envpType.msgtl_number > *envpCnt)
    {
      __mig_allocate ((vm_offset_t *) envp,
		      OutP->envpType.msgtl_number);
      memcpy (*envp, OutP->envp, OutP->envpType.msgtl_number);
    }
  else
    {
      memcpy (*envp, OutP->envp, OutP->envpType.msgtl_number);
    }

  *envpCnt = OutP->envpType.msgtl_number;

  OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
  if ((OutP->dtableType.msgtl_header.msgt_longform != TRUE) ||
      (OutP->dtableType.msgtl_name != 17) ||
      (OutP->dtableType.msgtl_size != 32))
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

  msgh_size_delta = (OutP->dtableType.msgtl_header.msgt_inline) ? 4 * OutP->dtableType.msgtl_number : sizeof (mach_port_t *);
#if	TypeCheck
  if (msgh_size < 100 + msgh_size_delta)
    return MIG_TYPE_ERROR;
  msgh_size -= msgh_size_delta;
#endif				/* TypeCheck */

  if (!OutP->dtableType.msgtl_header.msgt_inline)
    *dtable = *((mach_port_t **) OutP->dtable);
  else if (OutP->dtableType.msgtl_number > *dtableCnt)
    {
      __mig_allocate ((vm_offset_t *) dtable,
		      4 * OutP->dtableType.msgtl_number);
      memcpy (*dtable, OutP->dtable, 4 * OutP->dtableType.msgtl_number);
    }
  else
    {
      memcpy (*dtable, OutP->dtable, 4 * OutP->dtableType.msgtl_number);
    }

  *dtableCnt = OutP->dtableType.msgtl_number;

  OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
  if ((OutP->portarrayType.msgtl_header.msgt_longform != TRUE) ||
      (OutP->portarrayType.msgtl_name != 17) ||
      (OutP->portarrayType.msgtl_size != 32))
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

  msgh_size_delta = (OutP->portarrayType.msgtl_header.msgt_inline) ? 4 * OutP->portarrayType.msgtl_number : sizeof (mach_port_t *);
#if	TypeCheck
  if (msgh_size < 100 + msgh_size_delta)
    return MIG_TYPE_ERROR;
  msgh_size -= msgh_size_delta;
#endif				/* TypeCheck */

  if (!OutP->portarrayType.msgtl_header.msgt_inline)
    *portarray = *((mach_port_t **) OutP->portarray);
  else if (OutP->portarrayType.msgtl_number > *portarrayCnt)
    {
      __mig_allocate ((vm_offset_t *) portarray,
		      4 * OutP->portarrayType.msgtl_number);
      memcpy (*portarray, OutP->portarray, 4 * OutP->portarrayType.msgtl_number);
    }
  else
    {
      memcpy (*portarray, OutP->portarray, 4 * OutP->portarrayType.msgtl_number);
    }

  *portarrayCnt = OutP->portarrayType.msgtl_number;

  OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
  if ((OutP->intarrayType.msgtl_header.msgt_longform != TRUE) ||
      (OutP->intarrayType.msgtl_name != 2) ||
      (OutP->intarrayType.msgtl_size != 32))
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

#if	TypeCheck
  if (msgh_size != 100 + ((OutP->intarrayType.msgtl_header.msgt_inline) ? 4 * OutP->intarrayType.msgtl_number : sizeof (int *)))
    return MIG_TYPE_ERROR;
#endif				/* TypeCheck */

  if (!OutP->intarrayType.msgtl_header.msgt_inline)
    *intarray = *((int **) OutP->intarray);
  else if (OutP->intarrayType.msgtl_number > *intarrayCnt)
    {
      __mig_allocate ((vm_offset_t *) intarray,
		      4 * OutP->intarrayType.msgtl_number);
      memcpy (*intarray, OutP->intarray, 4 * OutP->intarrayType.msgtl_number);
    }
  else
    {
      memcpy (*intarray, OutP->intarray, 4 * OutP->intarrayType.msgtl_number);
    }

  *intarrayCnt = OutP->intarrayType.msgtl_number;

  return KERN_SUCCESS;
}
