'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" 
.so man.macros
.TH fileevent n 4.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
fileevent \- Execute a script when a file becomes readable or writable
.SH SYNOPSIS
\fBfileevent \fIfileId \fBreadable \fR?\fIscript\fR?
.sp
\fBfileevent \fIfileId \fBwritable \fR?\fIscript\fR?
.BE

.SH DESCRIPTION
.PP
This command is used to create \fIfile event handlers\fR.
A file event handler is a binding between a file and a script,
such that the script is evaluated whenever the file becomes
readable or writable.
File event handlers are most commonly used to allow data to be
received from a child process on an event-driven basis, so that
the receiver can continue to interact with the user while
waiting for the data to arrive.
If an application invokes \fBgets\fR or \fBread\fR when there
is no input data available, the process will block;  until the
input data arrives, it will not be able to service other events,
so it will appear to the user to ``freeze up''.
With \fBfileevent\fR, the process can tell when data is present
and only invoke \fBgets\fR or \fBread\fR when they won't block.
.PP
The \fIfileId\fR argument to \fBfileevent\fR refers to an open file;
it must be \fBstdin\fR, \fBstdout\fR, \fBstderr\fR, or the return value
from some previous \fBopen\fR command.
If the \fIscript\fR argument is specified, then \fBfileevent\fR
creates a new event handler:  \fIscript\fR will be evaluated
whenever the file becomes readable or writable (depending on the
second argument to \fBfileevent\fR).
In this case \fBfileevent\fR returns an empty string.
The \fBreadable\fR and \fBwritable\fR event handlers for a file
are independent, and may be created and deleted separately.
However, there may be at most one \fBreadable\fR and one \fBwritable\fR
handler for a file at a given time.
If \fBfileevent\fR is called when the specified handler already
exists, the new script replaces the old one.
.PP
If the \fIscript\fR argument is not specified, \fBfileevent\fR
returns the current script for \fIfileId\fR, or an empty string
if there is none.
If the \fIscript\fR argument is specified as an empty string
then the event handler is deleted, so that no script will be invoked.
A file event handler is also deleted automatically whenever
its file is closed or its interpreter is deleted.
.PP
A file is considered to be readable whenever the \fBgets\fR
and \fBread\fR commands can return without blocking.
A file is also considered to be readable if an end-of-file or
error condition is present.
It is important for \fIscript\fR to check for these conditions
and handle them appropriately;  for example, if there is no special
check for end-of-file, an infinite loop may occur where \fIscript\fR
reads no data, returns, and is immediately invoked again.
.PP
When using \fBfileevent\fR for event-driven I/O, it's important
to read the file in the same units that are written
from the other end.
For example, suppose that you are using \fBfileevent\fR to
read data generated by a child process.
If the child process is writing whole lines, then you should use
\fBgets\fR to read those lines.
If the child generates one line at a time then you shouldn't
make more than a single call to \fBgets\fR in \fIscript\fR: the first call
will consume all the available data, so the second call may block.
You can also use \fBread\fR to read the child's data, but only
if you know how many bytes the child is writing at a time:  if
you try to read more bytes than the child has written, the
\fBread\fR call will block.
.PP
A file is considered to be writable if at least one byte of data
can be written to the file without blocking, or if an error condition
is present.
Write handlers are probably not very useful without additional command
support.
The \fBputs\fR command is dangerous since it write more than
one byte at a time and may thus block.
What is really needed is a new non-blocking form of write that
saves any data that couldn't be written to the file.
.PP
The script for a file event is executed at global level (outside the
context of any Tcl procedure).
If an error occurs while executing the script then the
\fBtkerror\fR mechanism is used to report the error.
In addition, the file event handler is deleted if it ever returns
an error;  this is done in order to prevent infinite loops due to
buggy handlers.

.SH CREDITS
.PP
\fBfileevent\fR is based on the \fBaddinput\fR command created
by Mark Diekhans.

.SH "SEE ALSO"
tkerror

.SH KEYWORDS
asynchronous I/O, event handler, file, readable, script, writable
