#define POSTCONDITION
#define DISAMB
#define CACHE_OPT
/*
 * balsched.h
 */

#include <stdio.h>

extern char *balanced_scheduling_enabled;
extern char *traditional_scheduling_enabled;
extern char *dump_xgrab_output;
extern char *dump_xgrab_output2;
extern char *contrib_output;
extern char *splitting_enabled;
extern char *jlo_splitting_verbose;

#ifdef DISAMB
extern char *jlo_disambiguation_verbose;
extern char *jlo_disambiguation_verbose2;
extern char *jlo_disambiguation_verbose3;
extern char *jlo_disambiguation_verbose4;
extern char *disambiguation_enabled;
#endif
#ifdef CACHE_OPT
extern char *cache_opt_enabled;
extern char *cache_opt_peeling_enabled;
extern char *cache_opt_unrolling_enabled;
extern char *peeling_and_unrolling_allowed;  /* Allow peeling and
						unrolling of a single loop*/
extern char *jlo_cache_opt_verbose;
extern char *jlo_cache_opt_verbose2;
extern char *jlo_incorrect_alignment;
extern char *jlo_turn_on_all;
extern char *jlo_nobsa_spill_code;
extern char *gcc_use_co_enabled;
extern char *jlo_machine_dependent_weight;

extern char *jlo_stall_clock;
extern char *jlo_weight_atleast_two;
extern char *jlo_max_weight;
extern int bsa_max_weight;
extern char *jlo_reverse_heuristic3;

extern char *jlo_unroll_rename_regs;
extern char *jlo_rename_regs_verbose;
extern int bsa_max_unrolled_insns; 
extern int to_assignment;
extern char *jlo_extra_spill_regs;
extern int extra_spill_regs;


extern unsigned int loops;
extern unsigned int peeled_loops;
extern unsigned int unrolled_loops;
extern unsigned int unattempted_loops;
extern unsigned int spatial_loops;
extern unsigned int temporal_loops;
extern unsigned int cache_opt_hacks;
extern unsigned int too_big_loops;

void locality_analysis ();
float ref_depends_on ();
void print_expr();
void print_arr_ref();
void debug_arr_ref();
#endif

#ifdef POSTCONDITON
extern char *postconditioning_enabled;
#endif

void balanced_scheduling_init ();
#ifdef DISAMB
#define UNKNOWN    0   /* Use bzero to initialize, so make this 0 */
#define PARAM      1
#define NOT_PARAM  2
#define IS_PARAM(NUM) reg_is_param[(NUM)]

void find_param_arrays ();
#endif

#ifdef CACHE_OPT
#define NOT_CHECKED 0
#define CHECKED     1

#define CACHE_HIT_TIME 2.0
/* # bytes per cache line */ 
/* #define CACHE_LINE_SIZE 16  */
#define CACHE_LINE_SIZE 32 
#define SPATIAL_UNROLL_NUMBER 8
extern int preferred_unroll_number;

#define SPATIAL_LOCALITY 0
#define TEMPORAL_LOCALITY 1

#define REG_TYPE(NUM) reg_type[(NUM)]
#define REG_IS_ADDRESS(NUM) reg_is_address[(NUM)]
#define INSN_CHECKED(INSN)  insn_checked[(INSN)] 
#define INSN_ARRAY_REF(INSN)  insn_array_ref[(INSN)] 
void find_arrays ();

#ifdef USE_PROTOS
void print_loop_stats (FILE *f);
int turn_on_this_iteration (int iteration, predicate spatial_exists,
			    int initial_value);
int ref_offset (tree ref);
#else /* USE_PROTOS */ 
void print_loop_stats ();
int turn_on_this_iteration ();
int ref_offset ();
#endif /* USE_PROTOS */

#endif

extern short *insn_set_param_address;
#define INSN_PARAM_MEM_REF(INSN) (insn_param_mem_ref[INSN_UID (INSN)])
extern short *insn_param_mem_ref;

