// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

// Include files

#include "Utilities/Inform.h"
#include "Utilities/Statistics.h"

#include <iostream>
#include <iomanip>
#include <string.h>

namespace Pooma {
  

///////////////////////////////////////////////////////////////////////////////
//
// Constructor. Simple, but doesn't need to be inline.
//
///////////////////////////////////////////////////////////////////////////////

Statistics::Statistics()
{
}


///////////////////////////////////////////////////////////////////////////////
//
// Destructor: delete all of the StatData_t's.
//
///////////////////////////////////////////////////////////////////////////////

Statistics::~Statistics() 
{
  for (int i = 0; i < statList_m.size(); ++i) 
    {
      delete statList_m[i];
    }
}


///////////////////////////////////////////////////////////////////////////////
//
// Default Filtering function (does nothing).
//
///////////////////////////////////////////////////////////////////////////////

long Statistics::defaultFilter(long val)
{
  return val;
}


///////////////////////////////////////////////////////////////////////////////
//
// Print out the statistics to the given Inform object. The filter function
// exists in case we want to process the value before printing it out. One
// interesting applications is if we are in a multi-context program. In that
// case we want to reduce over contexts and print out on one of them.
//
///////////////////////////////////////////////////////////////////////////////

void Statistics::print(Inform &o, long (*filter)(long)) 
{
  int i, j;

  // If we have no stats, just return.
  
  if (statList_m.size() == 0)
    return;

  // For each statistic, print out the description, a set of ...'s, and
  // the stat, right-justified to 10 places.
  
  o << "Runtime statistics summary:" << std::endl;
  for (i = 0; i < statList_m.size(); ++i) 
    {
      o << statList_m[i]->description() << " ";

      int numperiods = 53 - strlen(statList_m[i]->description().c_str());
      if (numperiods < 2)
        numperiods = 2;
    
      for (j = 0; j < numperiods; ++j)
        o << ".";
      
      o << " " << std::setw(12) << filter(statList_m[i]->value()) << std::endl;
    }
}

} // namespace Pooma

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Statistics.cmpl.cpp,v $   $Author: swhaney $
// $Revision: 1.3 $   $Date: 2000/05/24 20:10:10 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
