// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Global TagGenerator
//-----------------------------------------------------------------------------

// include files

#include "Tulip/Messaging.h"
#include "Tulip/ReduceOverContexts.h"
#include "Tulip/RemoteProxy.h"
#include "Tulip/PatchSizeSyncer.h"

int  ReduceOverContextsBase::tagBase_m = 0;

bool RemoteProxyBase::ready_m;
int  RemoteProxyBase::tag_m = 0;

//-----------------------------------------------------------------------------
// Tag generator creates a set of tags for global use in r2.  There is a
// separate tag number for each context we communicate with.
//-----------------------------------------------------------------------------

TagGenerator tagGenerator_g;

namespace Pooma {

//-----------------------------------------------------------------------------
// expectedMessages
//-----------------------------------------------------------------------------

int expectedMessages_g = 0;

#if POOMA_CHEETAH
Cheetah::MatchingHandler *indexHandler_g        = 0;
Cheetah::MatchingHandler *reductionHandler_g    = 0;
Cheetah::MatchingHandler *remoteEngineHandler_g = 0;
Cheetah::MatchingHandler *particleSwapHandler_g = 0;
#endif

void initializeCheetahHelpers(int contexts)
{
  tagGenerator_g     = TagGenerator(contexts);
  expectedMessages_g = 0;
#if POOMA_CHEETAH
  indexHandler_g             = new Cheetah::MatchingHandler(*Pooma::controller());
  reductionHandler_g         = new Cheetah::MatchingHandler(*Pooma::controller());
  remoteEngineHandler_g      = new Cheetah::MatchingHandler(*Pooma::controller());
  particleSwapHandler_g      = new Cheetah::MatchingHandler(*Pooma::controller());
  PatchSizeSyncer::handler_s = new Cheetah::MatchingHandler(*Pooma::controller());
#endif
}

void finalizeCheetahHelpers()
{
  PAssert(expectedMessages_g == 0);
#if POOMA_CHEETAH
  if (indexHandler_g != 0)
    delete indexHandler_g;
  if (reductionHandler_g != 0)
    delete reductionHandler_g;
  if (remoteEngineHandler_g != 0)
    delete remoteEngineHandler_g;
  if (particleSwapHandler_g != 0)
    delete particleSwapHandler_g;
  if (PatchSizeSyncer::handler_s != 0)
    delete PatchSizeSyncer::handler_s;
#endif
}

int sendTag(int context)
{
  return tagGenerator_g.send(context);
}

int receiveTag(int context)
{
  return tagGenerator_g.receive(context);
}

} // namespace Pooma

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Messaging.cmpl.cpp,v $   $Author: rasmussn $
// $Revision: 1.5 $   $Date: 2000/05/03 19:17:35 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
