// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Tiny operations test
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Tiny/Vector.h"

const int D=3;
const int N=100;


int main()
{
  Vector<D> x[N];

  for (int i=0; i<N; ++i)
    for (int j=0; j<D; ++j)
      x[i](j) = rand();

  for (int i=0; i<N; ++i)
    {
      double n0 = norm2(x[i]);
      double n1 = norm(x[i]);
      double n2 = 0;
      for (int j=0; j<D; ++j)
	n2 += x[i](j)*x[i](j);
      if ( fabs(sqrt(n2) - n1)/n1 > 1e-12 )
	{
	  printf("FAILED\n");
	  exit(1);
        }
      if ( fabs(n2 - n0)/n0 > 1e-12 )
	{
	  printf("FAILED\n");
	  exit(1);
	}
    }
  printf("PASSED\n");

  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: norm.cpp,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/03/07 13:18:19 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
