// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_PARTITION_UNIFORM_MAPPER_H
#define POOMA_PARTITION_UNIFORM_MAPPER_H

//-----------------------------------------------------------------------------
// Classes:
//   UniformMapper
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Include Files
//-----------------------------------------------------------------------------

#include "Partition/ContextMapper.h"
#include "Domain/Interval.h"
#include "Domain/Loc.h"
#include "Layout/Node.h"

#include <vector>

//-----------------------------------------------------------------------------
// Overview:
//
// UniformMapper is a ContextMapper specifically for 1D patches.
// All it does is put a roughly equal number of patches on each context.
//-----------------------------------------------------------------------------

// namespace Pooma {

class UniformMapper
  : public ContextMapper<1>
{ 
public:
  //============================================================
  // Typedefs and enumerations
  //============================================================
  typedef Interval<1>                         Domain_t;
  typedef Node<Domain_t>                      Value_t;
  typedef std::vector<Value_t *>              List_t;

  template <class Partitioner>
  inline
  UniformMapper(const Partitioner& gp) 
    : blocks_m(gp.blocks())
  {
  }

  inline
  UniformMapper(const Loc<1>& blocks)
    : blocks_m(blocks)
  {
  }

  inline
  UniformMapper(int blocks = 1)
    : blocks_m(blocks)
  {
  }

  void map(const List_t&) const;

  // member data
private:

  Loc<1> blocks_m;
};


// } // namespace Pooma

//////////////////////////////////////////////////////////////////////

#endif // POOMA_PARTITION_UNIFORM_MAPPER_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: UniformMapper.h,v $   $Author: julianc $
// $Revision: 1.3 $   $Date: 2000/06/07 23:36:46 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
