// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// AttributeList method implementations.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Include Files
//-----------------------------------------------------------------------------

#include "Particles/AttributeList.h"

//-----------------------------------------------------------------------------
// Constructor.
// AttributeList just has a default constructor; it initially has
// no attributes at all.
//-----------------------------------------------------------------------------

AttributeList::AttributeList()
{
}


//-----------------------------------------------------------------------------
// Destructor.
// AttributeList will delete all attributes that it owns when
// it is deleted.
//-----------------------------------------------------------------------------

AttributeList::~AttributeList()
{
  while (size() > 0)
    remove(size() - 1);
}


//-----------------------------------------------------------------------------
// Remove the Nth attrib from our list, deleting it in the process.
// Return success.
//-----------------------------------------------------------------------------

bool AttributeList::remove(Size_t n)
{
  if (n < size())
    {
      delete attribute(n);
      list_m.erase(list_m.begin() + n);
      return true;
    }

  return false;
}


//-----------------------------------------------------------------------------
// Print out AttributeList to an ostream.
//-----------------------------------------------------------------------------

void AttributeList::print(std::ostream& o) const
{
  Size_t n = size();
  for (Size_t i = 0; i < n; ++i)
		{
			attribute(i)->print(o);
		}
	return;
}

//-----------------------------------------------------------------------------
//
// When AttributeList is passed to an ostream, call the print method.
//
//-----------------------------------------------------------------------------

std::ostream& operator<<(std::ostream& o, const AttributeList& alist)
{
  alist.print(o);
  return o;
}


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: AttributeList.cmpl.cpp,v $   $Author: swhaney $
// $Revision: 1.8 $   $Date: 2000/03/07 13:17:46 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
