// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// DynamicArray test 1: Create/destroy operations, using SharedBrick engines.
//-----------------------------------------------------------------------------

#include "Pooma/Pooma.h"
#include "Domain/Shrink.h"
#include "Utilities/Tester.h"


int main(int argc, char *argv[])
{
  // Initialize POOMA and output stream, using Tester class
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  tester.out() << argv[0] << ": Domain shrink and grow functions." << std::endl;
  tester.out() << "----------------------------------------------" << std::endl;

  int i;
  Interval<2> a1(10,10),a2(Interval<1>(5,20),Interval<1>(5,20));
  Interval<2> b,c;
  b = shrinkRight(a1,Loc<2>(1,1));
  c = shrinkRight(a2,Loc<2>(1,1));
  tester.out() << b << "," << c << std::endl;
  tester.check(b == Interval<2>(9,9));
  tester.check(c == Interval<2>(Interval<1>(5,19),Interval<1>(5,19)));

  Interval<2> d,e;
  d = growRight(b,Loc<2>(2,2));
  e = growRight(c,Loc<2>(2,2));
  tester.out() << d << "," << e << std::endl;
  tester.check(d == Interval<2>(11,11));
  tester.check(e == Interval<2>(Interval<1>(5,21),Interval<1>(5,21)));
  
  tester.check(true);

  // Return resulting error code and exit; Tester will shut down POOMA.

  tester.out() << "----------------------------------------------" << std::endl;
  int retval = tester.results("Domain shrink");
  Pooma::finalize();
  return retval;  
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: shrinktest.cpp,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/03/07 13:16:44 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
