// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
#include "Pooma/Pooma.h"
#include "Domain/Loc.h"
#include "Domain/Interval.h"
#include "Domain/Touches.h"
#include "Domain/Contains.h"
#include "Domain/Intersect.h"
#include "Domain/DomainMap.h"
#include <iostream>

#include "Utilities/Tester.h"

int main(int argc, char *argv[]) 
{

  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  tester.out() << "Starting domain map test." << std::endl << std::endl;

  typedef DomainMap<Interval<2>,int> DMap_t;
  typedef DMap_t::Value_t DPair_t;

  Interval<1> x(100),y(100);
  Interval<2> xy(x,y);
  DMap_t domainMap(xy);

  int foo[]={30,31,32,40,41,42,33,43};
  int i,j;
  for (i=0;i<10;++i)
  {
    Interval<1> x1(i*10,(i+1)*10-1);
    for (j=0; j<10; ++j)
    {
      Interval<1> y1(j*10,(j+1)*10-1);
      domainMap.insert(DPair_t(Interval<2>(x1,y1),j+i*10));
    }
  }
  domainMap.update();

  Interval<1> x2(32,48),y2(2,38);
  Interval<2> xy2(x2,y2);

  typedef DMap_t::Touch_t DMTouch_t;
  DMTouch_t touch = domainMap.touch(xy2);

  tester.out() << "finding domains that touch domain " << xy2 << std::endl;

  typedef DMap_t::touch_iterator iterator;
  iterator a;
  i=0;
  for (a=touch.first;a!=touch.second;++a)
  {    
    tester.out()<<"touches "<<(*a);
    tester.check("  :", (*a) == foo[i] );
  ++i;
  }

  int retval = tester.results("Domain Map");
  Pooma::finalize();
  return retval;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: domainmap.cpp,v $   $Author: swhaney $
// $Revision: 1.6 $   $Date: 2000/03/07 13:16:41 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
