// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

// include files
#include "Array/PrintArray.h"
#include "Utilities/Inform.h"

// Forward declarations

// ----------------------------------------------------------------------------
// dataBrowserPrintArray
// 
// A static (global) PrintArray, used by DataBrowser<ArrayPrintDataBrowser<> >
// to store persistent values of PrintArray formatting parameter
// settings. Global functions allow the debugger-user to interactively set the
// parameters, and use them for a set of interactive print calls:
// ----------------------------------------------------------------------------

PrintArray dataBrowserPrintArray;

// ----------------------------------------------------------------------------
// Global functions for setting formatting parameters, stored in
// dataBrowserPrintArray:
// ----------------------------------------------------------------------------

//int dbDomainWidth() const { return dataBrowserPrintArraydomainWidth(); }
// All the non-set functions were const like this; can't do it here somewhy.
int dbDomainWidth() { return dataBrowserPrintArray.domainWidth(); }
void dbSetDomainWidth(int val) { dataBrowserPrintArray.setDomainWidth(val); }
int dbDataWidth() { return dataBrowserPrintArray.dataWidth(); }
void dbSetDataWidth(int val) { dataBrowserPrintArray.setDataWidth(val); }
int dbDataPrecision() { return dataBrowserPrintArray.dataPrecision(); }
void dbSetDataPrecision(int val) {dataBrowserPrintArray.setDataPrecision(val);}
int dbCarReturn() { return dataBrowserPrintArray.carReturn();}
void dbSetCarReturn(int val) { dataBrowserPrintArray.setCarReturn(val); }
bool dbScientific() { return dataBrowserPrintArray.scientific(); }
void dbSetScientific(bool val) { dataBrowserPrintArray.setScientific(val); }
int dbSpacing() { return dataBrowserPrintArray.spacing(); }
void dbSetSpacing(int val) { dataBrowserPrintArray.setSpacing(val); }

// ----------------------------------------------------------------------------
// dataBrowserInform
// 
// A global Inform*, used by the dbprint() functions; this allows setting up
// for output to a file, or whatever, when using
// DataBrowser<ArrayPrintDataBrowser<> > printing, interactively, or from the
// debugger prompt. The secondary pointer dataBrowserInformBackup is used as
// temporary pointer value storage in the no-argment dbSetInform() function
// below.
// ----------------------------------------------------------------------------

Inform dataBrowserDefaultInform(NULL, 0);
Inform *dataBrowserInform = &dataBrowserDefaultInform;
Inform *dataBrowserInformBackup = &dataBrowserDefaultInform;

// ----------------------------------------------------------------------------
// dbSetInform()
// 
// A global function for setting the desired Inform object to be used by
// dbprint() functions, either interactively from the debugger prompt, or from
// within a code. For example, allows using an Inform object that writes to a
// file. The no-argument prototype allows swapping back and forth from a
// non-default Inform object to the default one, using dataBrowserInformBackup
// as temporary pointer value storage.
// ----------------------------------------------------------------------------

void dbSetInform(Inform &inform) { dataBrowserInform = &inform; }

// ----------------------------------------------------------------------------
// dbSwapInform()
// 
// Allows swapping back and forth from a non-default Inform object to the
// default one, using dataBrowserInformBackup as temporary pointer value
// storage.
// ----------------------------------------------------------------------------

void dbSwapInform() 
{ 
  if (dataBrowserInform == &dataBrowserDefaultInform) {
    if (dataBrowserInformBackup == dataBrowserInform) {
      return;
    } else {
      dataBrowserInform = dataBrowserInformBackup;
      dataBrowserInformBackup = &dataBrowserDefaultInform;
      return;
    }
  } else {
    dataBrowserInformBackup = dataBrowserInform;
    dataBrowserInform = &dataBrowserDefaultInform;
  }
}


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: DataBrowser.cmpl.cpp,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/03/07 13:16:30 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
