// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_CONNECT_CONNECT_PAIR_H
#define POOMA_CONNECT_CONNECT_PAIR_H

//-----------------------------------------------------------------------------
// Classes:
// ConnectPair<T1,T2>
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Overview:
//
// ConnectPair<T1,T2> stores two items of types T1 and T2, basically the
// same as std::pair from the STL.  The items are stored as copies.  The
// public interface is either methods first() and second(), or the two
// public data objects first_m and second_m.  This class is used for
// storing two items in a single object so that Connector can be specialized
// on the pair.
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Include Files
//-----------------------------------------------------------------------------


///////////////////////////////////////////////////////////////////////////////
// namespace POOMA {

template<class T1, class T2>
class ConnectPair
{
public:
  //============================================================
  // ConnectPair Constructor
  //============================================================

  // Initialize from the two objects, and store copies

  ConnectPair(const T1 &a, const T2 &b)
    : first_m(a), second_m(b)
  {
  }

  // Destructor does nothing special

  ~ConnectPair()
  {
  }

  //============================================================
  // ConnectPair accessors
  //============================================================

  // Return references to the two elements, first and second

  T1 &first()              { return first_m; }
  const T1 &first() const  { return first_m; }

  T2 &second()             { return second_m; }
  const T2 &second() const { return second_m; }

  //============================================================
  // ConnectPair public data
  //============================================================

  // The two elements in the pair - we make them public to match
  // the philosophy (but not the exact interface) of std::pair

  T1 first_m;
  T2 second_m;
};


// } // namespace POOMA

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_CONNECT_CONNECT_PAIR_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ConnectPair.h,v $   $Author: swhaney $
// $Revision: 1.2 $   $Date: 2000/03/07 13:16:16 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
