// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Array test 8: conformance tests.
//
// Note: exceptions are not thread safe so this program may not work in
//       in parallel.
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Engine/BrickEngine.h"
#include "Array/Array.h"

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  Array<1> x(7), y(7), z(6);
  
  y = 0;
  z = 0;

  // This test depends on bounds checking throwing an
  // exception.  For it to work, exceptions must be turned
  // on, bounds checking must be on and we can't be running
  // in parallel.

#if ! POOMA_THREADS
#if POOMA_EXCEPTIONS
#if POOMA_BOUNDS_CHECK

  bool worked = false;
  try {
    x = y + z;
  }
  catch (const Pooma::Assertion &) {
    worked = true;
  }
  tester.check(worked);

  Array<3> a(4,5,6), b(4,5,6), c(4,4,6), d(4,5,6);
  
  b = 0;
  c = 0;
  d = 0;
  
  worked = false;
  try {
    a = b + 3 * b + c - sin(d);
  }
  catch (const Pooma::Assertion &) {
    worked = true;
  }

  tester.check(worked);

#endif
#endif
#endif

  int ret = tester.results( "array_test8" );
  Pooma::finalize();
  return ret; 
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test8.cpp,v $   $Author: luchini $
// $Revision: 1.16 $   $Date: 2000/05/05 07:44:49 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
