// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Array test 17: expression engine revisited.
//-----------------------------------------------------------------------------

// Turn on bounds checking.

#undef POOMA_BOUNDS_CHECK
#undef POOMA_BOUNDS_CHECK_DEFAULT
#define POOMA_BOUNDS_CHECK POOMA_YES
#define POOMA_BOUNDS_CHECK_DEFAULT POOMA_TRUE

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Interval.h"
#include "Domain/Range.h"
#include "Engine/BrickEngine.h"
#include "Engine/ExpressionEngine.h"
#include "Array/Array.h"

#include <iostream>

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);
  
  Interval<1> I(5), J(1,3);
  Array<1> a(I), b(I), c(I-10);
  
  for (int i = 0; i < 5; i++)
    {
      b(i) = i;
      c(i - 10) = -2.0 * i * i;
    }

#if POOMA_EXCEPTIONS    
  try
#endif
    {
      a = -4.0 * (b + c());
      tester.out() << a << std::endl;
      a = 0;

      a(J) = -4.0 * (b + c())(J);
      tester.out() << a << std::endl;
    }
#if POOMA_EXCEPTIONS    
  catch(Pooma::Assertion &err)
    {
      err.print(tester.out());
      tester.out() << std::endl;
    }
#endif

  Range<1> R(0,4,2);
  Interval<2> II(I, I);
  Array<2> aa(II), bb(II), cc(I-10,I);
  
  for (int j = 0; j < 5; j++)
    for (int k = 0; k < 5; k++)
      {
        bb(j, k) = j + k;
        cc(j - 10, k) = -j + k * k;
      }

#if POOMA_EXCEPTIONS    
  try
#endif
    {
      aa = -4.0 * (bb + cc());
      tester.out() << aa << std::endl;
      aa = 0;

      aa(I, J) = -4.0 * (bb + cc())(I, J);
      tester.out() << aa << std::endl;
      aa = 0;

      aa(2, J) = -4.0 * (bb + cc())(2, J);
      tester.out() << aa << std::endl;
    }
#if POOMA_EXCEPTIONS    
  catch(Pooma::Assertion &err)
    {
      err.print(tester.out());
      tester.out() << std::endl;
    }
#endif
  
  int retval = tester.results("array_test17");    
  Pooma::finalize();
  
  return retval;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test17.cpp,v $   $Author: sa_smith $
// $Revision: 1.8 $   $Date: 2000/07/05 23:24:08 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
