/* Use GCC's internal _Unwind_Backtrace to provide backtrace.
 *
 * Copyright (c) 2007 Cavium Networks.
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

#include <stdio.h>
#include <stdarg.h>
#include <execinfo.h>

/* Details of the interface to libgcc's _Unwind_Backtrace.  */

#define _URC_NO_REASON		0
#define _URC_END_OF_STACK	5

struct _Unwind_Context;
typedef void *_Unwind_Ptr;
extern int
_Unwind_Backtrace (int (*) (struct _Unwind_Context *, void *), void *);
extern _Unwind_Ptr
_Unwind_GetIP (struct _Unwind_Context *);

/* Second arg to print_trace.  */

struct print_arg
{
  __octeon_backtrace_printf_t pf;
  int frame_num;
};

/* Helper function for the __octeon_print_backtrace* functions.  */

static int
print_trace (struct _Unwind_Context *context, void *arg)
{
  struct print_arg *pr_arg = arg;

  /* Ignore the __octeon_print_backtrace* frame.  */
  if (pr_arg->frame_num != -1)
    pr_arg->pf ("  #%d  %p\n", pr_arg->frame_num, _Unwind_GetIP (context));
  ++pr_arg->frame_num;

  return _URC_NO_REASON;
}

/* Print to stderr by default.  */

static int
default_printf (const char *p, ...)
{
  va_list ap;
  int ret;

  va_start (ap, p);
  ret = vprintf (p, ap);
  va_end (ap);

  return ret;
}

/* Print backtrace to stderr.  */

void
__octeon_print_backtrace (void)
{
  struct print_arg pr_arg = { default_printf, -1 };
  _Unwind_Backtrace (print_trace, &pr_arg);
  /* Don't call _Unwind_Backtrace as a tail call so that the first
     frame we ingore will be __octeon_print_backtrace.  */
  asm ("");
}

/* Print bactrace using custom printf-style function PF.  */
void
__octeon_print_backtrace_func (__octeon_backtrace_printf_t pf)
{
  struct print_arg pr_arg = { pf, -1 };
  _Unwind_Backtrace (print_trace, &pr_arg);
  /* Don't call _Unwind_Backtrace as a tail call so that the first
     frame we ingore will be __octeon_print_backtrace_func.  */
  asm ("");
}

/* Second argument to trace.  */

struct backtrace_arg
{
  void **buffer;
  int size;
  int frame_num;
};

/* Help function for backtrace.  */

static int
trace (struct _Unwind_Context *context, void *arg)
{
  struct backtrace_arg *bt_arg = arg;

  /* Ignore the __octeon_print_backtrace* frame.  */
  if (bt_arg->frame_num != -1)
    bt_arg->buffer[bt_arg->frame_num] = _Unwind_GetIP (context);
  if (++bt_arg->frame_num == bt_arg->size)
    return _URC_END_OF_STACK;

  return _URC_NO_REASON;
}

/* Similar to glibc's backtrace.  Return the list of pc in BUFFER
   where BUFFER is allocated to contain at most SIZE number of
   pointers.  */

int
backtrace (void **buffer, int size)
{
  struct backtrace_arg bt_arg = { buffer, size, -1 };
  _Unwind_Backtrace (trace, &bt_arg);
  return bt_arg.frame_num + 1;
}

/* We link to -lgcc -lc -lgcc.  -lc will add reference for
   _Unwind_Backtrace which will add reference for abort which would be
   missing.  Force inclusion of abort here.  */
extern void abort (void);
void (*dummy) (void) = abort;
