
using namespace System.Management.Automation
using namespace System.Management.Automation.Language

Register-ArgumentCompleter -Native -CommandName 'bite' -ScriptBlock {
    param($wordToComplete, $commandAst, $cursorPosition)

    $commandElements = $commandAst.CommandElements
    $command = @(
        'bite'
        for ($i = 1; $i -lt $commandElements.Count; $i++) {
            $element = $commandElements[$i]
            if ($element -isnot [StringConstantExpressionAst] -or
                $element.StringConstantType -ne [StringConstantType]::BareWord -or
                $element.Value.StartsWith('-') -or
                $element.Value -eq $wordToComplete) {
                break
        }
        $element.Value
    }) -join ';'

    $completions = @(switch ($command) {
        'bite' {
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('bugzilla', 'bugzilla', [CompletionResultType]::ParameterValue, 'bugzilla service support')
            [CompletionResult]::new('github', 'github', [CompletionResultType]::ParameterValue, 'github service support')
            [CompletionResult]::new('redmine', 'redmine', [CompletionResultType]::ParameterValue, 'redmine service support')
            [CompletionResult]::new('completion', 'completion', [CompletionResultType]::ParameterValue, 'generate shell completion')
            [CompletionResult]::new('show', 'show', [CompletionResultType]::ParameterValue, 'show service information')
            break
        }
        'bite;bugzilla' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'service connection')
            [CompletionResult]::new('--connection', '--connection', [CompletionResultType]::ParameterName, 'service connection')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'concurrent requests limit')
            [CompletionResult]::new('--concurrent', '--concurrent', [CompletionResultType]::ParameterName, 'concurrent requests limit')
            [CompletionResult]::new('--certificate', '--certificate', [CompletionResultType]::ParameterName, 'custom root certificate')
            [CompletionResult]::new('--proxy', '--proxy', [CompletionResultType]::ParameterName, 'custom proxy')
            [CompletionResult]::new('-t', '-t', [CompletionResultType]::ParameterName, 'request timeout in seconds')
            [CompletionResult]::new('--timeout', '--timeout', [CompletionResultType]::ParameterName, 'request timeout in seconds')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'API key')
            [CompletionResult]::new('--key', '--key', [CompletionResultType]::ParameterName, 'API key')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'username')
            [CompletionResult]::new('--user', '--user', [CompletionResultType]::ParameterName, 'username')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'password')
            [CompletionResult]::new('--password', '--password', [CompletionResultType]::ParameterName, 'password')
            [CompletionResult]::new('--insecure', '--insecure', [CompletionResultType]::ParameterName, 'ignore invalid service certificates')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('attachment', 'attachment', [CompletionResultType]::ParameterValue, 'Attachment commands')
            [CompletionResult]::new('a', 'a', [CompletionResultType]::ParameterValue, 'Attachment commands')
            [CompletionResult]::new('comment', 'comment', [CompletionResultType]::ParameterValue, 'Get bug comments')
            [CompletionResult]::new('create', 'create', [CompletionResultType]::ParameterValue, 'Create bug')
            [CompletionResult]::new('c', 'c', [CompletionResultType]::ParameterValue, 'Create bug')
            [CompletionResult]::new('fields', 'fields', [CompletionResultType]::ParameterValue, 'Get bugzilla fields')
            [CompletionResult]::new('get', 'get', [CompletionResultType]::ParameterValue, 'Get bugs')
            [CompletionResult]::new('g', 'g', [CompletionResultType]::ParameterValue, 'Get bugs')
            [CompletionResult]::new('history', 'history', [CompletionResultType]::ParameterValue, 'Get bug changes')
            [CompletionResult]::new('search', 'search', [CompletionResultType]::ParameterValue, 'Search bugs')
            [CompletionResult]::new('s', 's', [CompletionResultType]::ParameterValue, 'Search bugs')
            [CompletionResult]::new('update', 'update', [CompletionResultType]::ParameterValue, 'Update bugs')
            [CompletionResult]::new('u', 'u', [CompletionResultType]::ParameterValue, 'Update bugs')
            [CompletionResult]::new('version', 'version', [CompletionResultType]::ParameterValue, 'Get bugzilla version')
            break
        }
        'bite;bugzilla;attachment' {
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('create', 'create', [CompletionResultType]::ParameterValue, 'Create attachments')
            [CompletionResult]::new('c', 'c', [CompletionResultType]::ParameterValue, 'Create attachments')
            [CompletionResult]::new('get', 'get', [CompletionResultType]::ParameterValue, 'Get attachments')
            [CompletionResult]::new('g', 'g', [CompletionResultType]::ParameterValue, 'Get attachments')
            [CompletionResult]::new('update', 'update', [CompletionResultType]::ParameterValue, 'Update attachments')
            [CompletionResult]::new('u', 'u', [CompletionResultType]::ParameterValue, 'Update attachments')
            break
        }
        'bite;bugzilla;a' {
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('create', 'create', [CompletionResultType]::ParameterValue, 'Create attachments')
            [CompletionResult]::new('c', 'c', [CompletionResultType]::ParameterValue, 'Create attachments')
            [CompletionResult]::new('get', 'get', [CompletionResultType]::ParameterValue, 'Get attachments')
            [CompletionResult]::new('g', 'g', [CompletionResultType]::ParameterValue, 'Get attachments')
            [CompletionResult]::new('update', 'update', [CompletionResultType]::ParameterValue, 'Update attachments')
            [CompletionResult]::new('u', 'u', [CompletionResultType]::ParameterValue, 'Update attachments')
            break
        }
        'bite;bugzilla;attachment;create' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'attachment comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'attachment comment')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'attachment description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'attachment description')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'attachment flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'attachment flags')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'attachment MIME type')
            [CompletionResult]::new('--mime', '--mime', [CompletionResultType]::ParameterName, 'attachment MIME type')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'attachment file name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'attachment file name')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'attachment is a patch')
            [CompletionResult]::new('--patch', '--patch', [CompletionResultType]::ParameterName, 'attachment is a patch')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'attachment is private')
            [CompletionResult]::new('--private', '--private', [CompletionResultType]::ParameterName, 'attachment is private')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'compress attachment')
            [CompletionResult]::new('--compress', '--compress', [CompletionResultType]::ParameterName, 'compress attachment')
            [CompletionResult]::new('--auto-compress', '--auto-compress', [CompletionResultType]::ParameterName, 'auto-compress attachment')
            [CompletionResult]::new('--auto-truncate', '--auto-truncate', [CompletionResultType]::ParameterName, 'auto-truncate text attachment')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;attachment;c' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'attachment comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'attachment comment')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'attachment description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'attachment description')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'attachment flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'attachment flags')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'attachment MIME type')
            [CompletionResult]::new('--mime', '--mime', [CompletionResultType]::ParameterName, 'attachment MIME type')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'attachment file name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'attachment file name')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'attachment is a patch')
            [CompletionResult]::new('--patch', '--patch', [CompletionResultType]::ParameterName, 'attachment is a patch')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'attachment is private')
            [CompletionResult]::new('--private', '--private', [CompletionResultType]::ParameterName, 'attachment is private')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'compress attachment')
            [CompletionResult]::new('--compress', '--compress', [CompletionResultType]::ParameterName, 'compress attachment')
            [CompletionResult]::new('--auto-compress', '--auto-compress', [CompletionResultType]::ParameterName, 'auto-compress attachment')
            [CompletionResult]::new('--auto-truncate', '--auto-truncate', [CompletionResultType]::ParameterName, 'auto-truncate text attachment')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;a;create' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'attachment comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'attachment comment')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'attachment description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'attachment description')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'attachment flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'attachment flags')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'attachment MIME type')
            [CompletionResult]::new('--mime', '--mime', [CompletionResultType]::ParameterName, 'attachment MIME type')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'attachment file name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'attachment file name')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'attachment is a patch')
            [CompletionResult]::new('--patch', '--patch', [CompletionResultType]::ParameterName, 'attachment is a patch')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'attachment is private')
            [CompletionResult]::new('--private', '--private', [CompletionResultType]::ParameterName, 'attachment is private')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'compress attachment')
            [CompletionResult]::new('--compress', '--compress', [CompletionResultType]::ParameterName, 'compress attachment')
            [CompletionResult]::new('--auto-compress', '--auto-compress', [CompletionResultType]::ParameterName, 'auto-compress attachment')
            [CompletionResult]::new('--auto-truncate', '--auto-truncate', [CompletionResultType]::ParameterName, 'auto-truncate text attachment')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;a;c' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'attachment comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'attachment comment')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'attachment description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'attachment description')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'attachment flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'attachment flags')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'attachment MIME type')
            [CompletionResult]::new('--mime', '--mime', [CompletionResultType]::ParameterName, 'attachment MIME type')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'attachment file name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'attachment file name')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'attachment is a patch')
            [CompletionResult]::new('--patch', '--patch', [CompletionResultType]::ParameterName, 'attachment is a patch')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'attachment is private')
            [CompletionResult]::new('--private', '--private', [CompletionResultType]::ParameterName, 'attachment is private')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'compress attachment')
            [CompletionResult]::new('--compress', '--compress', [CompletionResultType]::ParameterName, 'compress attachment')
            [CompletionResult]::new('--auto-compress', '--auto-compress', [CompletionResultType]::ParameterName, 'auto-compress attachment')
            [CompletionResult]::new('--auto-truncate', '--auto-truncate', [CompletionResultType]::ParameterName, 'auto-truncate text attachment')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;attachment;get' {
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'output attachment data')
            [CompletionResult]::new('--output', '--output', [CompletionResultType]::ParameterName, 'output attachment data')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'save attachments into a base directory')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'save attachments into a base directory')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'list attachment metadata')
            [CompletionResult]::new('--list', '--list', [CompletionResultType]::ParameterName, 'list attachment metadata')
            [CompletionResult]::new('-O', '-O ', [CompletionResultType]::ParameterName, 'include outdated attachments')
            [CompletionResult]::new('--outdated', '--outdated', [CompletionResultType]::ParameterName, 'include outdated attachments')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'request attachments from bug IDs or aliases')
            [CompletionResult]::new('--item-ids', '--item-ids', [CompletionResultType]::ParameterName, 'request attachments from bug IDs or aliases')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;attachment;g' {
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'output attachment data')
            [CompletionResult]::new('--output', '--output', [CompletionResultType]::ParameterName, 'output attachment data')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'save attachments into a base directory')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'save attachments into a base directory')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'list attachment metadata')
            [CompletionResult]::new('--list', '--list', [CompletionResultType]::ParameterName, 'list attachment metadata')
            [CompletionResult]::new('-O', '-O ', [CompletionResultType]::ParameterName, 'include outdated attachments')
            [CompletionResult]::new('--outdated', '--outdated', [CompletionResultType]::ParameterName, 'include outdated attachments')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'request attachments from bug IDs or aliases')
            [CompletionResult]::new('--item-ids', '--item-ids', [CompletionResultType]::ParameterName, 'request attachments from bug IDs or aliases')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;a;get' {
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'output attachment data')
            [CompletionResult]::new('--output', '--output', [CompletionResultType]::ParameterName, 'output attachment data')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'save attachments into a base directory')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'save attachments into a base directory')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'list attachment metadata')
            [CompletionResult]::new('--list', '--list', [CompletionResultType]::ParameterName, 'list attachment metadata')
            [CompletionResult]::new('-O', '-O ', [CompletionResultType]::ParameterName, 'include outdated attachments')
            [CompletionResult]::new('--outdated', '--outdated', [CompletionResultType]::ParameterName, 'include outdated attachments')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'request attachments from bug IDs or aliases')
            [CompletionResult]::new('--item-ids', '--item-ids', [CompletionResultType]::ParameterName, 'request attachments from bug IDs or aliases')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;a;g' {
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'output attachment data')
            [CompletionResult]::new('--output', '--output', [CompletionResultType]::ParameterName, 'output attachment data')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'save attachments into a base directory')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'save attachments into a base directory')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'list attachment metadata')
            [CompletionResult]::new('--list', '--list', [CompletionResultType]::ParameterName, 'list attachment metadata')
            [CompletionResult]::new('-O', '-O ', [CompletionResultType]::ParameterName, 'include outdated attachments')
            [CompletionResult]::new('--outdated', '--outdated', [CompletionResultType]::ParameterName, 'include outdated attachments')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'request attachments from bug IDs or aliases')
            [CompletionResult]::new('--item-ids', '--item-ids', [CompletionResultType]::ParameterName, 'request attachments from bug IDs or aliases')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;attachment;update' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'update comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'update comment')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'update description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'update description')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'update flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'update flags')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'update MIME type')
            [CompletionResult]::new('--mime', '--mime', [CompletionResultType]::ParameterName, 'update MIME type')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'update file name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'update file name')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'update obsolete status')
            [CompletionResult]::new('--obsolete', '--obsolete', [CompletionResultType]::ParameterName, 'update obsolete status')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'update patch status')
            [CompletionResult]::new('--patch', '--patch', [CompletionResultType]::ParameterName, 'update patch status')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'update private status')
            [CompletionResult]::new('--private', '--private', [CompletionResultType]::ParameterName, 'update private status')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;attachment;u' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'update comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'update comment')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'update description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'update description')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'update flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'update flags')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'update MIME type')
            [CompletionResult]::new('--mime', '--mime', [CompletionResultType]::ParameterName, 'update MIME type')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'update file name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'update file name')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'update obsolete status')
            [CompletionResult]::new('--obsolete', '--obsolete', [CompletionResultType]::ParameterName, 'update obsolete status')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'update patch status')
            [CompletionResult]::new('--patch', '--patch', [CompletionResultType]::ParameterName, 'update patch status')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'update private status')
            [CompletionResult]::new('--private', '--private', [CompletionResultType]::ParameterName, 'update private status')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;a;update' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'update comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'update comment')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'update description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'update description')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'update flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'update flags')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'update MIME type')
            [CompletionResult]::new('--mime', '--mime', [CompletionResultType]::ParameterName, 'update MIME type')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'update file name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'update file name')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'update obsolete status')
            [CompletionResult]::new('--obsolete', '--obsolete', [CompletionResultType]::ParameterName, 'update obsolete status')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'update patch status')
            [CompletionResult]::new('--patch', '--patch', [CompletionResultType]::ParameterName, 'update patch status')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'update private status')
            [CompletionResult]::new('--private', '--private', [CompletionResultType]::ParameterName, 'update private status')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;a;u' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'update comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'update comment')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'update description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'update description')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'update flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'update flags')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'update MIME type')
            [CompletionResult]::new('--mime', '--mime', [CompletionResultType]::ParameterName, 'update MIME type')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'update file name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'update file name')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'update obsolete status')
            [CompletionResult]::new('--obsolete', '--obsolete', [CompletionResultType]::ParameterName, 'update obsolete status')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'update patch status')
            [CompletionResult]::new('--patch', '--patch', [CompletionResultType]::ParameterName, 'update patch status')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'update private status')
            [CompletionResult]::new('--private', '--private', [CompletionResultType]::ParameterName, 'update private status')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;comment' {
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'comment includes attachment')
            [CompletionResult]::new('--attachment', '--attachment', [CompletionResultType]::ParameterName, 'comment includes attachment')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'comment created at this time or later')
            [CompletionResult]::new('--created', '--created', [CompletionResultType]::ParameterName, 'comment created at this time or later')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'user who commented')
            [CompletionResult]::new('--creator', '--creator', [CompletionResultType]::ParameterName, 'user who commented')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;create' {
            [CompletionResult]::new('--from-bug', '--from-bug', [CompletionResultType]::ParameterName, 'read attributes from an existing bug')
            [CompletionResult]::new('--from', '--from', [CompletionResultType]::ParameterName, 'read attributes from templates')
            [CompletionResult]::new('--to', '--to', [CompletionResultType]::ParameterName, 'write attributes to template')
            [CompletionResult]::new('-A', '-A ', [CompletionResultType]::ParameterName, 'set aliases')
            [CompletionResult]::new('--alias', '--alias', [CompletionResultType]::ParameterName, 'set aliases')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'set assignee')
            [CompletionResult]::new('--assignee', '--assignee', [CompletionResultType]::ParameterName, 'set assignee')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'set blockers')
            [CompletionResult]::new('--blocks', '--blocks', [CompletionResultType]::ParameterName, 'set blockers')
            [CompletionResult]::new('--cc', '--cc', [CompletionResultType]::ParameterName, 'set CC users')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'set component')
            [CompletionResult]::new('--component', '--component', [CompletionResultType]::ParameterName, 'set component')
            [CompletionResult]::new('--cf', '--cf', [CompletionResultType]::ParameterName, 'set custom field')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'set dependencies')
            [CompletionResult]::new('--depends', '--depends', [CompletionResultType]::ParameterName, 'set dependencies')
            [CompletionResult]::new('-D', '-D ', [CompletionResultType]::ParameterName, 'set description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'set description')
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'set flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'set flags')
            [CompletionResult]::new('-g', '-g', [CompletionResultType]::ParameterName, 'set groups')
            [CompletionResult]::new('--groups', '--groups', [CompletionResultType]::ParameterName, 'set groups')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'set keywords')
            [CompletionResult]::new('--keywords', '--keywords', [CompletionResultType]::ParameterName, 'set keywords')
            [CompletionResult]::new('--os', '--os', [CompletionResultType]::ParameterName, 'set operating system')
            [CompletionResult]::new('--platform', '--platform', [CompletionResultType]::ParameterName, 'set platform')
            [CompletionResult]::new('--priority', '--priority', [CompletionResultType]::ParameterName, 'set priority')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'set product')
            [CompletionResult]::new('--product', '--product', [CompletionResultType]::ParameterName, 'set product')
            [CompletionResult]::new('--qa', '--qa', [CompletionResultType]::ParameterName, 'set QA contact')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'set resolution')
            [CompletionResult]::new('--resolution', '--resolution', [CompletionResultType]::ParameterName, 'set resolution')
            [CompletionResult]::new('-U', '-U ', [CompletionResultType]::ParameterName, 'set external bug URLs')
            [CompletionResult]::new('--see-also', '--see-also', [CompletionResultType]::ParameterName, 'set external bug URLs')
            [CompletionResult]::new('--severity', '--severity', [CompletionResultType]::ParameterName, 'set severity')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'set status')
            [CompletionResult]::new('--status', '--status', [CompletionResultType]::ParameterName, 'set status')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'set summary')
            [CompletionResult]::new('--summary', '--summary', [CompletionResultType]::ParameterName, 'set summary')
            [CompletionResult]::new('-T', '-T ', [CompletionResultType]::ParameterName, 'set target milestone')
            [CompletionResult]::new('--target', '--target', [CompletionResultType]::ParameterName, 'set target milestone')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'set URL')
            [CompletionResult]::new('--url', '--url', [CompletionResultType]::ParameterName, 'set URL')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'set version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'set version')
            [CompletionResult]::new('-w', '-w', [CompletionResultType]::ParameterName, 'set whiteboard')
            [CompletionResult]::new('--whiteboard', '--whiteboard', [CompletionResultType]::ParameterName, 'set whiteboard')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--dry-run', '--dry-run', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;c' {
            [CompletionResult]::new('--from-bug', '--from-bug', [CompletionResultType]::ParameterName, 'read attributes from an existing bug')
            [CompletionResult]::new('--from', '--from', [CompletionResultType]::ParameterName, 'read attributes from templates')
            [CompletionResult]::new('--to', '--to', [CompletionResultType]::ParameterName, 'write attributes to template')
            [CompletionResult]::new('-A', '-A ', [CompletionResultType]::ParameterName, 'set aliases')
            [CompletionResult]::new('--alias', '--alias', [CompletionResultType]::ParameterName, 'set aliases')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'set assignee')
            [CompletionResult]::new('--assignee', '--assignee', [CompletionResultType]::ParameterName, 'set assignee')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'set blockers')
            [CompletionResult]::new('--blocks', '--blocks', [CompletionResultType]::ParameterName, 'set blockers')
            [CompletionResult]::new('--cc', '--cc', [CompletionResultType]::ParameterName, 'set CC users')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'set component')
            [CompletionResult]::new('--component', '--component', [CompletionResultType]::ParameterName, 'set component')
            [CompletionResult]::new('--cf', '--cf', [CompletionResultType]::ParameterName, 'set custom field')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'set dependencies')
            [CompletionResult]::new('--depends', '--depends', [CompletionResultType]::ParameterName, 'set dependencies')
            [CompletionResult]::new('-D', '-D ', [CompletionResultType]::ParameterName, 'set description')
            [CompletionResult]::new('--description', '--description', [CompletionResultType]::ParameterName, 'set description')
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'set flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'set flags')
            [CompletionResult]::new('-g', '-g', [CompletionResultType]::ParameterName, 'set groups')
            [CompletionResult]::new('--groups', '--groups', [CompletionResultType]::ParameterName, 'set groups')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'set keywords')
            [CompletionResult]::new('--keywords', '--keywords', [CompletionResultType]::ParameterName, 'set keywords')
            [CompletionResult]::new('--os', '--os', [CompletionResultType]::ParameterName, 'set operating system')
            [CompletionResult]::new('--platform', '--platform', [CompletionResultType]::ParameterName, 'set platform')
            [CompletionResult]::new('--priority', '--priority', [CompletionResultType]::ParameterName, 'set priority')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'set product')
            [CompletionResult]::new('--product', '--product', [CompletionResultType]::ParameterName, 'set product')
            [CompletionResult]::new('--qa', '--qa', [CompletionResultType]::ParameterName, 'set QA contact')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'set resolution')
            [CompletionResult]::new('--resolution', '--resolution', [CompletionResultType]::ParameterName, 'set resolution')
            [CompletionResult]::new('-U', '-U ', [CompletionResultType]::ParameterName, 'set external bug URLs')
            [CompletionResult]::new('--see-also', '--see-also', [CompletionResultType]::ParameterName, 'set external bug URLs')
            [CompletionResult]::new('--severity', '--severity', [CompletionResultType]::ParameterName, 'set severity')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'set status')
            [CompletionResult]::new('--status', '--status', [CompletionResultType]::ParameterName, 'set status')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'set summary')
            [CompletionResult]::new('--summary', '--summary', [CompletionResultType]::ParameterName, 'set summary')
            [CompletionResult]::new('-T', '-T ', [CompletionResultType]::ParameterName, 'set target milestone')
            [CompletionResult]::new('--target', '--target', [CompletionResultType]::ParameterName, 'set target milestone')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'set URL')
            [CompletionResult]::new('--url', '--url', [CompletionResultType]::ParameterName, 'set URL')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'set version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'set version')
            [CompletionResult]::new('-w', '-w', [CompletionResultType]::ParameterName, 'set whiteboard')
            [CompletionResult]::new('--whiteboard', '--whiteboard', [CompletionResultType]::ParameterName, 'set whiteboard')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--dry-run', '--dry-run', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;fields' {
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;get' {
            [CompletionResult]::new('-A', '-A ', [CompletionResultType]::ParameterName, 'disable attachments')
            [CompletionResult]::new('--no-attachments', '--no-attachments', [CompletionResultType]::ParameterName, 'disable attachments')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'disable comments')
            [CompletionResult]::new('--no-comments', '--no-comments', [CompletionResultType]::ParameterName, 'disable comments')
            [CompletionResult]::new('-H', '-H ', [CompletionResultType]::ParameterName, 'disable history')
            [CompletionResult]::new('--no-history', '--no-history', [CompletionResultType]::ParameterName, 'disable history')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;g' {
            [CompletionResult]::new('-A', '-A ', [CompletionResultType]::ParameterName, 'disable attachments')
            [CompletionResult]::new('--no-attachments', '--no-attachments', [CompletionResultType]::ParameterName, 'disable attachments')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'disable comments')
            [CompletionResult]::new('--no-comments', '--no-comments', [CompletionResultType]::ParameterName, 'disable comments')
            [CompletionResult]::new('-H', '-H ', [CompletionResultType]::ParameterName, 'disable history')
            [CompletionResult]::new('--no-history', '--no-history', [CompletionResultType]::ParameterName, 'disable history')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;history' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'event occurred at this time or later')
            [CompletionResult]::new('--created', '--created', [CompletionResultType]::ParameterName, 'event occurred at this time or later')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'user who made change')
            [CompletionResult]::new('--creator', '--creator', [CompletionResultType]::ParameterName, 'user who made change')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;search' {
            [CompletionResult]::new('--from', '--from', [CompletionResultType]::ParameterName, 'read attributes from templates')
            [CompletionResult]::new('--to', '--to', [CompletionResultType]::ParameterName, 'write attributes to template')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('--fields', '--fields', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'limit result count')
            [CompletionResult]::new('--limit', '--limit', [CompletionResultType]::ParameterName, 'limit result count')
            [CompletionResult]::new('-O', '-O ', [CompletionResultType]::ParameterName, 'result starting position')
            [CompletionResult]::new('--offset', '--offset', [CompletionResultType]::ParameterName, 'result starting position')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'order query results')
            [CompletionResult]::new('--order', '--order', [CompletionResultType]::ParameterName, 'order query results')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'search using quicksearch syntax')
            [CompletionResult]::new('--quicksearch', '--quicksearch', [CompletionResultType]::ParameterName, 'search using quicksearch syntax')
            [CompletionResult]::new('-A', '-A ', [CompletionResultType]::ParameterName, 'restrict by alias')
            [CompletionResult]::new('--alias', '--alias', [CompletionResultType]::ParameterName, 'restrict by alias')
            [CompletionResult]::new('-@', '-@', [CompletionResultType]::ParameterName, 'restrict by attachments')
            [CompletionResult]::new('--attachments', '--attachments', [CompletionResultType]::ParameterName, 'restrict by attachments')
            [CompletionResult]::new('-B', '-B ', [CompletionResultType]::ParameterName, 'restrict by blockers')
            [CompletionResult]::new('--blocks', '--blocks', [CompletionResultType]::ParameterName, 'restrict by blockers')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'restrict by component')
            [CompletionResult]::new('--component', '--component', [CompletionResultType]::ParameterName, 'restrict by component')
            [CompletionResult]::new('--cf', '--cf', [CompletionResultType]::ParameterName, 'restrict by custom field')
            [CompletionResult]::new('-D', '-D ', [CompletionResultType]::ParameterName, 'restrict by dependencies')
            [CompletionResult]::new('--depends', '--depends', [CompletionResultType]::ParameterName, 'restrict by dependencies')
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'restrict by flag')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'restrict by flag')
            [CompletionResult]::new('-g', '-g', [CompletionResultType]::ParameterName, 'restrict by group')
            [CompletionResult]::new('--groups', '--groups', [CompletionResultType]::ParameterName, 'restrict by group')
            [CompletionResult]::new('--id', '--id', [CompletionResultType]::ParameterName, 'restrict by ID')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'restrict by keyword')
            [CompletionResult]::new('--keywords', '--keywords', [CompletionResultType]::ParameterName, 'restrict by keyword')
            [CompletionResult]::new('--os', '--os', [CompletionResultType]::ParameterName, 'restrict by operating system')
            [CompletionResult]::new('--platform', '--platform', [CompletionResultType]::ParameterName, 'restrict by platform')
            [CompletionResult]::new('--priority', '--priority', [CompletionResultType]::ParameterName, 'restrict by priority')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'restrict by product')
            [CompletionResult]::new('--product', '--product', [CompletionResultType]::ParameterName, 'restrict by product')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'restrict by resolution')
            [CompletionResult]::new('--resolution', '--resolution', [CompletionResultType]::ParameterName, 'restrict by resolution')
            [CompletionResult]::new('-U', '-U ', [CompletionResultType]::ParameterName, 'restrict by tracker URLs')
            [CompletionResult]::new('--see-also', '--see-also', [CompletionResultType]::ParameterName, 'restrict by tracker URLs')
            [CompletionResult]::new('--severity', '--severity', [CompletionResultType]::ParameterName, 'restrict by severity')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'restrict by status')
            [CompletionResult]::new('--status', '--status', [CompletionResultType]::ParameterName, 'restrict by status')
            [CompletionResult]::new('-t', '-t', [CompletionResultType]::ParameterName, 'restrict by personal tags')
            [CompletionResult]::new('--tags', '--tags', [CompletionResultType]::ParameterName, 'restrict by personal tags')
            [CompletionResult]::new('-T', '-T ', [CompletionResultType]::ParameterName, 'restrict by target milestone')
            [CompletionResult]::new('--target', '--target', [CompletionResultType]::ParameterName, 'restrict by target milestone')
            [CompletionResult]::new('--url', '--url', [CompletionResultType]::ParameterName, 'restrict by URL')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'restrict by version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'restrict by version')
            [CompletionResult]::new('-w', '-w', [CompletionResultType]::ParameterName, 'restrict by whiteboard')
            [CompletionResult]::new('--whiteboard', '--whiteboard', [CompletionResultType]::ParameterName, 'restrict by whiteboard')
            [CompletionResult]::new('--attachment-description', '--attachment-description', [CompletionResultType]::ParameterName, 'restrict by description')
            [CompletionResult]::new('--attachment-filename', '--attachment-filename', [CompletionResultType]::ParameterName, 'restrict by file name')
            [CompletionResult]::new('--attachment-mime', '--attachment-mime', [CompletionResultType]::ParameterName, 'restrict by MIME type')
            [CompletionResult]::new('--attachment-is-obsolete', '--attachment-is-obsolete', [CompletionResultType]::ParameterName, 'restrict by obsolete status')
            [CompletionResult]::new('--attachment-is-patch', '--attachment-is-patch', [CompletionResultType]::ParameterName, 'restrict by patch status')
            [CompletionResult]::new('--attachment-is-private', '--attachment-is-private', [CompletionResultType]::ParameterName, 'restrict by private status')
            [CompletionResult]::new('--comments', '--comments', [CompletionResultType]::ParameterName, 'restrict by comment count')
            [CompletionResult]::new('--votes', '--votes', [CompletionResultType]::ParameterName, 'restrict by vote count')
            [CompletionResult]::new('--changed', '--changed', [CompletionResultType]::ParameterName, 'fields changed within time interval')
            [CompletionResult]::new('--changed-by', '--changed-by', [CompletionResultType]::ParameterName, 'fields changed by users')
            [CompletionResult]::new('--changed-from', '--changed-from', [CompletionResultType]::ParameterName, 'fields changed from value')
            [CompletionResult]::new('--changed-to', '--changed-to', [CompletionResultType]::ParameterName, 'fields changed to value')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'restrict by creation time')
            [CompletionResult]::new('--created', '--created', [CompletionResultType]::ParameterName, 'restrict by creation time')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'restrict by update time')
            [CompletionResult]::new('--updated', '--updated', [CompletionResultType]::ParameterName, 'restrict by update time')
            [CompletionResult]::new('--closed', '--closed', [CompletionResultType]::ParameterName, 'restrict by closed time')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'user is assignee')
            [CompletionResult]::new('--assignee', '--assignee', [CompletionResultType]::ParameterName, 'user is assignee')
            [CompletionResult]::new('--attacher', '--attacher', [CompletionResultType]::ParameterName, 'user created attachment')
            [CompletionResult]::new('--cc', '--cc', [CompletionResultType]::ParameterName, 'user in CC list')
            [CompletionResult]::new('--commenter', '--commenter', [CompletionResultType]::ParameterName, 'user who commented')
            [CompletionResult]::new('--flagger', '--flagger', [CompletionResultType]::ParameterName, 'user who set flag')
            [CompletionResult]::new('--qa', '--qa', [CompletionResultType]::ParameterName, 'user is QA contact')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'user who reported')
            [CompletionResult]::new('--reporter', '--reporter', [CompletionResultType]::ParameterName, 'user who reported')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'restrict by comment content')
            [CompletionResult]::new('--comment-is-private', '--comment-is-private', [CompletionResultType]::ParameterName, 'restrict by private status')
            [CompletionResult]::new('--comment-tag', '--comment-tag', [CompletionResultType]::ParameterName, 'restrict by tag')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--json', '--json', [CompletionResultType]::ParameterName, 'output in JSON format')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--dry-run', '--dry-run', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--paged', '--paged', [CompletionResultType]::ParameterName, 'enable paging support')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;s' {
            [CompletionResult]::new('--from', '--from', [CompletionResultType]::ParameterName, 'read attributes from templates')
            [CompletionResult]::new('--to', '--to', [CompletionResultType]::ParameterName, 'write attributes to template')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('--fields', '--fields', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'limit result count')
            [CompletionResult]::new('--limit', '--limit', [CompletionResultType]::ParameterName, 'limit result count')
            [CompletionResult]::new('-O', '-O ', [CompletionResultType]::ParameterName, 'result starting position')
            [CompletionResult]::new('--offset', '--offset', [CompletionResultType]::ParameterName, 'result starting position')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'order query results')
            [CompletionResult]::new('--order', '--order', [CompletionResultType]::ParameterName, 'order query results')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'search using quicksearch syntax')
            [CompletionResult]::new('--quicksearch', '--quicksearch', [CompletionResultType]::ParameterName, 'search using quicksearch syntax')
            [CompletionResult]::new('-A', '-A ', [CompletionResultType]::ParameterName, 'restrict by alias')
            [CompletionResult]::new('--alias', '--alias', [CompletionResultType]::ParameterName, 'restrict by alias')
            [CompletionResult]::new('-@', '-@', [CompletionResultType]::ParameterName, 'restrict by attachments')
            [CompletionResult]::new('--attachments', '--attachments', [CompletionResultType]::ParameterName, 'restrict by attachments')
            [CompletionResult]::new('-B', '-B ', [CompletionResultType]::ParameterName, 'restrict by blockers')
            [CompletionResult]::new('--blocks', '--blocks', [CompletionResultType]::ParameterName, 'restrict by blockers')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'restrict by component')
            [CompletionResult]::new('--component', '--component', [CompletionResultType]::ParameterName, 'restrict by component')
            [CompletionResult]::new('--cf', '--cf', [CompletionResultType]::ParameterName, 'restrict by custom field')
            [CompletionResult]::new('-D', '-D ', [CompletionResultType]::ParameterName, 'restrict by dependencies')
            [CompletionResult]::new('--depends', '--depends', [CompletionResultType]::ParameterName, 'restrict by dependencies')
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'restrict by flag')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'restrict by flag')
            [CompletionResult]::new('-g', '-g', [CompletionResultType]::ParameterName, 'restrict by group')
            [CompletionResult]::new('--groups', '--groups', [CompletionResultType]::ParameterName, 'restrict by group')
            [CompletionResult]::new('--id', '--id', [CompletionResultType]::ParameterName, 'restrict by ID')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'restrict by keyword')
            [CompletionResult]::new('--keywords', '--keywords', [CompletionResultType]::ParameterName, 'restrict by keyword')
            [CompletionResult]::new('--os', '--os', [CompletionResultType]::ParameterName, 'restrict by operating system')
            [CompletionResult]::new('--platform', '--platform', [CompletionResultType]::ParameterName, 'restrict by platform')
            [CompletionResult]::new('--priority', '--priority', [CompletionResultType]::ParameterName, 'restrict by priority')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'restrict by product')
            [CompletionResult]::new('--product', '--product', [CompletionResultType]::ParameterName, 'restrict by product')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'restrict by resolution')
            [CompletionResult]::new('--resolution', '--resolution', [CompletionResultType]::ParameterName, 'restrict by resolution')
            [CompletionResult]::new('-U', '-U ', [CompletionResultType]::ParameterName, 'restrict by tracker URLs')
            [CompletionResult]::new('--see-also', '--see-also', [CompletionResultType]::ParameterName, 'restrict by tracker URLs')
            [CompletionResult]::new('--severity', '--severity', [CompletionResultType]::ParameterName, 'restrict by severity')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'restrict by status')
            [CompletionResult]::new('--status', '--status', [CompletionResultType]::ParameterName, 'restrict by status')
            [CompletionResult]::new('-t', '-t', [CompletionResultType]::ParameterName, 'restrict by personal tags')
            [CompletionResult]::new('--tags', '--tags', [CompletionResultType]::ParameterName, 'restrict by personal tags')
            [CompletionResult]::new('-T', '-T ', [CompletionResultType]::ParameterName, 'restrict by target milestone')
            [CompletionResult]::new('--target', '--target', [CompletionResultType]::ParameterName, 'restrict by target milestone')
            [CompletionResult]::new('--url', '--url', [CompletionResultType]::ParameterName, 'restrict by URL')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'restrict by version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'restrict by version')
            [CompletionResult]::new('-w', '-w', [CompletionResultType]::ParameterName, 'restrict by whiteboard')
            [CompletionResult]::new('--whiteboard', '--whiteboard', [CompletionResultType]::ParameterName, 'restrict by whiteboard')
            [CompletionResult]::new('--attachment-description', '--attachment-description', [CompletionResultType]::ParameterName, 'restrict by description')
            [CompletionResult]::new('--attachment-filename', '--attachment-filename', [CompletionResultType]::ParameterName, 'restrict by file name')
            [CompletionResult]::new('--attachment-mime', '--attachment-mime', [CompletionResultType]::ParameterName, 'restrict by MIME type')
            [CompletionResult]::new('--attachment-is-obsolete', '--attachment-is-obsolete', [CompletionResultType]::ParameterName, 'restrict by obsolete status')
            [CompletionResult]::new('--attachment-is-patch', '--attachment-is-patch', [CompletionResultType]::ParameterName, 'restrict by patch status')
            [CompletionResult]::new('--attachment-is-private', '--attachment-is-private', [CompletionResultType]::ParameterName, 'restrict by private status')
            [CompletionResult]::new('--comments', '--comments', [CompletionResultType]::ParameterName, 'restrict by comment count')
            [CompletionResult]::new('--votes', '--votes', [CompletionResultType]::ParameterName, 'restrict by vote count')
            [CompletionResult]::new('--changed', '--changed', [CompletionResultType]::ParameterName, 'fields changed within time interval')
            [CompletionResult]::new('--changed-by', '--changed-by', [CompletionResultType]::ParameterName, 'fields changed by users')
            [CompletionResult]::new('--changed-from', '--changed-from', [CompletionResultType]::ParameterName, 'fields changed from value')
            [CompletionResult]::new('--changed-to', '--changed-to', [CompletionResultType]::ParameterName, 'fields changed to value')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'restrict by creation time')
            [CompletionResult]::new('--created', '--created', [CompletionResultType]::ParameterName, 'restrict by creation time')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'restrict by update time')
            [CompletionResult]::new('--updated', '--updated', [CompletionResultType]::ParameterName, 'restrict by update time')
            [CompletionResult]::new('--closed', '--closed', [CompletionResultType]::ParameterName, 'restrict by closed time')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'user is assignee')
            [CompletionResult]::new('--assignee', '--assignee', [CompletionResultType]::ParameterName, 'user is assignee')
            [CompletionResult]::new('--attacher', '--attacher', [CompletionResultType]::ParameterName, 'user created attachment')
            [CompletionResult]::new('--cc', '--cc', [CompletionResultType]::ParameterName, 'user in CC list')
            [CompletionResult]::new('--commenter', '--commenter', [CompletionResultType]::ParameterName, 'user who commented')
            [CompletionResult]::new('--flagger', '--flagger', [CompletionResultType]::ParameterName, 'user who set flag')
            [CompletionResult]::new('--qa', '--qa', [CompletionResultType]::ParameterName, 'user is QA contact')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'user who reported')
            [CompletionResult]::new('--reporter', '--reporter', [CompletionResultType]::ParameterName, 'user who reported')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'restrict by comment content')
            [CompletionResult]::new('--comment-is-private', '--comment-is-private', [CompletionResultType]::ParameterName, 'restrict by private status')
            [CompletionResult]::new('--comment-tag', '--comment-tag', [CompletionResultType]::ParameterName, 'restrict by tag')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--json', '--json', [CompletionResultType]::ParameterName, 'output in JSON format')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--dry-run', '--dry-run', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--paged', '--paged', [CompletionResultType]::ParameterName, 'enable paging support')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;update' {
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'reply to specific comments')
            [CompletionResult]::new('--reply', '--reply', [CompletionResultType]::ParameterName, 'reply to specific comments')
            [CompletionResult]::new('--from', '--from', [CompletionResultType]::ParameterName, 'read attributes from templates')
            [CompletionResult]::new('--to', '--to', [CompletionResultType]::ParameterName, 'write attributes to template')
            [CompletionResult]::new('-A', '-A ', [CompletionResultType]::ParameterName, 'add/remove/set aliases')
            [CompletionResult]::new('--alias', '--alias', [CompletionResultType]::ParameterName, 'add/remove/set aliases')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'update assignee')
            [CompletionResult]::new('--assignee', '--assignee', [CompletionResultType]::ParameterName, 'update assignee')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'add/remove/set blockers')
            [CompletionResult]::new('--blocks', '--blocks', [CompletionResultType]::ParameterName, 'add/remove/set blockers')
            [CompletionResult]::new('--cc', '--cc', [CompletionResultType]::ParameterName, 'add/remove CC users')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'add comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'add comment')
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'add comment from file')
            [CompletionResult]::new('--comment-from', '--comment-from', [CompletionResultType]::ParameterName, 'add comment from file')
            [CompletionResult]::new('--comment-privacy', '--comment-privacy', [CompletionResultType]::ParameterName, 'update comment privacy')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'update component')
            [CompletionResult]::new('--component', '--component', [CompletionResultType]::ParameterName, 'update component')
            [CompletionResult]::new('--cf', '--cf', [CompletionResultType]::ParameterName, 'update custom field')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'add/remove/set dependencies')
            [CompletionResult]::new('--depends', '--depends', [CompletionResultType]::ParameterName, 'add/remove/set dependencies')
            [CompletionResult]::new('-D', '-D ', [CompletionResultType]::ParameterName, 'mark bug as duplicate')
            [CompletionResult]::new('--duplicate-of', '--duplicate-of', [CompletionResultType]::ParameterName, 'mark bug as duplicate')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'add/remove flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'add/remove flags')
            [CompletionResult]::new('-g', '-g', [CompletionResultType]::ParameterName, 'add/remove groups')
            [CompletionResult]::new('--groups', '--groups', [CompletionResultType]::ParameterName, 'add/remove groups')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'add/remove/set keywords')
            [CompletionResult]::new('--keywords', '--keywords', [CompletionResultType]::ParameterName, 'add/remove/set keywords')
            [CompletionResult]::new('--os', '--os', [CompletionResultType]::ParameterName, 'update operating system')
            [CompletionResult]::new('--platform', '--platform', [CompletionResultType]::ParameterName, 'update platform')
            [CompletionResult]::new('--priority', '--priority', [CompletionResultType]::ParameterName, 'update priority')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'update product')
            [CompletionResult]::new('--product', '--product', [CompletionResultType]::ParameterName, 'update product')
            [CompletionResult]::new('--qa', '--qa', [CompletionResultType]::ParameterName, 'update QA contact')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'update resolution')
            [CompletionResult]::new('--resolution', '--resolution', [CompletionResultType]::ParameterName, 'update resolution')
            [CompletionResult]::new('-U', '-U ', [CompletionResultType]::ParameterName, 'add/remove bug URLs')
            [CompletionResult]::new('--see-also', '--see-also', [CompletionResultType]::ParameterName, 'add/remove bug URLs')
            [CompletionResult]::new('--severity', '--severity', [CompletionResultType]::ParameterName, 'update severity')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'update status')
            [CompletionResult]::new('--status', '--status', [CompletionResultType]::ParameterName, 'update status')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'update summary')
            [CompletionResult]::new('--summary', '--summary', [CompletionResultType]::ParameterName, 'update summary')
            [CompletionResult]::new('-T', '-T ', [CompletionResultType]::ParameterName, 'update target milestone')
            [CompletionResult]::new('--target', '--target', [CompletionResultType]::ParameterName, 'update target milestone')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'update URL')
            [CompletionResult]::new('--url', '--url', [CompletionResultType]::ParameterName, 'update URL')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'update version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'update version')
            [CompletionResult]::new('-w', '-w', [CompletionResultType]::ParameterName, 'update whiteboard')
            [CompletionResult]::new('--whiteboard', '--whiteboard', [CompletionResultType]::ParameterName, 'update whiteboard')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--dry-run', '--dry-run', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'enable comment privacy')
            [CompletionResult]::new('--comment-is-private', '--comment-is-private', [CompletionResultType]::ParameterName, 'enable comment privacy')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;u' {
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'reply to specific comments')
            [CompletionResult]::new('--reply', '--reply', [CompletionResultType]::ParameterName, 'reply to specific comments')
            [CompletionResult]::new('--from', '--from', [CompletionResultType]::ParameterName, 'read attributes from templates')
            [CompletionResult]::new('--to', '--to', [CompletionResultType]::ParameterName, 'write attributes to template')
            [CompletionResult]::new('-A', '-A ', [CompletionResultType]::ParameterName, 'add/remove/set aliases')
            [CompletionResult]::new('--alias', '--alias', [CompletionResultType]::ParameterName, 'add/remove/set aliases')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'update assignee')
            [CompletionResult]::new('--assignee', '--assignee', [CompletionResultType]::ParameterName, 'update assignee')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'add/remove/set blockers')
            [CompletionResult]::new('--blocks', '--blocks', [CompletionResultType]::ParameterName, 'add/remove/set blockers')
            [CompletionResult]::new('--cc', '--cc', [CompletionResultType]::ParameterName, 'add/remove CC users')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'add comment')
            [CompletionResult]::new('--comment', '--comment', [CompletionResultType]::ParameterName, 'add comment')
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'add comment from file')
            [CompletionResult]::new('--comment-from', '--comment-from', [CompletionResultType]::ParameterName, 'add comment from file')
            [CompletionResult]::new('--comment-privacy', '--comment-privacy', [CompletionResultType]::ParameterName, 'update comment privacy')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'update component')
            [CompletionResult]::new('--component', '--component', [CompletionResultType]::ParameterName, 'update component')
            [CompletionResult]::new('--cf', '--cf', [CompletionResultType]::ParameterName, 'update custom field')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'add/remove/set dependencies')
            [CompletionResult]::new('--depends', '--depends', [CompletionResultType]::ParameterName, 'add/remove/set dependencies')
            [CompletionResult]::new('-D', '-D ', [CompletionResultType]::ParameterName, 'mark bug as duplicate')
            [CompletionResult]::new('--duplicate-of', '--duplicate-of', [CompletionResultType]::ParameterName, 'mark bug as duplicate')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'add/remove flags')
            [CompletionResult]::new('--flags', '--flags', [CompletionResultType]::ParameterName, 'add/remove flags')
            [CompletionResult]::new('-g', '-g', [CompletionResultType]::ParameterName, 'add/remove groups')
            [CompletionResult]::new('--groups', '--groups', [CompletionResultType]::ParameterName, 'add/remove groups')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'add/remove/set keywords')
            [CompletionResult]::new('--keywords', '--keywords', [CompletionResultType]::ParameterName, 'add/remove/set keywords')
            [CompletionResult]::new('--os', '--os', [CompletionResultType]::ParameterName, 'update operating system')
            [CompletionResult]::new('--platform', '--platform', [CompletionResultType]::ParameterName, 'update platform')
            [CompletionResult]::new('--priority', '--priority', [CompletionResultType]::ParameterName, 'update priority')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'update product')
            [CompletionResult]::new('--product', '--product', [CompletionResultType]::ParameterName, 'update product')
            [CompletionResult]::new('--qa', '--qa', [CompletionResultType]::ParameterName, 'update QA contact')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'update resolution')
            [CompletionResult]::new('--resolution', '--resolution', [CompletionResultType]::ParameterName, 'update resolution')
            [CompletionResult]::new('-U', '-U ', [CompletionResultType]::ParameterName, 'add/remove bug URLs')
            [CompletionResult]::new('--see-also', '--see-also', [CompletionResultType]::ParameterName, 'add/remove bug URLs')
            [CompletionResult]::new('--severity', '--severity', [CompletionResultType]::ParameterName, 'update severity')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'update status')
            [CompletionResult]::new('--status', '--status', [CompletionResultType]::ParameterName, 'update status')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'update summary')
            [CompletionResult]::new('--summary', '--summary', [CompletionResultType]::ParameterName, 'update summary')
            [CompletionResult]::new('-T', '-T ', [CompletionResultType]::ParameterName, 'update target milestone')
            [CompletionResult]::new('--target', '--target', [CompletionResultType]::ParameterName, 'update target milestone')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'update URL')
            [CompletionResult]::new('--url', '--url', [CompletionResultType]::ParameterName, 'update URL')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'update version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'update version')
            [CompletionResult]::new('-w', '-w', [CompletionResultType]::ParameterName, 'update whiteboard')
            [CompletionResult]::new('--whiteboard', '--whiteboard', [CompletionResultType]::ParameterName, 'update whiteboard')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--dry-run', '--dry-run', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('-P', '-P ', [CompletionResultType]::ParameterName, 'enable comment privacy')
            [CompletionResult]::new('--comment-is-private', '--comment-is-private', [CompletionResultType]::ParameterName, 'enable comment privacy')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;bugzilla;version' {
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;github' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'service connection')
            [CompletionResult]::new('--connection', '--connection', [CompletionResultType]::ParameterName, 'service connection')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'concurrent requests limit')
            [CompletionResult]::new('--concurrent', '--concurrent', [CompletionResultType]::ParameterName, 'concurrent requests limit')
            [CompletionResult]::new('--certificate', '--certificate', [CompletionResultType]::ParameterName, 'custom root certificate')
            [CompletionResult]::new('--proxy', '--proxy', [CompletionResultType]::ParameterName, 'custom proxy')
            [CompletionResult]::new('-t', '-t', [CompletionResultType]::ParameterName, 'request timeout in seconds')
            [CompletionResult]::new('--timeout', '--timeout', [CompletionResultType]::ParameterName, 'request timeout in seconds')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'GitHub personal access token')
            [CompletionResult]::new('--key', '--key', [CompletionResultType]::ParameterName, 'GitHub personal access token')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'username')
            [CompletionResult]::new('--user', '--user', [CompletionResultType]::ParameterName, 'username')
            [CompletionResult]::new('--insecure', '--insecure', [CompletionResultType]::ParameterName, 'ignore invalid service certificates')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('get', 'get', [CompletionResultType]::ParameterValue, 'Get issues')
            [CompletionResult]::new('g', 'g', [CompletionResultType]::ParameterValue, 'Get issues')
            [CompletionResult]::new('search', 'search', [CompletionResultType]::ParameterValue, 'Search issues')
            [CompletionResult]::new('s', 's', [CompletionResultType]::ParameterValue, 'Search issues')
            break
        }
        'bite;github;get' {
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;github;g' {
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;github;search' {
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('--fields', '--fields', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'sorting order for search query')
            [CompletionResult]::new('--order', '--order', [CompletionResultType]::ParameterName, 'sorting order for search query')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;github;s' {
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('--fields', '--fields', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('-S', '-S ', [CompletionResultType]::ParameterName, 'sorting order for search query')
            [CompletionResult]::new('--order', '--order', [CompletionResultType]::ParameterName, 'sorting order for search query')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;redmine' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'service connection')
            [CompletionResult]::new('--connection', '--connection', [CompletionResultType]::ParameterName, 'service connection')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'concurrent requests limit')
            [CompletionResult]::new('--concurrent', '--concurrent', [CompletionResultType]::ParameterName, 'concurrent requests limit')
            [CompletionResult]::new('--certificate', '--certificate', [CompletionResultType]::ParameterName, 'custom root certificate')
            [CompletionResult]::new('--proxy', '--proxy', [CompletionResultType]::ParameterName, 'custom proxy')
            [CompletionResult]::new('-t', '-t', [CompletionResultType]::ParameterName, 'request timeout in seconds')
            [CompletionResult]::new('--timeout', '--timeout', [CompletionResultType]::ParameterName, 'request timeout in seconds')
            [CompletionResult]::new('-k', '-k', [CompletionResultType]::ParameterName, 'API key')
            [CompletionResult]::new('--key', '--key', [CompletionResultType]::ParameterName, 'API key')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'username')
            [CompletionResult]::new('--user', '--user', [CompletionResultType]::ParameterName, 'username')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'password')
            [CompletionResult]::new('--password', '--password', [CompletionResultType]::ParameterName, 'password')
            [CompletionResult]::new('--insecure', '--insecure', [CompletionResultType]::ParameterName, 'ignore invalid service certificates')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('get', 'get', [CompletionResultType]::ParameterValue, 'Get issues')
            [CompletionResult]::new('g', 'g', [CompletionResultType]::ParameterValue, 'Get issues')
            [CompletionResult]::new('search', 'search', [CompletionResultType]::ParameterValue, 'Search issues')
            [CompletionResult]::new('s', 's', [CompletionResultType]::ParameterValue, 'Search issues')
            break
        }
        'bite;redmine;get' {
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'disable comments')
            [CompletionResult]::new('--no-comments', '--no-comments', [CompletionResultType]::ParameterName, 'disable comments')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;redmine;g' {
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'disable comments')
            [CompletionResult]::new('--no-comments', '--no-comments', [CompletionResultType]::ParameterName, 'disable comments')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;redmine;search' {
            [CompletionResult]::new('--from', '--from', [CompletionResultType]::ParameterName, 'read attributes from templates')
            [CompletionResult]::new('--to', '--to', [CompletionResultType]::ParameterName, 'write attributes to template')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('--fields', '--fields', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'limit result count')
            [CompletionResult]::new('--limit', '--limit', [CompletionResultType]::ParameterName, 'limit result count')
            [CompletionResult]::new('-O', '-O ', [CompletionResultType]::ParameterName, 'result starting position')
            [CompletionResult]::new('--offset', '--offset', [CompletionResultType]::ParameterName, 'result starting position')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'order query results')
            [CompletionResult]::new('--order', '--order', [CompletionResultType]::ParameterName, 'order query results')
            [CompletionResult]::new('--paged', '--paged', [CompletionResultType]::ParameterName, 'enable paging support')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'restrict by assignee status')
            [CompletionResult]::new('--assignee', '--assignee', [CompletionResultType]::ParameterName, 'restrict by assignee status')
            [CompletionResult]::new('-@', '-@', [CompletionResultType]::ParameterName, 'restrict by attachments')
            [CompletionResult]::new('--attachments', '--attachments', [CompletionResultType]::ParameterName, 'restrict by attachments')
            [CompletionResult]::new('-B', '-B ', [CompletionResultType]::ParameterName, 'restrict by blockers')
            [CompletionResult]::new('--blocks', '--blocks', [CompletionResultType]::ParameterName, 'restrict by blockers')
            [CompletionResult]::new('-D', '-D ', [CompletionResultType]::ParameterName, 'restrict by dependencies')
            [CompletionResult]::new('--blocked', '--blocked', [CompletionResultType]::ParameterName, 'restrict by dependencies')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'restrict by relations')
            [CompletionResult]::new('--relates', '--relates', [CompletionResultType]::ParameterName, 'restrict by relations')
            [CompletionResult]::new('--id', '--id', [CompletionResultType]::ParameterName, 'restrict by ID')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'restrict by status')
            [CompletionResult]::new('--status', '--status', [CompletionResultType]::ParameterName, 'restrict by status')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'restrict by creation time')
            [CompletionResult]::new('--created', '--created', [CompletionResultType]::ParameterName, 'restrict by creation time')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'restrict by update time')
            [CompletionResult]::new('--updated', '--updated', [CompletionResultType]::ParameterName, 'restrict by update time')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'restrict by closed time')
            [CompletionResult]::new('--closed', '--closed', [CompletionResultType]::ParameterName, 'restrict by closed time')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--json', '--json', [CompletionResultType]::ParameterName, 'output in JSON format')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--dry-run', '--dry-run', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;redmine;s' {
            [CompletionResult]::new('--from', '--from', [CompletionResultType]::ParameterName, 'read attributes from templates')
            [CompletionResult]::new('--to', '--to', [CompletionResultType]::ParameterName, 'write attributes to template')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('--fields', '--fields', [CompletionResultType]::ParameterName, 'fields to output')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'limit result count')
            [CompletionResult]::new('--limit', '--limit', [CompletionResultType]::ParameterName, 'limit result count')
            [CompletionResult]::new('-O', '-O ', [CompletionResultType]::ParameterName, 'result starting position')
            [CompletionResult]::new('--offset', '--offset', [CompletionResultType]::ParameterName, 'result starting position')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'order query results')
            [CompletionResult]::new('--order', '--order', [CompletionResultType]::ParameterName, 'order query results')
            [CompletionResult]::new('--paged', '--paged', [CompletionResultType]::ParameterName, 'enable paging support')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'restrict by assignee status')
            [CompletionResult]::new('--assignee', '--assignee', [CompletionResultType]::ParameterName, 'restrict by assignee status')
            [CompletionResult]::new('-@', '-@', [CompletionResultType]::ParameterName, 'restrict by attachments')
            [CompletionResult]::new('--attachments', '--attachments', [CompletionResultType]::ParameterName, 'restrict by attachments')
            [CompletionResult]::new('-B', '-B ', [CompletionResultType]::ParameterName, 'restrict by blockers')
            [CompletionResult]::new('--blocks', '--blocks', [CompletionResultType]::ParameterName, 'restrict by blockers')
            [CompletionResult]::new('-D', '-D ', [CompletionResultType]::ParameterName, 'restrict by dependencies')
            [CompletionResult]::new('--blocked', '--blocked', [CompletionResultType]::ParameterName, 'restrict by dependencies')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'restrict by relations')
            [CompletionResult]::new('--relates', '--relates', [CompletionResultType]::ParameterName, 'restrict by relations')
            [CompletionResult]::new('--id', '--id', [CompletionResultType]::ParameterName, 'restrict by ID')
            [CompletionResult]::new('-s', '-s', [CompletionResultType]::ParameterName, 'restrict by status')
            [CompletionResult]::new('--status', '--status', [CompletionResultType]::ParameterName, 'restrict by status')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'restrict by creation time')
            [CompletionResult]::new('--created', '--created', [CompletionResultType]::ParameterName, 'restrict by creation time')
            [CompletionResult]::new('-u', '-u', [CompletionResultType]::ParameterName, 'restrict by update time')
            [CompletionResult]::new('--updated', '--updated', [CompletionResultType]::ParameterName, 'restrict by update time')
            [CompletionResult]::new('-C', '-C ', [CompletionResultType]::ParameterName, 'restrict by closed time')
            [CompletionResult]::new('--closed', '--closed', [CompletionResultType]::ParameterName, 'restrict by closed time')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--browser', '--browser', [CompletionResultType]::ParameterName, 'open in browser')
            [CompletionResult]::new('--json', '--json', [CompletionResultType]::ParameterName, 'output in JSON format')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('--dry-run', '--dry-run', [CompletionResultType]::ParameterName, 'skip service interaction')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;completion' {
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'Target directory for completion files')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'Target directory for completion files')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;show' {
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('connections', 'connections', [CompletionResultType]::ParameterValue, 'Show available connections')
            [CompletionResult]::new('services', 'services', [CompletionResultType]::ParameterValue, 'Show available services')
            break
        }
        'bite;show;connections' {
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'bite;show;services' {
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
    })

    $completions.Where{ $_.CompletionText -like "$wordToComplete*" } |
        Sort-Object -Property ListItemText
}
