package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDeletedInstances invokes the hbase.DescribeDeletedInstances API synchronously
func (client *Client) DescribeDeletedInstances(request *DescribeDeletedInstancesRequest) (response *DescribeDeletedInstancesResponse, err error) {
	response = CreateDescribeDeletedInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDeletedInstancesWithChan invokes the hbase.DescribeDeletedInstances API asynchronously
func (client *Client) DescribeDeletedInstancesWithChan(request *DescribeDeletedInstancesRequest) (<-chan *DescribeDeletedInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeDeletedInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDeletedInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDeletedInstancesWithCallback invokes the hbase.DescribeDeletedInstances API asynchronously
func (client *Client) DescribeDeletedInstancesWithCallback(request *DescribeDeletedInstancesRequest, callback func(response *DescribeDeletedInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDeletedInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDeletedInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDeletedInstancesRequest is the request struct for api DescribeDeletedInstances
type DescribeDeletedInstancesRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeDeletedInstancesResponse is the response struct for api DescribeDeletedInstances
type DescribeDeletedInstancesResponse struct {
	*responses.BaseResponse
	RequestId  string                              `json:"RequestId" xml:"RequestId"`
	TotalCount int64                               `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                                 `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                                 `json:"PageSize" xml:"PageSize"`
	Instances  InstancesInDescribeDeletedInstances `json:"Instances" xml:"Instances"`
}

// CreateDescribeDeletedInstancesRequest creates a request to invoke DescribeDeletedInstances API
func CreateDescribeDeletedInstancesRequest() (request *DescribeDeletedInstancesRequest) {
	request = &DescribeDeletedInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeDeletedInstances", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDeletedInstancesResponse creates a response to parse from DescribeDeletedInstances response
func CreateDescribeDeletedInstancesResponse() (response *DescribeDeletedInstancesResponse) {
	response = &DescribeDeletedInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
