package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushApplicationData invokes the ens.PushApplicationData API synchronously
func (client *Client) PushApplicationData(request *PushApplicationDataRequest) (response *PushApplicationDataResponse, err error) {
	response = CreatePushApplicationDataResponse()
	err = client.DoAction(request, response)
	return
}

// PushApplicationDataWithChan invokes the ens.PushApplicationData API asynchronously
func (client *Client) PushApplicationDataWithChan(request *PushApplicationDataRequest) (<-chan *PushApplicationDataResponse, <-chan error) {
	responseChan := make(chan *PushApplicationDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushApplicationData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushApplicationDataWithCallback invokes the ens.PushApplicationData API asynchronously
func (client *Client) PushApplicationDataWithCallback(request *PushApplicationDataRequest, callback func(response *PushApplicationDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushApplicationDataResponse
		var err error
		defer close(result)
		response, err = client.PushApplicationData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushApplicationDataRequest is the request struct for api PushApplicationData
type PushApplicationDataRequest struct {
	*requests.RpcRequest
	Data         string           `position:"Query" name:"Data"`
	Timeout      requests.Integer `position:"Query" name:"Timeout"`
	PushStrategy string           `position:"Query" name:"PushStrategy"`
	AppId        string           `position:"Query" name:"AppId"`
}

// PushApplicationDataResponse is the response struct for api PushApplicationData
type PushApplicationDataResponse struct {
	*responses.BaseResponse
	RequestId   string                           `json:"RequestId" xml:"RequestId"`
	PushResults PushResultsInPushApplicationData `json:"PushResults" xml:"PushResults"`
}

// CreatePushApplicationDataRequest creates a request to invoke PushApplicationData API
func CreatePushApplicationDataRequest() (request *PushApplicationDataRequest) {
	request = &PushApplicationDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "PushApplicationData", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePushApplicationDataResponse creates a response to parse from PushApplicationData response
func CreatePushApplicationDataResponse() (response *PushApplicationDataResponse) {
	response = &PushApplicationDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
