package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRoutineUserInfo invokes the dcdn.DescribeRoutineUserInfo API synchronously
func (client *Client) DescribeRoutineUserInfo(request *DescribeRoutineUserInfoRequest) (response *DescribeRoutineUserInfoResponse, err error) {
	response = CreateDescribeRoutineUserInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRoutineUserInfoWithChan invokes the dcdn.DescribeRoutineUserInfo API asynchronously
func (client *Client) DescribeRoutineUserInfoWithChan(request *DescribeRoutineUserInfoRequest) (<-chan *DescribeRoutineUserInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeRoutineUserInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRoutineUserInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRoutineUserInfoWithCallback invokes the dcdn.DescribeRoutineUserInfo API asynchronously
func (client *Client) DescribeRoutineUserInfoWithCallback(request *DescribeRoutineUserInfoRequest, callback func(response *DescribeRoutineUserInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRoutineUserInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeRoutineUserInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRoutineUserInfoRequest is the request struct for api DescribeRoutineUserInfo
type DescribeRoutineUserInfoRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeRoutineUserInfoResponse is the response struct for api DescribeRoutineUserInfo
type DescribeRoutineUserInfoResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Content   map[string]interface{} `json:"Content" xml:"Content"`
}

// CreateDescribeRoutineUserInfoRequest creates a request to invoke DescribeRoutineUserInfo API
func CreateDescribeRoutineUserInfoRequest() (request *DescribeRoutineUserInfoRequest) {
	request = &DescribeRoutineUserInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeRoutineUserInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRoutineUserInfoResponse creates a response to parse from DescribeRoutineUserInfo response
func CreateDescribeRoutineUserInfoResponse() (response *DescribeRoutineUserInfoResponse) {
	response = &DescribeRoutineUserInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
