package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDbfs invokes the dbfs.GetDbfs API synchronously
func (client *Client) GetDbfs(request *GetDbfsRequest) (response *GetDbfsResponse, err error) {
	response = CreateGetDbfsResponse()
	err = client.DoAction(request, response)
	return
}

// GetDbfsWithChan invokes the dbfs.GetDbfs API asynchronously
func (client *Client) GetDbfsWithChan(request *GetDbfsRequest) (<-chan *GetDbfsResponse, <-chan error) {
	responseChan := make(chan *GetDbfsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDbfs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDbfsWithCallback invokes the dbfs.GetDbfs API asynchronously
func (client *Client) GetDbfsWithCallback(request *GetDbfsRequest, callback func(response *GetDbfsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDbfsResponse
		var err error
		defer close(result)
		response, err = client.GetDbfs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDbfsRequest is the request struct for api GetDbfs
type GetDbfsRequest struct {
	*requests.RpcRequest
	FsId string `position:"Query" name:"FsId"`
}

// GetDbfsResponse is the response struct for api GetDbfs
type GetDbfsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	DBFSInfo  DBFSInfo `json:"DBFSInfo" xml:"DBFSInfo"`
}

// CreateGetDbfsRequest creates a request to invoke GetDbfs API
func CreateGetDbfsRequest() (request *GetDbfsRequest) {
	request = &GetDbfsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "GetDbfs", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDbfsResponse creates a response to parse from GetDbfs response
func CreateGetDbfsResponse() (response *GetDbfsResponse) {
	response = &GetDbfsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
