package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProgramTypeCount invokes the dataworks_public.ListProgramTypeCount API synchronously
func (client *Client) ListProgramTypeCount(request *ListProgramTypeCountRequest) (response *ListProgramTypeCountResponse, err error) {
	response = CreateListProgramTypeCountResponse()
	err = client.DoAction(request, response)
	return
}

// ListProgramTypeCountWithChan invokes the dataworks_public.ListProgramTypeCount API asynchronously
func (client *Client) ListProgramTypeCountWithChan(request *ListProgramTypeCountRequest) (<-chan *ListProgramTypeCountResponse, <-chan error) {
	responseChan := make(chan *ListProgramTypeCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProgramTypeCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProgramTypeCountWithCallback invokes the dataworks_public.ListProgramTypeCount API asynchronously
func (client *Client) ListProgramTypeCountWithCallback(request *ListProgramTypeCountRequest, callback func(response *ListProgramTypeCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProgramTypeCountResponse
		var err error
		defer close(result)
		response, err = client.ListProgramTypeCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProgramTypeCountRequest is the request struct for api ListProgramTypeCount
type ListProgramTypeCountRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	ProjectId  requests.Integer `position:"Body" name:"ProjectId"`
}

// ListProgramTypeCountResponse is the response struct for api ListProgramTypeCount
type ListProgramTypeCountResponse struct {
	*responses.BaseResponse
	RequestId            string                `json:"RequestId" xml:"RequestId"`
	ProgramTypeAndCounts []ProgramTypeAndCount `json:"ProgramTypeAndCounts" xml:"ProgramTypeAndCounts"`
}

// CreateListProgramTypeCountRequest creates a request to invoke ListProgramTypeCount API
func CreateListProgramTypeCountRequest() (request *ListProgramTypeCountRequest) {
	request = &ListProgramTypeCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListProgramTypeCount", "", "")
	request.Method = requests.POST
	return
}

// CreateListProgramTypeCountResponse creates a response to parse from ListProgramTypeCount response
func CreateListProgramTypeCountResponse() (response *ListProgramTypeCountResponse) {
	response = &ListProgramTypeCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
