package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetaCategory invokes the dataworks_public.GetMetaCategory API synchronously
func (client *Client) GetMetaCategory(request *GetMetaCategoryRequest) (response *GetMetaCategoryResponse, err error) {
	response = CreateGetMetaCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetaCategoryWithChan invokes the dataworks_public.GetMetaCategory API asynchronously
func (client *Client) GetMetaCategoryWithChan(request *GetMetaCategoryRequest) (<-chan *GetMetaCategoryResponse, <-chan error) {
	responseChan := make(chan *GetMetaCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetaCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetaCategoryWithCallback invokes the dataworks_public.GetMetaCategory API asynchronously
func (client *Client) GetMetaCategoryWithCallback(request *GetMetaCategoryRequest, callback func(response *GetMetaCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetaCategoryResponse
		var err error
		defer close(result)
		response, err = client.GetMetaCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetaCategoryRequest is the request struct for api GetMetaCategory
type GetMetaCategoryRequest struct {
	*requests.RpcRequest
	ParentCategoryId requests.Integer `position:"Query" name:"ParentCategoryId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	PageNum          requests.Integer `position:"Query" name:"PageNum"`
}

// GetMetaCategoryResponse is the response struct for api GetMetaCategory
type GetMetaCategoryResponse struct {
	*responses.BaseResponse
	RequestId      string                `json:"RequestId" xml:"RequestId"`
	ErrorCode      string                `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string                `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int                   `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool                  `json:"Success" xml:"Success"`
	Data           DataInGetMetaCategory `json:"Data" xml:"Data"`
}

// CreateGetMetaCategoryRequest creates a request to invoke GetMetaCategory API
func CreateGetMetaCategoryRequest() (request *GetMetaCategoryRequest) {
	request = &GetMetaCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetMetaCategory", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMetaCategoryResponse creates a response to parse from GetMetaCategory response
func CreateGetMetaCategoryResponse() (response *GetMetaCategoryResponse) {
	response = &GetMetaCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
