package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateQualityEntity invokes the dataworks_public.CreateQualityEntity API synchronously
func (client *Client) CreateQualityEntity(request *CreateQualityEntityRequest) (response *CreateQualityEntityResponse, err error) {
	response = CreateCreateQualityEntityResponse()
	err = client.DoAction(request, response)
	return
}

// CreateQualityEntityWithChan invokes the dataworks_public.CreateQualityEntity API asynchronously
func (client *Client) CreateQualityEntityWithChan(request *CreateQualityEntityRequest) (<-chan *CreateQualityEntityResponse, <-chan error) {
	responseChan := make(chan *CreateQualityEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateQualityEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateQualityEntityWithCallback invokes the dataworks_public.CreateQualityEntity API asynchronously
func (client *Client) CreateQualityEntityWithCallback(request *CreateQualityEntityRequest, callback func(response *CreateQualityEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateQualityEntityResponse
		var err error
		defer close(result)
		response, err = client.CreateQualityEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateQualityEntityRequest is the request struct for api CreateQualityEntity
type CreateQualityEntityRequest struct {
	*requests.RpcRequest
	ProjectName     string           `position:"Body" name:"ProjectName"`
	EntityLevel     requests.Integer `position:"Body" name:"EntityLevel"`
	MatchExpression string           `position:"Body" name:"MatchExpression"`
	EnvType         string           `position:"Body" name:"EnvType"`
	TableName       string           `position:"Body" name:"TableName"`
}

// CreateQualityEntityResponse is the response struct for api CreateQualityEntity
type CreateQualityEntityResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           int    `json:"Data" xml:"Data"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateCreateQualityEntityRequest creates a request to invoke CreateQualityEntity API
func CreateCreateQualityEntityRequest() (request *CreateQualityEntityRequest) {
	request = &CreateQualityEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateQualityEntity", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateQualityEntityResponse creates a response to parse from CreateQualityEntity response
func CreateCreateQualityEntityResponse() (response *CreateQualityEntityResponse) {
	response = &CreateQualityEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
