package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTraceApp invokes the arms.GetTraceApp API synchronously
func (client *Client) GetTraceApp(request *GetTraceAppRequest) (response *GetTraceAppResponse, err error) {
	response = CreateGetTraceAppResponse()
	err = client.DoAction(request, response)
	return
}

// GetTraceAppWithChan invokes the arms.GetTraceApp API asynchronously
func (client *Client) GetTraceAppWithChan(request *GetTraceAppRequest) (<-chan *GetTraceAppResponse, <-chan error) {
	responseChan := make(chan *GetTraceAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTraceApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTraceAppWithCallback invokes the arms.GetTraceApp API asynchronously
func (client *Client) GetTraceAppWithCallback(request *GetTraceAppRequest, callback func(response *GetTraceAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTraceAppResponse
		var err error
		defer close(result)
		response, err = client.GetTraceApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTraceAppRequest is the request struct for api GetTraceApp
type GetTraceAppRequest struct {
	*requests.RpcRequest
	Pid string `position:"Query" name:"Pid"`
}

// GetTraceAppResponse is the response struct for api GetTraceApp
type GetTraceAppResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	TraceApp  TraceApp `json:"TraceApp" xml:"TraceApp"`
}

// CreateGetTraceAppRequest creates a request to invoke GetTraceApp API
func CreateGetTraceAppRequest() (request *GetTraceAppRequest) {
	request = &GetTraceAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetTraceApp", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTraceAppResponse creates a response to parse from GetTraceApp response
func CreateGetTraceAppResponse() (response *GetTraceAppResponse) {
	response = &GetTraceAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
