package videoanalyzer

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessPolicyEccAlgo enumerates the values for access policy ecc algo.
type AccessPolicyEccAlgo string

const (
	// AccessPolicyEccAlgoES256 ES265
	AccessPolicyEccAlgoES256 AccessPolicyEccAlgo = "ES256"
	// AccessPolicyEccAlgoES384 ES384
	AccessPolicyEccAlgoES384 AccessPolicyEccAlgo = "ES384"
	// AccessPolicyEccAlgoES512 ES512
	AccessPolicyEccAlgoES512 AccessPolicyEccAlgo = "ES512"
)

// PossibleAccessPolicyEccAlgoValues returns an array of possible values for the AccessPolicyEccAlgo const type.
func PossibleAccessPolicyEccAlgoValues() []AccessPolicyEccAlgo {
	return []AccessPolicyEccAlgo{AccessPolicyEccAlgoES256, AccessPolicyEccAlgoES384, AccessPolicyEccAlgoES512}
}

// AccessPolicyRole enumerates the values for access policy role.
type AccessPolicyRole string

const (
	// AccessPolicyRoleReader Reader role allows for read-only operations to be performed through the client
	// APIs.
	AccessPolicyRoleReader AccessPolicyRole = "Reader"
)

// PossibleAccessPolicyRoleValues returns an array of possible values for the AccessPolicyRole const type.
func PossibleAccessPolicyRoleValues() []AccessPolicyRole {
	return []AccessPolicyRole{AccessPolicyRoleReader}
}

// AccessPolicyRsaAlgo enumerates the values for access policy rsa algo.
type AccessPolicyRsaAlgo string

const (
	// AccessPolicyRsaAlgoRS256 RS256
	AccessPolicyRsaAlgoRS256 AccessPolicyRsaAlgo = "RS256"
	// AccessPolicyRsaAlgoRS384 RS384
	AccessPolicyRsaAlgoRS384 AccessPolicyRsaAlgo = "RS384"
	// AccessPolicyRsaAlgoRS512 RS512
	AccessPolicyRsaAlgoRS512 AccessPolicyRsaAlgo = "RS512"
)

// PossibleAccessPolicyRsaAlgoValues returns an array of possible values for the AccessPolicyRsaAlgo const type.
func PossibleAccessPolicyRsaAlgoValues() []AccessPolicyRsaAlgo {
	return []AccessPolicyRsaAlgo{AccessPolicyRsaAlgoRS256, AccessPolicyRsaAlgoRS384, AccessPolicyRsaAlgoRS512}
}

// AccountEncryptionKeyType enumerates the values for account encryption key type.
type AccountEncryptionKeyType string

const (
	// AccountEncryptionKeyTypeCustomerKey The Account Key is encrypted with a Customer Key.
	AccountEncryptionKeyTypeCustomerKey AccountEncryptionKeyType = "CustomerKey"
	// AccountEncryptionKeyTypeSystemKey The Account Key is encrypted with a System Key.
	AccountEncryptionKeyTypeSystemKey AccountEncryptionKeyType = "SystemKey"
)

// PossibleAccountEncryptionKeyTypeValues returns an array of possible values for the AccountEncryptionKeyType const type.
func PossibleAccountEncryptionKeyTypeValues() []AccountEncryptionKeyType {
	return []AccountEncryptionKeyType{AccountEncryptionKeyTypeCustomerKey, AccountEncryptionKeyTypeSystemKey}
}

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeInternal An internal action.
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeInternal}
}

// CheckNameAvailabilityReason enumerates the values for check name availability reason.
type CheckNameAvailabilityReason string

const (
	// CheckNameAvailabilityReasonAlreadyExists ...
	CheckNameAvailabilityReasonAlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	// CheckNameAvailabilityReasonInvalid ...
	CheckNameAvailabilityReasonInvalid CheckNameAvailabilityReason = "Invalid"
)

// PossibleCheckNameAvailabilityReasonValues returns an array of possible values for the CheckNameAvailabilityReason const type.
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return []CheckNameAvailabilityReason{CheckNameAvailabilityReasonAlreadyExists, CheckNameAvailabilityReasonInvalid}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// EncoderSystemPresetType enumerates the values for encoder system preset type.
type EncoderSystemPresetType string

const (
	// EncoderSystemPresetTypeSingleLayer1080pH264AAC Produces an MP4 file where the video is encoded with
	// H.264 codec at a picture height of 1080 pixels, and at a maximum bitrate of 6000 Kbps. Encoded video has
	// the same average frame rate as the input. The aspect ratio of the input is preserved. If the input
	// content has audio, then it is encoded with AAC-LC codec at 128 Kbps
	EncoderSystemPresetTypeSingleLayer1080pH264AAC EncoderSystemPresetType = "SingleLayer_1080p_H264_AAC"
	// EncoderSystemPresetTypeSingleLayer2160pH264AAC Produces an MP4 file where the video is encoded with
	// H.264 codec at a picture height of 2160 pixels, and at a maximum bitrate of 16000 Kbps. Encoded video
	// has the same average frame rate as the input. The aspect ratio of the input is preserved. If the input
	// content has audio, then it is encoded with AAC-LC codec at 128 Kbps
	EncoderSystemPresetTypeSingleLayer2160pH264AAC EncoderSystemPresetType = "SingleLayer_2160p_H264_AAC"
	// EncoderSystemPresetTypeSingleLayer540pH264AAC Produces an MP4 file where the video is encoded with H.264
	// codec at a picture height of 540 pixels, and at a maximum bitrate of 2000 Kbps. Encoded video has the
	// same average frame rate as the input. The aspect ratio of the input is preserved. If the input content
	// has audio, then it is encoded with AAC-LC codec at 96 Kbps
	EncoderSystemPresetTypeSingleLayer540pH264AAC EncoderSystemPresetType = "SingleLayer_540p_H264_AAC"
	// EncoderSystemPresetTypeSingleLayer720pH264AAC Produces an MP4 file where the video is encoded with H.264
	// codec at a picture height of 720 pixels, and at a maximum bitrate of 3500 Kbps. Encoded video has the
	// same average frame rate as the input. The aspect ratio of the input is preserved. If the input content
	// has audio, then it is encoded with AAC-LC codec at 96 Kbps
	EncoderSystemPresetTypeSingleLayer720pH264AAC EncoderSystemPresetType = "SingleLayer_720p_H264_AAC"
)

// PossibleEncoderSystemPresetTypeValues returns an array of possible values for the EncoderSystemPresetType const type.
func PossibleEncoderSystemPresetTypeValues() []EncoderSystemPresetType {
	return []EncoderSystemPresetType{EncoderSystemPresetTypeSingleLayer1080pH264AAC, EncoderSystemPresetTypeSingleLayer2160pH264AAC, EncoderSystemPresetTypeSingleLayer540pH264AAC, EncoderSystemPresetTypeSingleLayer720pH264AAC}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindBatch Batch pipeline topology resource.
	KindBatch Kind = "Batch"
	// KindLive Live pipeline topology resource.
	KindLive Kind = "Live"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindBatch, KindLive}
}

// LivePipelineState enumerates the values for live pipeline state.
type LivePipelineState string

const (
	// LivePipelineStateActivating The live pipeline is transitioning into the active state.
	LivePipelineStateActivating LivePipelineState = "Activating"
	// LivePipelineStateActive The live pipeline is active and able to process media. If your data source is
	// not available, for instance, if your RTSP camera is powered off or unreachable, the pipeline will still
	// be active and periodically retrying the connection. Your Azure subscription will be billed for the
	// duration in which the live pipeline is in the active state.
	LivePipelineStateActive LivePipelineState = "Active"
	// LivePipelineStateDeactivating The live pipeline is transitioning into the inactive state.
	LivePipelineStateDeactivating LivePipelineState = "Deactivating"
	// LivePipelineStateInactive The live pipeline is idle and not processing media.
	LivePipelineStateInactive LivePipelineState = "Inactive"
)

// PossibleLivePipelineStateValues returns an array of possible values for the LivePipelineState const type.
func PossibleLivePipelineStateValues() []LivePipelineState {
	return []LivePipelineState{LivePipelineStateActivating, LivePipelineStateActive, LivePipelineStateDeactivating, LivePipelineStateInactive}
}

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage The average.
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeCount The count of a number of items, usually requests.
	MetricAggregationTypeCount MetricAggregationType = "Count"
	// MetricAggregationTypeTotal The sum.
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns an array of possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{MetricAggregationTypeAverage, MetricAggregationTypeCount, MetricAggregationTypeTotal}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// MetricUnitBytes The number of bytes.
	MetricUnitBytes MetricUnit = "Bytes"
	// MetricUnitCount The count.
	MetricUnitCount MetricUnit = "Count"
	// MetricUnitMilliseconds The number of milliseconds.
	MetricUnitMilliseconds MetricUnit = "Milliseconds"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{MetricUnitBytes, MetricUnitCount, MetricUnitMilliseconds}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeBool The parameter's value is a boolean value that is either true or false.
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeDouble The parameter's value is a 64-bit double-precision floating point.
	ParameterTypeDouble ParameterType = "Double"
	// ParameterTypeInt The parameter's value is a 32-bit signed integer.
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeSecretString The parameter's value is a string that holds sensitive information.
	ParameterTypeSecretString ParameterType = "SecretString"
	// ParameterTypeString The parameter's value is a string.
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeBool, ParameterTypeDouble, ParameterTypeInt, ParameterTypeSecretString, ParameterTypeString}
}

// PipelineJobState enumerates the values for pipeline job state.
type PipelineJobState string

const (
	// PipelineJobStateCanceled Pipeline job is canceled.
	PipelineJobStateCanceled PipelineJobState = "Canceled"
	// PipelineJobStateCompleted Pipeline job completed.
	PipelineJobStateCompleted PipelineJobState = "Completed"
	// PipelineJobStateFailed Pipeline job failed.
	PipelineJobStateFailed PipelineJobState = "Failed"
	// PipelineJobStateProcessing Pipeline job is processing.
	PipelineJobStateProcessing PipelineJobState = "Processing"
)

// PossiblePipelineJobStateValues returns an array of possible values for the PipelineJobState const type.
func PossiblePipelineJobStateValues() []PipelineJobState {
	return []PipelineJobState{PipelineJobStateCanceled, PipelineJobStateCompleted, PipelineJobStateFailed, PipelineJobStateProcessing}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// PrivateEndpointServiceConnectionStatusApproved ...
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	// PrivateEndpointServiceConnectionStatusPending ...
	PrivateEndpointServiceConnectionStatusPending PrivateEndpointServiceConnectionStatus = "Pending"
	// PrivateEndpointServiceConnectionStatusRejected ...
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{PrivateEndpointServiceConnectionStatusApproved, PrivateEndpointServiceConnectionStatusPending, PrivateEndpointServiceConnectionStatusRejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateFailed Provisioning state failed.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress Provisioning state in progress.
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded Provisioning state succeeded.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateFailed, ProvisioningStateInProgress, ProvisioningStateSucceeded}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled Public network access is disabled.
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled Public network access is enabled.
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// RtspTransport enumerates the values for rtsp transport.
type RtspTransport string

const (
	// RtspTransportHTTP HTTP transport. RTSP messages are exchanged over long running HTTP requests and RTP
	// packets are interleaved within the HTTP channel.
	RtspTransportHTTP RtspTransport = "Http"
	// RtspTransportTCP TCP transport. RTSP is used directly over TCP and RTP packets are interleaved within
	// the TCP channel.
	RtspTransportTCP RtspTransport = "Tcp"
)

// PossibleRtspTransportValues returns an array of possible values for the RtspTransport const type.
func PossibleRtspTransportValues() []RtspTransport {
	return []RtspTransport{RtspTransportHTTP, RtspTransportTCP}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBatchS1 Represents the Batch S1 SKU name. Using this SKU you can create pipeline jobs to process
	// recorded content.
	SkuNameBatchS1 SkuName = "Batch_S1"
	// SkuNameLiveS1 Represents the Live S1 SKU name. Using this SKU you can create live pipelines to capture,
	// record, and stream live video from RTSP-capable cameras at bitrate settings from 0.5 Kbps to 3000 Kbps.
	SkuNameLiveS1 SkuName = "Live_S1"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBatchS1, SkuNameLiveS1}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierStandard Standard tier.
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierStandard}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeMicrosoftVideoAnalyzerEncoderProcessor ...
	TypeMicrosoftVideoAnalyzerEncoderProcessor Type = "#Microsoft.VideoAnalyzer.EncoderProcessor"
	// TypeMicrosoftVideoAnalyzerProcessorNodeBase ...
	TypeMicrosoftVideoAnalyzerProcessorNodeBase Type = "#Microsoft.VideoAnalyzer.ProcessorNodeBase"
	// TypeMicrosoftVideoAnalyzerRtspSource ...
	TypeMicrosoftVideoAnalyzerRtspSource Type = "#Microsoft.VideoAnalyzer.RtspSource"
	// TypeMicrosoftVideoAnalyzerSinkNodeBase ...
	TypeMicrosoftVideoAnalyzerSinkNodeBase Type = "#Microsoft.VideoAnalyzer.SinkNodeBase"
	// TypeMicrosoftVideoAnalyzerSourceNodeBase ...
	TypeMicrosoftVideoAnalyzerSourceNodeBase Type = "#Microsoft.VideoAnalyzer.SourceNodeBase"
	// TypeMicrosoftVideoAnalyzerVideoSink ...
	TypeMicrosoftVideoAnalyzerVideoSink Type = "#Microsoft.VideoAnalyzer.VideoSink"
	// TypeMicrosoftVideoAnalyzerVideoSource ...
	TypeMicrosoftVideoAnalyzerVideoSource Type = "#Microsoft.VideoAnalyzer.VideoSource"
	// TypeNodeBase ...
	TypeNodeBase Type = "NodeBase"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeMicrosoftVideoAnalyzerEncoderProcessor, TypeMicrosoftVideoAnalyzerProcessorNodeBase, TypeMicrosoftVideoAnalyzerRtspSource, TypeMicrosoftVideoAnalyzerSinkNodeBase, TypeMicrosoftVideoAnalyzerSourceNodeBase, TypeMicrosoftVideoAnalyzerVideoSink, TypeMicrosoftVideoAnalyzerVideoSource, TypeNodeBase}
}

// TypeBasicAudioEncoderBase enumerates the values for type basic audio encoder base.
type TypeBasicAudioEncoderBase string

const (
	// TypeBasicAudioEncoderBaseTypeAudioEncoderBase ...
	TypeBasicAudioEncoderBaseTypeAudioEncoderBase TypeBasicAudioEncoderBase = "AudioEncoderBase"
	// TypeBasicAudioEncoderBaseTypeMicrosoftVideoAnalyzerAudioEncoderAac ...
	TypeBasicAudioEncoderBaseTypeMicrosoftVideoAnalyzerAudioEncoderAac TypeBasicAudioEncoderBase = "#Microsoft.VideoAnalyzer.AudioEncoderAac"
)

// PossibleTypeBasicAudioEncoderBaseValues returns an array of possible values for the TypeBasicAudioEncoderBase const type.
func PossibleTypeBasicAudioEncoderBaseValues() []TypeBasicAudioEncoderBase {
	return []TypeBasicAudioEncoderBase{TypeBasicAudioEncoderBaseTypeAudioEncoderBase, TypeBasicAudioEncoderBaseTypeMicrosoftVideoAnalyzerAudioEncoderAac}
}

// TypeBasicAuthenticationBase enumerates the values for type basic authentication base.
type TypeBasicAuthenticationBase string

const (
	// TypeBasicAuthenticationBaseTypeAuthenticationBase ...
	TypeBasicAuthenticationBaseTypeAuthenticationBase TypeBasicAuthenticationBase = "AuthenticationBase"
	// TypeBasicAuthenticationBaseTypeMicrosoftVideoAnalyzerJwtAuthentication ...
	TypeBasicAuthenticationBaseTypeMicrosoftVideoAnalyzerJwtAuthentication TypeBasicAuthenticationBase = "#Microsoft.VideoAnalyzer.JwtAuthentication"
)

// PossibleTypeBasicAuthenticationBaseValues returns an array of possible values for the TypeBasicAuthenticationBase const type.
func PossibleTypeBasicAuthenticationBaseValues() []TypeBasicAuthenticationBase {
	return []TypeBasicAuthenticationBase{TypeBasicAuthenticationBaseTypeAuthenticationBase, TypeBasicAuthenticationBaseTypeMicrosoftVideoAnalyzerJwtAuthentication}
}

// TypeBasicCertificateSource enumerates the values for type basic certificate source.
type TypeBasicCertificateSource string

const (
	// TypeBasicCertificateSourceTypeCertificateSource ...
	TypeBasicCertificateSourceTypeCertificateSource TypeBasicCertificateSource = "CertificateSource"
	// TypeBasicCertificateSourceTypeMicrosoftVideoAnalyzerPemCertificateList ...
	TypeBasicCertificateSourceTypeMicrosoftVideoAnalyzerPemCertificateList TypeBasicCertificateSource = "#Microsoft.VideoAnalyzer.PemCertificateList"
)

// PossibleTypeBasicCertificateSourceValues returns an array of possible values for the TypeBasicCertificateSource const type.
func PossibleTypeBasicCertificateSourceValues() []TypeBasicCertificateSource {
	return []TypeBasicCertificateSource{TypeBasicCertificateSourceTypeCertificateSource, TypeBasicCertificateSourceTypeMicrosoftVideoAnalyzerPemCertificateList}
}

// TypeBasicCredentialsBase enumerates the values for type basic credentials base.
type TypeBasicCredentialsBase string

const (
	// TypeBasicCredentialsBaseTypeCredentialsBase ...
	TypeBasicCredentialsBaseTypeCredentialsBase TypeBasicCredentialsBase = "CredentialsBase"
	// TypeBasicCredentialsBaseTypeMicrosoftVideoAnalyzerUsernamePasswordCredentials ...
	TypeBasicCredentialsBaseTypeMicrosoftVideoAnalyzerUsernamePasswordCredentials TypeBasicCredentialsBase = "#Microsoft.VideoAnalyzer.UsernamePasswordCredentials"
)

// PossibleTypeBasicCredentialsBaseValues returns an array of possible values for the TypeBasicCredentialsBase const type.
func PossibleTypeBasicCredentialsBaseValues() []TypeBasicCredentialsBase {
	return []TypeBasicCredentialsBase{TypeBasicCredentialsBaseTypeCredentialsBase, TypeBasicCredentialsBaseTypeMicrosoftVideoAnalyzerUsernamePasswordCredentials}
}

// TypeBasicEncoderPresetBase enumerates the values for type basic encoder preset base.
type TypeBasicEncoderPresetBase string

const (
	// TypeBasicEncoderPresetBaseTypeEncoderPresetBase ...
	TypeBasicEncoderPresetBaseTypeEncoderPresetBase TypeBasicEncoderPresetBase = "EncoderPresetBase"
	// TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderCustomPreset ...
	TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderCustomPreset TypeBasicEncoderPresetBase = "#Microsoft.VideoAnalyzer.EncoderCustomPreset"
	// TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderSystemPreset ...
	TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderSystemPreset TypeBasicEncoderPresetBase = "#Microsoft.VideoAnalyzer.EncoderSystemPreset"
)

// PossibleTypeBasicEncoderPresetBaseValues returns an array of possible values for the TypeBasicEncoderPresetBase const type.
func PossibleTypeBasicEncoderPresetBaseValues() []TypeBasicEncoderPresetBase {
	return []TypeBasicEncoderPresetBase{TypeBasicEncoderPresetBaseTypeEncoderPresetBase, TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderCustomPreset, TypeBasicEncoderPresetBaseTypeMicrosoftVideoAnalyzerEncoderSystemPreset}
}

// TypeBasicEndpointBase enumerates the values for type basic endpoint base.
type TypeBasicEndpointBase string

const (
	// TypeBasicEndpointBaseTypeEndpointBase ...
	TypeBasicEndpointBaseTypeEndpointBase TypeBasicEndpointBase = "EndpointBase"
	// TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerTLSEndpoint ...
	TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerTLSEndpoint TypeBasicEndpointBase = "#Microsoft.VideoAnalyzer.TlsEndpoint"
	// TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerUnsecuredEndpoint ...
	TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerUnsecuredEndpoint TypeBasicEndpointBase = "#Microsoft.VideoAnalyzer.UnsecuredEndpoint"
)

// PossibleTypeBasicEndpointBaseValues returns an array of possible values for the TypeBasicEndpointBase const type.
func PossibleTypeBasicEndpointBaseValues() []TypeBasicEndpointBase {
	return []TypeBasicEndpointBase{TypeBasicEndpointBaseTypeEndpointBase, TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerTLSEndpoint, TypeBasicEndpointBaseTypeMicrosoftVideoAnalyzerUnsecuredEndpoint}
}

// TypeBasicTimeSequenceBase enumerates the values for type basic time sequence base.
type TypeBasicTimeSequenceBase string

const (
	// TypeBasicTimeSequenceBaseTypeMicrosoftVideoAnalyzerVideoSequenceAbsoluteTimeMarkers ...
	TypeBasicTimeSequenceBaseTypeMicrosoftVideoAnalyzerVideoSequenceAbsoluteTimeMarkers TypeBasicTimeSequenceBase = "#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers"
	// TypeBasicTimeSequenceBaseTypeTimeSequenceBase ...
	TypeBasicTimeSequenceBaseTypeTimeSequenceBase TypeBasicTimeSequenceBase = "TimeSequenceBase"
)

// PossibleTypeBasicTimeSequenceBaseValues returns an array of possible values for the TypeBasicTimeSequenceBase const type.
func PossibleTypeBasicTimeSequenceBaseValues() []TypeBasicTimeSequenceBase {
	return []TypeBasicTimeSequenceBase{TypeBasicTimeSequenceBaseTypeMicrosoftVideoAnalyzerVideoSequenceAbsoluteTimeMarkers, TypeBasicTimeSequenceBaseTypeTimeSequenceBase}
}

// TypeBasicTokenKey enumerates the values for type basic token key.
type TypeBasicTokenKey string

const (
	// TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey ...
	TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey TypeBasicTokenKey = "#Microsoft.VideoAnalyzer.EccTokenKey"
	// TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey ...
	TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey TypeBasicTokenKey = "#Microsoft.VideoAnalyzer.RsaTokenKey"
	// TypeBasicTokenKeyTypeTokenKey ...
	TypeBasicTokenKeyTypeTokenKey TypeBasicTokenKey = "TokenKey"
)

// PossibleTypeBasicTokenKeyValues returns an array of possible values for the TypeBasicTokenKey const type.
func PossibleTypeBasicTokenKeyValues() []TypeBasicTokenKey {
	return []TypeBasicTokenKey{TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerEccTokenKey, TypeBasicTokenKeyTypeMicrosoftVideoAnalyzerRsaTokenKey, TypeBasicTokenKeyTypeTokenKey}
}

// TypeBasicTunnelBase enumerates the values for type basic tunnel base.
type TypeBasicTunnelBase string

const (
	// TypeBasicTunnelBaseTypeMicrosoftVideoAnalyzerSecureIotDeviceRemoteTunnel ...
	TypeBasicTunnelBaseTypeMicrosoftVideoAnalyzerSecureIotDeviceRemoteTunnel TypeBasicTunnelBase = "#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel"
	// TypeBasicTunnelBaseTypeTunnelBase ...
	TypeBasicTunnelBaseTypeTunnelBase TypeBasicTunnelBase = "TunnelBase"
)

// PossibleTypeBasicTunnelBaseValues returns an array of possible values for the TypeBasicTunnelBase const type.
func PossibleTypeBasicTunnelBaseValues() []TypeBasicTunnelBase {
	return []TypeBasicTunnelBase{TypeBasicTunnelBaseTypeMicrosoftVideoAnalyzerSecureIotDeviceRemoteTunnel, TypeBasicTunnelBaseTypeTunnelBase}
}

// TypeBasicVideoEncoderBase enumerates the values for type basic video encoder base.
type TypeBasicVideoEncoderBase string

const (
	// TypeBasicVideoEncoderBaseTypeMicrosoftVideoAnalyzerVideoEncoderH264 ...
	TypeBasicVideoEncoderBaseTypeMicrosoftVideoAnalyzerVideoEncoderH264 TypeBasicVideoEncoderBase = "#Microsoft.VideoAnalyzer.VideoEncoderH264"
	// TypeBasicVideoEncoderBaseTypeVideoEncoderBase ...
	TypeBasicVideoEncoderBaseTypeVideoEncoderBase TypeBasicVideoEncoderBase = "VideoEncoderBase"
)

// PossibleTypeBasicVideoEncoderBaseValues returns an array of possible values for the TypeBasicVideoEncoderBase const type.
func PossibleTypeBasicVideoEncoderBaseValues() []TypeBasicVideoEncoderBase {
	return []TypeBasicVideoEncoderBase{TypeBasicVideoEncoderBaseTypeMicrosoftVideoAnalyzerVideoEncoderH264, TypeBasicVideoEncoderBaseTypeVideoEncoderBase}
}

// VideoScaleMode enumerates the values for video scale mode.
type VideoScaleMode string

const (
	// VideoScaleModePad Pads the video with black horizontal stripes (letterbox) or black vertical stripes
	// (pillar-box) so the video is resized to the specified dimensions while not altering the content aspect
	// ratio.
	VideoScaleModePad VideoScaleMode = "Pad"
	// VideoScaleModePreserveAspectRatio Preserves the same aspect ratio as the input video. If only one video
	// dimension is provided, the second dimension is calculated based on the input video aspect ratio. When 2
	// dimensions are provided, the video is resized to fit the most constraining dimension, considering the
	// input video size and aspect ratio.
	VideoScaleModePreserveAspectRatio VideoScaleMode = "PreserveAspectRatio"
	// VideoScaleModeStretch Stretches the original video so it resized to the specified dimensions.
	VideoScaleModeStretch VideoScaleMode = "Stretch"
)

// PossibleVideoScaleModeValues returns an array of possible values for the VideoScaleMode const type.
func PossibleVideoScaleModeValues() []VideoScaleMode {
	return []VideoScaleMode{VideoScaleModePad, VideoScaleModePreserveAspectRatio, VideoScaleModeStretch}
}

// VideoType enumerates the values for video type.
type VideoType string

const (
	// VideoTypeArchive Archive is flexible format that represents a video stream associated with wall-clock
	// time. The video archive can either be continuous or discontinuous. An archive is discontinuous when
	// there are gaps in the recording due to various reasons, such as the live pipeline being stopped, camera
	// being disconnected or due to the use of event based recordings through the use of a signal gate. There
	// is no limit to the archive duration and new video data can be appended to the existing archive at any
	// time, as long as the same video codec and codec parameters are being used. Videos of this type are
	// suitable for appending and long term archival.
	VideoTypeArchive VideoType = "Archive"
	// VideoTypeFile File represents a video which is stored as a single media file, such as MP4. Videos of
	// this type are suitable to be downloaded for external consumption.
	VideoTypeFile VideoType = "File"
)

// PossibleVideoTypeValues returns an array of possible values for the VideoType const type.
func PossibleVideoTypeValues() []VideoType {
	return []VideoType{VideoTypeArchive, VideoTypeFile}
}
