/*
*  qm_itemlist.h
*  QUIMUP library-tree item data
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_ITEMLIST_H
#define QM_ITEMLIST_H

#include <QString>
#include <stdlib.h>
#include <list>

enum
{
    //  list item types
    TP_ARTIST,
    TP_ALBUM,
    TP_GENRE,
    TP_SONG,        // song from mpd
    TP_SONGX,		// external song
    TP_NOSONG,
    TP_STREAM,      // from http address
    TP_PLAYLIST,    // playlist from mpd
    TP_DIRECTORY,
    TP_PLISTITEM, 	// no drag&drop
    TP_COMMENT,  	// no drag&drop
    TP_NOITEM
};

class qm_listItemInfo
{
public:
    qm_listItemInfo();

    int type;
    int time;
    QString disc;
    QString artist;
    QString album;
    QString title;
    QString uri;
    QString track;
    QString name; //  (dir/file name, used in library view)
    QString year;
    QString moddate;
    QString genre;
    QString sorter;

    // Override the < operator for alist.sort();
    bool operator < (const qm_listItemInfo& litem)
    {
        return sorter < litem.sorter;
    }
};


typedef std::list <qm_listItemInfo> qm_itemList;

#endif // QM_ITEMLIST_H
