/*
*  qm_colorpicker.h
*  QUIMUP window to select custom colors
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_COLOR_PICKER
#define QM_COLOR_PICKER

#include <QMainWindow>
#include <QColor>
#include <QLabel>
#include <QGridLayout>
#include <QSlider>
#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include "qm_config.h"
#include <stdio.h> // printf


class qm_colorPicker : public QMainWindow
{
    Q_OBJECT

public:
    qm_colorPicker(QWidget *parent, qm_Config *);
    ~qm_colorPicker();

public slots:
    void set_colors();

private slots:
    void set_fg_title();
    void set_bg_title();
    void set_fg_album();
    void set_bg_album();
    void on_cancel();
    void on_ok();

private:
    QSlider
        *sl_H_fg_title,
        *sl_S_fg_title,
        *sl_V_fg_title,
        *sl_H_bg_title,
        *sl_S_bg_title,
        *sl_V_bg_title,
        *sl_H_fg_album,
        *sl_S_fg_album,
        *sl_V_fg_album,
        *sl_H_bg_album,
        *sl_S_bg_album,
        *sl_V_bg_album;
    QLabel
        *lb_color_title,
        *lb_color_album;
    QColor
        color_bg_title,
        color_fg_title,
        color_bg_album,
        color_fg_album;
    QPushButton
    *bt_cancel,
    *bt_ok;
    qm_Config *config; // pointer to the parent config
signals:
    void signal_newcolors();
};

#endif // QM_COLOR_PICKER
