## SLADE  
It's a Doom Editor

### About

SLADE3 is a modern editor for Doom-engine based games and source ports. It has the ability to view, modify, and write many different game-specific formats, and even convert between some of them, or from/to other generic formats such as [PNG](http://doomwiki.org/wiki/PNG).

SLADE3 can be considered a successor to both [SLumpEd](http://doomwiki.org/wiki/SLumpEd) and [SLADE](http://doomwiki.org/wiki/SLADE) - it combines the [features](https://github.com/sirjuddington/SLADE/wiki/Features) of both, to create an all-in-one editor. Why does it keep the name of what was previously just a map editor? Because it fits :)

### Features

Here is a brief list of features implemented in the current version of SLADE:

**Basic archive/resource editing**  
All the basic resource management features you'd expect: Create/Open/Save archives, import/export, ordering, rename, etc.

**Simple tabbed interface**  
Open multiple archives at once and switch between them easily via tabs. This enables simple copy/paste from one archive to another, among many other benefits.

**Many supported game formats**  
In addition to full Doom [WAD](http://doomwiki.org/wiki/WAD) and [ZIP/PK3](http://doomwiki.org/wiki/PK3) support, many other game formats are supported, including:
* Quake PAK/WAD2 and HUD image format
* Build GRP and ART format images
* Shadowcaster DAT/LIB along with most of its image formats
* Amulets & Armor RES, MipImage and UI gfx
* [Many more](https://github.com/sirjuddington/SLADE/wiki/Supported-Data-Formats)

**Advanced text editor**  
The SLADE3 text editor can recognise many text based languages, and provide syntax hilighting, function calltips and autocomplete for them. It also has a bunch of other useful text editing features such as autoindent and find / replace.

**Graphic conversion**  
All supported graphic formats can be converted to PNG/DoomGfx/DoomFlat and more, with an advanced graphic conversion dialog that provides conversion options and previews.

**Texture editing**  
Edit Doom composite textures (TEXTUREx) with the easy-to-use SLADE3 texture editor. Also fully supports ZDoom's enhanced composite texture format (TEXTURES).

### Supporting SLADE

If you wish to help support SLADE development, feel free to make a small [donation](https://www.paypal.me/sirjuddington), though by no means is this a requirement for continued development. I work on SLADE in my free time as a hobby project and generally enjoy it, which is enough for me.

Additionally, any help on the coding side of things is greatly appreciated - take a look at the list of [issues](https://github.com/sirjuddington/SLADE/issues), and feel free to submit a [pull request](https://github.com/sirjuddington/SLADE/pulls).
