/*
 * Decompiled with CFR 0.152.
 */
package org.atpfivt.jsyntrax.generators.elements;

import java.awt.Color;
import java.awt.Font;
import org.atpfivt.jsyntrax.generators.elements.Element;
import org.atpfivt.jsyntrax.styles.StyleConfig;
import org.atpfivt.jsyntrax.util.Pair;
import org.atpfivt.jsyntrax.util.StringUtils;

public abstract class BubbleElementBase
extends Element {
    private String href;
    private String text;
    private Pair<Integer, Integer> textPos;
    private Font font;
    private String fontName;
    private Color textColor;
    private int width;
    private Color fill;

    public BubbleElementBase(Pair<Integer, Integer> start, Pair<Integer, Integer> end, String href, String text, Pair<Integer, Integer> textPos, Font font, String fontName, Color textColor, int width, Color fill, String tag) {
        super(tag);
        super.setStart(start);
        super.setEnd(end);
        this.setHref(href);
        this.setText(text);
        this.setTextPos(textPos);
        this.setFont(font);
        this.setFontName(fontName);
        this.setTextColor(textColor);
        this.setWidth(width);
        this.setFill(fill);
    }

    int getX(StyleConfig style) {
        int x0 = (Integer)this.getStart().f;
        int x1 = (Integer)this.getEnd().f;
        return (x0 + x1) / 2;
    }

    void addXMLText(StringBuilder sb, StyleConfig style) {
        int y0 = (Integer)this.getStart().s;
        int y1 = (Integer)this.getEnd().s;
        int x = this.getX(style);
        int y = (y0 + y1) / 2 + (int)((double)Math.abs((Integer)this.getTextPos().s) * 0.25 + style.getScale() * 2.0);
        String txt = StringUtils.escapeXML(this.getText());
        if (this.getHref() == null) {
            sb.append("<text class=\"").append(this.getFontName()).append("\" x=\"").append(x).append("\" y=\"").append(y).append("\">").append(txt).append("</text>\n");
        } else {
            String link = StringUtils.escapeXML(this.getHref());
            sb.append("<a xlink:href=\"").append(link).append("\" target=\"_parent\">").append("<text class=\"").append(this.getFontName()).append(" link\" x=\"").append(x).append("\" y=\"").append(y).append("\">").append(txt).append("</text></a>\n");
        }
    }

    @Override
    public void scale(double scale) {
        super.scale(scale);
        this.setWidth((int)((double)this.getWidth() * scale));
        this.getTextPos().f = (int)((double)((Integer)this.getTextPos().f).intValue() * scale);
        this.getTextPos().s = (int)((double)((Integer)this.getTextPos().s).intValue() * scale);
        if (this.getFont() != null) {
            this.setFont(this.getFont().deriveFont((float)((double)this.getFont().getSize() * scale)));
        }
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Pair<Integer, Integer> getTextPos() {
        return this.textPos;
    }

    public void setTextPos(Pair<Integer, Integer> textPos) {
        this.textPos = textPos;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Color getFill() {
        return this.fill;
    }

    public void setFill(Color fill) {
        this.fill = fill;
    }
}

