/* main-window.c generated by valac 0.56.17, the Vala compiler
 * generated from main-window.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "xfmpc.h"
#include <gtk/gtk.h>
#include <src/libc/mpdclient.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <glib-object.h>

#define XFMPC_MAIN_WINDOW_ui_string "\n" \
"<ui>\n" \
"  <accelerator action=\"quit\" />\n" \
"  <accelerator action=\"previous\" />\n" \
"  <accelerator action=\"pp\" />\n" \
"  <accelerator action=\"stop\" />\n" \
"  <accelerator action=\"next\" />\n" \
"  <accelerator action=\"volume\" />\n" \
"</ui>\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	XFMPC_MAIN_WINDOW_0_PROPERTY,
	XFMPC_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* xfmpc_main_window_properties[XFMPC_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _XfmpcMainWindowPrivate {
	GtkStatusIcon* status_icon;
	GtkMenu* status_icon_menu;
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	XfmpcInterface* interface;
	XfmpcExtendedInterface* extended_interface;
	GtkBox* vbox;
	GtkActionGroup* action_group;
	GtkUIManager* ui_manager;
	XfmpcStatusbar* statusbar;
};

static gint XfmpcMainWindow_private_offset;
static gpointer xfmpc_main_window_parent_class = NULL;

static void xfmpc_main_window_action_statusbar (XfmpcMainWindow* self,
                                         GtkAction* action);
static void _xfmpc_main_window_action_statusbar_gcallback (GtkAction* action,
                                                    gpointer self);
static void xfmpc_main_window_action_quit (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_quit_gcallback (GtkAction* action,
                                               gpointer self);
static void xfmpc_main_window_action_previous (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_previous_gcallback (GtkAction* action,
                                                   gpointer self);
static void xfmpc_main_window_action_pp (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_pp_gcallback (GtkAction* action,
                                             gpointer self);
static void xfmpc_main_window_action_stop (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_stop_gcallback (GtkAction* action,
                                               gpointer self);
static void xfmpc_main_window_action_next (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_next_gcallback (GtkAction* action,
                                               gpointer self);
static void xfmpc_main_window_action_volume (XfmpcMainWindow* self);
static void _xfmpc_main_window_action_volume_gcallback (GtkAction* action,
                                                 gpointer self);
static void xfmpc_main_window_load_css (void);
static void xfmpc_main_window_show_hide_status_icon (XfmpcMainWindow* self);
static void xfmpc_main_window_status_icon_activated (XfmpcMainWindow* self);
static void xfmpc_main_window_close_window (XfmpcMainWindow* self);
static void xfmpc_main_window_status_icon_popup_menu (XfmpcMainWindow* self,
                                               guint button,
                                               guint activate_time);
static void _gtk_main_quit_gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu,
                                                            gint* x,
                                                            gint* y,
                                                            gboolean* push_in,
                                                            gpointer self);
static gboolean xfmpc_main_window_refresh (XfmpcMainWindow* self);
static gboolean xfmpc_main_window_cb_window_state_event (XfmpcMainWindow* self,
                                                  GdkEventWindowState* event);
static gboolean xfmpc_main_window_cb_window_closed (XfmpcMainWindow* self,
                                             GdkEvent* event);
static void xfmpc_main_window_update_statusbar (XfmpcMainWindow* self);
static void xfmpc_main_window_cb_playlist_changed (XfmpcMainWindow* self);
static void xfmpc_main_window_update_window_title (XfmpcMainWindow* self);
static void xfmpc_main_window_cb_show_statusbar_changed (XfmpcMainWindow* self,
                                                  GParamSpec* pspec);
static GObject * xfmpc_main_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _xfmpc_main_window_status_icon_activated_gtk_status_icon_activate (GtkStatusIcon* _sender,
                                                                        gpointer self);
static void _xfmpc_main_window_status_icon_popup_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender,
                                                                           guint button,
                                                                           guint activate_time,
                                                                           gpointer self);
static void _xfmpc_main_window_show_hide_status_icon_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static gboolean _xfmpc_main_window_cb_window_closed_gtk_widget_delete_event (GtkWidget* _sender,
                                                                      GdkEventAny* event,
                                                                      gpointer self);
static gboolean _xfmpc_main_window_cb_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                 GdkEventWindowState* event,
                                                                                 gpointer self);
static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender,
                                                                        gboolean is_playing,
                                                                        gpointer self);
static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender,
                                                                     gpointer self);
static void _xfmpc_main_window_update_window_title_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender,
                                                                          gpointer self);
static void _xfmpc_main_window_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender,
                                                                              gpointer self);
static void _xfmpc_main_window_cb_show_statusbar_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static gboolean _xfmpc_main_window_refresh_gsource_func (gpointer self);
static void xfmpc_main_window_finalize (GObject * obj);
static GType xfmpc_main_window_get_type_once (void);

static const GtkToggleActionEntry XFMPC_MAIN_WINDOW_toggle_action_entries[1] = {{"view-statusbar", NULL, "", NULL, NULL, (GCallback) _xfmpc_main_window_action_statusbar_gcallback, FALSE}};
static const GtkActionEntry XFMPC_MAIN_WINDOW_action_entries[6] = {{"quit", NULL, "", "<control>q", NULL, (GCallback) _xfmpc_main_window_action_quit_gcallback}, {"previous", NULL, "", "<control>b", NULL, (GCallback) _xfmpc_main_window_action_previous_gcallback}, {"pp", NULL, "", "<control>p", NULL, (GCallback) _xfmpc_main_window_action_pp_gcallback}, {"stop", NULL, "", "<control>s", NULL, (GCallback) _xfmpc_main_window_action_stop_gcallback}, {"next", NULL, "", "<control>f", NULL, (GCallback) _xfmpc_main_window_action_next_gcallback}, {"volume", NULL, "", "<control>v", NULL, (GCallback) _xfmpc_main_window_action_volume_gcallback}};

static inline gpointer
xfmpc_main_window_get_instance_private (XfmpcMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, XfmpcMainWindow_private_offset);
}

static void
_xfmpc_main_window_action_statusbar_gcallback (GtkAction* action,
                                               gpointer self)
{
	xfmpc_main_window_action_statusbar ((XfmpcMainWindow*) self, action);
}

static void
_xfmpc_main_window_action_quit_gcallback (GtkAction* action,
                                          gpointer self)
{
	xfmpc_main_window_action_quit ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_action_previous_gcallback (GtkAction* action,
                                              gpointer self)
{
	xfmpc_main_window_action_previous ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_action_pp_gcallback (GtkAction* action,
                                        gpointer self)
{
	xfmpc_main_window_action_pp ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_action_stop_gcallback (GtkAction* action,
                                          gpointer self)
{
	xfmpc_main_window_action_stop ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_action_next_gcallback (GtkAction* action,
                                          gpointer self)
{
	xfmpc_main_window_action_next ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_action_volume_gcallback (GtkAction* action,
                                            gpointer self)
{
	xfmpc_main_window_action_volume ((XfmpcMainWindow*) self);
}

static void
xfmpc_main_window_load_css (void)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkScreen* _tmp3_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		gtk_css_provider_load_from_data (provider, ".primary-button { padding-left: 8px; padding-right: 8px; }" ".red { background-color: #FF6666; }", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("main-window.vala:148: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
}

static void
xfmpc_main_window_show_hide_status_icon (XfmpcMainWindow* self)
{
	GtkStatusIcon* _tmp0_;
	XfmpcPreferences* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_icon;
	_tmp1_ = self->priv->preferences;
	_tmp2_ = xfmpc_preferences_get_show_status_icon (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_status_icon_set_visible (_tmp0_, _tmp3_);
}

static void
xfmpc_main_window_status_icon_activated (XfmpcMainWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gtk_widget_show ((GtkWidget*) self);
		gtk_window_deiconify ((GtkWindow*) self);
	} else {
		xfmpc_main_window_close_window (self);
	}
}

static void
_gtk_main_quit_gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	gtk_main_quit ();
}

static void
_gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu,
                                                       gint* x,
                                                       gint* y,
                                                       gboolean* push_in,
                                                       gpointer self)
{
	gtk_status_icon_position_menu (menu, x, y, push_in, (GtkStatusIcon*) self);
	g_object_unref (self);
}

static void
xfmpc_main_window_status_icon_popup_menu (XfmpcMainWindow* self,
                                          guint button,
                                          guint activate_time)
{
	GtkMenu* _tmp0_;
	GtkMenu* _tmp7_;
	GtkStatusIcon* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_icon_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_;
		GtkMenuItem* mi = NULL;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkMenuItem* _tmp5_;
		GtkMenu* _tmp6_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->status_icon_menu);
		self->priv->status_icon_menu = _tmp1_;
		_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Quit"));
		g_object_ref_sink (_tmp2_);
		mi = _tmp2_;
		_tmp3_ = mi;
		g_signal_connect (_tmp3_, "activate", (GCallback) _gtk_main_quit_gtk_menu_item_activate, NULL);
		_tmp4_ = self->priv->status_icon_menu;
		_tmp5_ = mi;
		gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->status_icon_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
		_g_object_unref0 (mi);
	}
	_tmp7_ = self->priv->status_icon_menu;
	_tmp8_ = self->priv->status_icon;
	gtk_menu_popup (_tmp7_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, g_object_ref (_tmp8_), button, (guint32) activate_time);
}

static gboolean
xfmpc_main_window_refresh (XfmpcMainWindow* self)
{
	XfmpcMpdclient* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->mpdclient;
	if (xfmpc_mpdclient_is_connected (_tmp0_)) {
		XfmpcMpdclient* _tmp1_;
		_tmp1_ = self->priv->mpdclient;
		xfmpc_mpdclient_update_status (_tmp1_);
	} else {
		XfmpcInterface* _tmp2_;
		XfmpcMpdclient* _tmp3_;
		XfmpcStatusbar* _tmp4_;
		XfmpcMpdclient* _tmp6_;
		XfmpcMpdclient* _tmp7_;
		_tmp2_ = self->priv->interface;
		xfmpc_interface_reset (_tmp2_);
		_tmp3_ = self->priv->mpdclient;
		xfmpc_mpdclient_reload (_tmp3_);
		_tmp4_ = self->priv->statusbar;
		if (_tmp4_ != NULL) {
			XfmpcStatusbar* _tmp5_;
			_tmp5_ = self->priv->statusbar;
			xfmpc_statusbar_set_text (_tmp5_, "");
		}
		_tmp6_ = self->priv->mpdclient;
		xfmpc_mpdclient_connect (_tmp6_);
		_tmp7_ = self->priv->mpdclient;
		if (xfmpc_mpdclient_is_connected (_tmp7_)) {
			XfmpcInterface* _tmp8_;
			_tmp8_ = self->priv->interface;
			xfmpc_interface_update_title (_tmp8_);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
xfmpc_main_window_cb_window_state_event (XfmpcMainWindow* self,
                                         GdkEventWindowState* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type != GDK_WINDOW_STATE) {
		result = FALSE;
		return result;
	}
	if ((gboolean) (event->changed_mask & GDK_WINDOW_STATE_STICKY)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = gtk_widget_get_visible ((GtkWidget*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean sticky = FALSE;
		XfmpcPreferences* _tmp3_;
		if (((gboolean) (event->new_window_state & GDK_WINDOW_STATE_STICKY)) == FALSE) {
			sticky = FALSE;
		} else {
			sticky = TRUE;
		}
		_tmp3_ = self->priv->preferences;
		xfmpc_preferences_set_last_window_state_sticky (_tmp3_, sticky);
	}
	result = FALSE;
	return result;
}

static gboolean
xfmpc_main_window_cb_window_closed (XfmpcMainWindow* self,
                                    GdkEvent* event)
{
	GtkStatusIcon* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	xfmpc_main_window_close_window (self);
	_tmp0_ = self->priv->status_icon;
	_tmp1_ = gtk_status_icon_get_visible (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
xfmpc_main_window_action_quit (XfmpcMainWindow* self)
{
	GtkStatusIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_icon;
	gtk_status_icon_set_visible (_tmp0_, FALSE);
	xfmpc_main_window_close_window (self);
}

static void
xfmpc_main_window_close_window (XfmpcMainWindow* self)
{
	gint posx = 0;
	gint posy = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	XfmpcPreferences* _tmp4_;
	XfmpcPreferences* _tmp5_;
	XfmpcPreferences* _tmp6_;
	XfmpcPreferences* _tmp7_;
	GtkStatusIcon* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	gtk_window_get_position ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	posx = _tmp0_;
	posy = _tmp1_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_tmp4_ = self->priv->preferences;
	xfmpc_preferences_set_last_window_posx (_tmp4_, posx);
	_tmp5_ = self->priv->preferences;
	xfmpc_preferences_set_last_window_posy (_tmp5_, posy);
	_tmp6_ = self->priv->preferences;
	xfmpc_preferences_set_last_window_width (_tmp6_, width);
	_tmp7_ = self->priv->preferences;
	xfmpc_preferences_set_last_window_height (_tmp7_, height);
	_tmp8_ = self->priv->status_icon;
	_tmp9_ = gtk_status_icon_get_visible (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		XfmpcPreferences* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		XfmpcPreferences* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gtk_widget_hide ((GtkWidget*) self);
		_tmp11_ = self->priv->preferences;
		_tmp12_ = xfmpc_preferences_get_last_window_posx (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->preferences;
		_tmp15_ = xfmpc_preferences_get_last_window_posy (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_window_move ((GtkWindow*) self, _tmp13_, _tmp16_);
		return;
	}
	gtk_main_quit ();
}

static void
xfmpc_main_window_action_previous (XfmpcMainWindow* self)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_previous (_tmp0_);
}

static void
xfmpc_main_window_action_pp (XfmpcMainWindow* self)
{
	XfmpcInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interface;
	xfmpc_interface_pp_clicked (_tmp0_);
}

static void
xfmpc_main_window_action_stop (XfmpcMainWindow* self)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_stop (_tmp0_);
}

static void
xfmpc_main_window_action_next (XfmpcMainWindow* self)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_next (_tmp0_);
}

static void
xfmpc_main_window_action_volume (XfmpcMainWindow* self)
{
	XfmpcInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interface;
	xfmpc_interface_popup_volume (_tmp0_);
}

static void
xfmpc_main_window_action_statusbar (XfmpcMainWindow* self,
                                    GtkAction* action)
{
	gboolean active = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	active = gtk_toggle_action_get_active (G_TYPE_CHECK_INSTANCE_CAST (action, gtk_toggle_action_get_type (), GtkToggleAction));
	if (!active) {
		XfmpcStatusbar* _tmp1_;
		_tmp1_ = self->priv->statusbar;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		XfmpcStatusbar* _tmp2_;
		_tmp2_ = self->priv->statusbar;
		gtk_widget_destroy ((GtkWidget*) _tmp2_);
		_g_object_unref0 (self->priv->statusbar);
		self->priv->statusbar = NULL;
	} else {
		gboolean _tmp3_ = FALSE;
		if (active) {
			XfmpcStatusbar* _tmp4_;
			_tmp4_ = self->priv->statusbar;
			_tmp3_ = _tmp4_ == NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			XfmpcStatusbar* _tmp5_;
			XfmpcStatusbar* _tmp6_;
			GtkBox* _tmp7_;
			XfmpcStatusbar* _tmp8_;
			_tmp5_ = xfmpc_statusbar_new ();
			g_object_ref_sink (_tmp5_);
			_g_object_unref0 (self->priv->statusbar);
			self->priv->statusbar = _tmp5_;
			_tmp6_ = self->priv->statusbar;
			gtk_widget_show ((GtkWidget*) _tmp6_);
			_tmp7_ = self->priv->vbox;
			_tmp8_ = self->priv->statusbar;
			gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
		}
	}
}

static void
xfmpc_main_window_update_statusbar (XfmpcMainWindow* self)
{
	gint seconds = 0;
	gint length = 0;
	XfmpcStatusbar* _tmp0_;
	XfmpcMpdclient* _tmp1_;
	XfmpcMpdclient* _tmp2_;
	XfmpcMpdclient* _tmp3_;
	GString* text = NULL;
	GString* _tmp4_;
	XfmpcStatusbar* _tmp7_;
	GString* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->statusbar;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->mpdclient;
	if (!xfmpc_mpdclient_is_connected (_tmp1_)) {
		return;
	}
	_tmp2_ = self->priv->mpdclient;
	length = xfmpc_mpdclient_playlist_get_length (_tmp2_);
	_tmp3_ = self->priv->mpdclient;
	seconds = xfmpc_mpdclient_playlist_get_total_time (_tmp3_);
	_tmp4_ = g_string_new ("");
	text = _tmp4_;
	if ((seconds / 3600) > 0) {
		GString* _tmp5_;
		_tmp5_ = text;
		g_string_append_printf (_tmp5_, _ ("%d songs, %d hours and %d minutes"), length, seconds / 3600, (seconds / 60) % 60);
	} else {
		GString* _tmp6_;
		_tmp6_ = text;
		g_string_append_printf (_tmp6_, _ ("%d songs, %d minutes"), length, (seconds / 60) % 60);
	}
	_tmp7_ = self->priv->statusbar;
	_tmp8_ = text;
	_tmp9_ = _tmp8_->str;
	xfmpc_statusbar_set_text (_tmp7_, _tmp9_);
	_g_string_free0 (text);
}

static void
xfmpc_main_window_cb_playlist_changed (XfmpcMainWindow* self)
{
	g_return_if_fail (self != NULL);
	xfmpc_main_window_update_statusbar (self);
	xfmpc_main_window_update_window_title (self);
}

static void
xfmpc_main_window_update_window_title (XfmpcMainWindow* self)
{
	gchar* _title = NULL;
	gboolean _tmp0_ = FALSE;
	XfmpcMpdclient* _tmp1_;
	const gchar* _tmp2_;
	XfmpcMpdclient* _tmp21_;
	GtkStatusIcon* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->mpdclient;
	_tmp2_ = xfmpc_mpdclient_get_artist (_tmp1_);
	if (g_strcmp0 (_tmp2_, "n/a") != 0) {
		XfmpcMpdclient* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->mpdclient;
		_tmp4_ = xfmpc_mpdclient_get_title (_tmp3_);
		_tmp0_ = g_strcmp0 (_tmp4_, "n/a") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		XfmpcMpdclient* _tmp5_;
		const gchar* _tmp6_;
		XfmpcMpdclient* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = self->priv->mpdclient;
		_tmp6_ = xfmpc_mpdclient_get_artist (_tmp5_);
		_tmp7_ = self->priv->mpdclient;
		_tmp8_ = xfmpc_mpdclient_get_title (_tmp7_);
		_tmp9_ = g_strdup_printf ("%s - %s", _tmp6_, _tmp8_);
		_g_free0 (_title);
		_title = _tmp9_;
	} else {
		XfmpcMpdclient* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->mpdclient;
		_tmp11_ = xfmpc_mpdclient_get_artist (_tmp10_);
		if (g_strcmp0 (_tmp11_, "n/a") == 0) {
			XfmpcMpdclient* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = self->priv->mpdclient;
			_tmp13_ = xfmpc_mpdclient_get_title (_tmp12_);
			_tmp14_ = g_strdup_printf ("%s", _tmp13_);
			_g_free0 (_title);
			_title = _tmp14_;
		} else {
			XfmpcMpdclient* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = self->priv->mpdclient;
			_tmp16_ = xfmpc_mpdclient_get_title (_tmp15_);
			if (g_strcmp0 (_tmp16_, "n/a") == 0) {
				XfmpcMpdclient* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = self->priv->mpdclient;
				_tmp18_ = xfmpc_mpdclient_get_artist (_tmp17_);
				_tmp19_ = g_strdup_printf ("%s", _tmp18_);
				_g_free0 (_title);
				_title = _tmp19_;
			} else {
				gchar* _tmp20_;
				_tmp20_ = g_strdup (PACKAGE_NAME);
				_g_free0 (_title);
				_title = _tmp20_;
			}
		}
	}
	_tmp21_ = self->priv->mpdclient;
	if (xfmpc_mpdclient_is_playing (_tmp21_)) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp22_ = _title;
		_tmp23_ = g_strconcat (_tmp22_, " - ", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, PACKAGE_NAME, NULL);
		_tmp26_ = _tmp25_;
		gtk_window_set_title ((GtkWindow*) self, _tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
	} else {
		XfmpcMpdclient* _tmp27_;
		_tmp27_ = self->priv->mpdclient;
		if (xfmpc_mpdclient_is_paused (_tmp27_)) {
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp28_ = _title;
			_tmp29_ = g_strconcat ("[", _tmp28_, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp30_, "] - ", NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp32_, PACKAGE_NAME, NULL);
			_tmp34_ = _tmp33_;
			gtk_window_set_title ((GtkWindow*) self, _tmp34_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
		} else {
			gtk_window_set_title ((GtkWindow*) self, PACKAGE_NAME);
		}
	}
	_tmp35_ = self->priv->status_icon;
	_tmp36_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp37_ = _tmp36_;
	gtk_status_icon_set_tooltip_text (_tmp35_, _tmp37_);
	_g_free0 (_title);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
xfmpc_main_window_cb_show_statusbar_changed (XfmpcMainWindow* self,
                                             GParamSpec* pspec)
{
	GtkAction* action = NULL;
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	gboolean active = FALSE;
	XfmpcPreferences* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->action_group;
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "view-statusbar");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action = _tmp2_;
	_tmp3_ = self->priv->preferences;
	_tmp4_ = xfmpc_preferences_get_show_statusbar (_tmp3_);
	_tmp5_ = _tmp4_;
	active = _tmp5_;
	gtk_toggle_action_set_active (G_TYPE_CHECK_INSTANCE_CAST (action, gtk_toggle_action_get_type (), GtkToggleAction), active);
	xfmpc_main_window_update_statusbar (self);
	_g_object_unref0 (action);
}

XfmpcMainWindow*
xfmpc_main_window_construct (GType object_type)
{
	XfmpcMainWindow * self = NULL;
	self = (XfmpcMainWindow*) g_object_new (object_type, NULL);
	return self;
}

XfmpcMainWindow*
xfmpc_main_window_new (void)
{
	return xfmpc_main_window_construct (XFMPC_TYPE_MAIN_WINDOW);
}

static void
_xfmpc_main_window_status_icon_activated_gtk_status_icon_activate (GtkStatusIcon* _sender,
                                                                   gpointer self)
{
	xfmpc_main_window_status_icon_activated ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_status_icon_popup_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender,
                                                                      guint button,
                                                                      guint activate_time,
                                                                      gpointer self)
{
	xfmpc_main_window_status_icon_popup_menu ((XfmpcMainWindow*) self, button, activate_time);
}

static void
_xfmpc_main_window_show_hide_status_icon_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	xfmpc_main_window_show_hide_status_icon ((XfmpcMainWindow*) self);
}

static gboolean
_xfmpc_main_window_cb_window_closed_gtk_widget_delete_event (GtkWidget* _sender,
                                                             GdkEventAny* event,
                                                             gpointer self)
{
	gboolean result;
	result = xfmpc_main_window_cb_window_closed ((XfmpcMainWindow*) self, event);
	return result;
}

static gboolean
_xfmpc_main_window_cb_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                        GdkEventWindowState* event,
                                                                        gpointer self)
{
	gboolean result;
	result = xfmpc_main_window_cb_window_state_event ((XfmpcMainWindow*) self, event);
	return result;
}

static void
_xfmpc_main_window_update_window_title_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender,
                                                                   gboolean is_playing,
                                                                   gpointer self)
{
	xfmpc_main_window_update_window_title ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_update_window_title_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender,
                                                                gpointer self)
{
	xfmpc_main_window_update_window_title ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_update_window_title_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender,
                                                                     gpointer self)
{
	xfmpc_main_window_update_window_title ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender,
                                                                         gpointer self)
{
	xfmpc_main_window_cb_playlist_changed ((XfmpcMainWindow*) self);
}

static void
_xfmpc_main_window_cb_show_statusbar_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	xfmpc_main_window_cb_show_statusbar_changed ((XfmpcMainWindow*) self, pspec);
}

static gboolean
_xfmpc_main_window_refresh_gsource_func (gpointer self)
{
	gboolean result;
	result = xfmpc_main_window_refresh ((XfmpcMainWindow*) self);
	return result;
}

static GObject *
xfmpc_main_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcMainWindow * self;
	XfmpcMpdclient* _tmp0_;
	XfmpcPreferences* _tmp1_;
	GtkStatusIcon* _tmp2_;
	GtkStatusIcon* _tmp3_;
	GtkStatusIcon* _tmp4_;
	XfmpcPreferences* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	gboolean _tmp8_ = FALSE;
	XfmpcPreferences* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp21_ = FALSE;
	XfmpcPreferences* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	XfmpcPreferences* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	XfmpcInterface* _tmp37_;
	GtkBox* _tmp38_;
	XfmpcInterface* _tmp39_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp40_;
	GtkBox* _tmp41_;
	GtkSeparator* _tmp42_;
	XfmpcExtendedInterface* _tmp43_;
	GtkBox* _tmp44_;
	XfmpcExtendedInterface* _tmp45_;
	GtkUIManager* _tmp46_;
	GtkActionGroup* _tmp47_;
	GtkActionGroup* _tmp48_;
	GtkActionGroup* _tmp49_;
	GtkUIManager* _tmp50_;
	GtkActionGroup* _tmp51_;
	GtkAccelGroup* accel_group = NULL;
	GtkUIManager* _tmp55_;
	GtkAccelGroup* _tmp56_;
	GtkAccelGroup* _tmp57_;
	GtkAccelGroup* _tmp58_;
	GtkActionGroup* _tmp59_;
	GtkAction* _tmp60_;
	XfmpcPreferences* _tmp61_;
	gboolean _tmp62_;
	gboolean _tmp63_;
	XfmpcMpdclient* _tmp64_;
	XfmpcMpdclient* _tmp65_;
	XfmpcMpdclient* _tmp66_;
	XfmpcMpdclient* _tmp67_;
	XfmpcPreferences* _tmp68_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (xfmpc_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_MAIN_WINDOW, XfmpcMainWindow);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	xfmpc_main_window_load_css ();
	_tmp2_ = gtk_status_icon_new_from_icon_name ("multimedia-player");
	_g_object_unref0 (self->priv->status_icon);
	self->priv->status_icon = _tmp2_;
	xfmpc_main_window_show_hide_status_icon (self);
	_tmp3_ = self->priv->status_icon;
	g_signal_connect_object (_tmp3_, "activate", (GCallback) _xfmpc_main_window_status_icon_activated_gtk_status_icon_activate, self, 0);
	_tmp4_ = self->priv->status_icon;
	g_signal_connect_object (_tmp4_, "popup-menu", (GCallback) _xfmpc_main_window_status_icon_popup_menu_gtk_status_icon_popup_menu, self, 0);
	_tmp5_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::show-status-icon", (GCallback) _xfmpc_main_window_show_hide_status_icon_g_object_notify, self, 0);
	gtk_window_set_default_icon_name ("xfmpc");
	gtk_window_set_icon_name ((GtkWindow*) self, "multimedia-player");
	gtk_window_set_title ((GtkWindow*) self, PACKAGE_NAME);
	gtk_window_set_default_size ((GtkWindow*) self, 330, 330);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _xfmpc_main_window_cb_window_closed_gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _xfmpc_main_window_cb_window_state_event_gtk_widget_window_state_event, self, 0);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->vbox);
	self->priv->vbox = _tmp6_;
	_tmp7_ = self->priv->vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp7_);
	_tmp9_ = self->priv->preferences;
	_tmp10_ = xfmpc_preferences_get_last_window_posx (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != -1) {
		XfmpcPreferences* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = self->priv->preferences;
		_tmp13_ = xfmpc_preferences_get_last_window_posy (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp8_ = _tmp14_ != -1;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		XfmpcPreferences* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		XfmpcPreferences* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp15_ = self->priv->preferences;
		_tmp16_ = xfmpc_preferences_get_last_window_posx (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->preferences;
		_tmp19_ = xfmpc_preferences_get_last_window_posy (_tmp18_);
		_tmp20_ = _tmp19_;
		gtk_window_move ((GtkWindow*) self, _tmp17_, _tmp20_);
	}
	_tmp22_ = self->priv->preferences;
	_tmp23_ = xfmpc_preferences_get_last_window_width (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ != -1) {
		XfmpcPreferences* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp25_ = self->priv->preferences;
		_tmp26_ = xfmpc_preferences_get_last_window_height (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp21_ = _tmp27_ != -1;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		XfmpcPreferences* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		XfmpcPreferences* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp28_ = self->priv->preferences;
		_tmp29_ = xfmpc_preferences_get_last_window_width (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = self->priv->preferences;
		_tmp32_ = xfmpc_preferences_get_last_window_height (_tmp31_);
		_tmp33_ = _tmp32_;
		gtk_window_set_default_size ((GtkWindow*) self, _tmp30_, _tmp33_);
	}
	_tmp34_ = self->priv->preferences;
	_tmp35_ = xfmpc_preferences_get_last_window_state_sticky (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ == TRUE) {
		gtk_window_stick ((GtkWindow*) self);
	}
	_tmp37_ = xfmpc_interface_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->interface);
	self->priv->interface = _tmp37_;
	_tmp38_ = self->priv->vbox;
	_tmp39_ = self->priv->interface;
	gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 4);
	_tmp40_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp40_);
	separator = _tmp40_;
	_tmp41_ = self->priv->vbox;
	_tmp42_ = separator;
	gtk_box_pack_start (_tmp41_, (GtkWidget*) _tmp42_, FALSE, FALSE, (guint) 0);
	_tmp43_ = xfmpc_extended_interface_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->extended_interface);
	self->priv->extended_interface = _tmp43_;
	_tmp44_ = self->priv->vbox;
	_tmp45_ = self->priv->extended_interface;
	gtk_box_pack_start (_tmp44_, (GtkWidget*) _tmp45_, TRUE, TRUE, (guint) 0);
	_tmp46_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->ui_manager);
	self->priv->ui_manager = _tmp46_;
	_tmp47_ = gtk_action_group_new ("XfmpcMainWindow");
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp47_;
	_tmp48_ = self->priv->action_group;
	gtk_action_group_add_actions (_tmp48_, XFMPC_MAIN_WINDOW_action_entries, (guint) G_N_ELEMENTS (XFMPC_MAIN_WINDOW_action_entries), self);
	_tmp49_ = self->priv->action_group;
	gtk_action_group_add_toggle_actions (_tmp49_, XFMPC_MAIN_WINDOW_toggle_action_entries, (guint) G_N_ELEMENTS (XFMPC_MAIN_WINDOW_toggle_action_entries), self);
	_tmp50_ = self->priv->ui_manager;
	_tmp51_ = self->priv->action_group;
	gtk_ui_manager_insert_action_group (_tmp50_, _tmp51_, 0);
	{
		GtkUIManager* _tmp52_;
		_tmp52_ = self->priv->ui_manager;
		gtk_ui_manager_add_ui_from_string (_tmp52_, XFMPC_MAIN_WINDOW_ui_string, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp53_;
		const gchar* _tmp54_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp53_ = e;
		_tmp54_ = _tmp53_->message;
		g_warning ("main-window.vala:119: %s", _tmp54_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (separator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp55_ = self->priv->ui_manager;
	_tmp56_ = gtk_ui_manager_get_accel_group (_tmp55_);
	_tmp57_ = _g_object_ref0 (_tmp56_);
	accel_group = _tmp57_;
	_tmp58_ = accel_group;
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp58_);
	_tmp59_ = self->priv->action_group;
	_tmp60_ = gtk_action_group_get_action (_tmp59_, "view-statusbar");
	_tmp61_ = self->priv->preferences;
	_tmp62_ = xfmpc_preferences_get_show_statusbar (_tmp61_);
	_tmp63_ = _tmp62_;
	gtk_toggle_action_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_toggle_action_get_type (), GtkToggleAction), _tmp63_);
	_tmp64_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp64_, "pp-changed", (GCallback) _xfmpc_main_window_update_window_title_xfmpc_mpdclient_pp_changed, self, 0);
	_tmp65_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp65_, "stopped", (GCallback) _xfmpc_main_window_update_window_title_xfmpc_mpdclient_stopped, self, 0);
	_tmp66_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp66_, "song-changed", (GCallback) _xfmpc_main_window_update_window_title_xfmpc_mpdclient_song_changed, self, 0);
	_tmp67_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp67_, "playlist-changed", (GCallback) _xfmpc_main_window_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp68_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp68_, "notify::show-statusbar", (GCallback) _xfmpc_main_window_cb_show_statusbar_changed_g_object_notify, self, 0);
	gdk_threads_add_timeout ((guint) 1000, _xfmpc_main_window_refresh_gsource_func, self);
	_g_object_unref0 (accel_group);
	_g_object_unref0 (separator);
	return obj;
}

static void
xfmpc_main_window_class_init (XfmpcMainWindowClass * klass,
                              gpointer klass_data)
{
	xfmpc_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XfmpcMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = xfmpc_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_main_window_finalize;
}

static void
xfmpc_main_window_instance_init (XfmpcMainWindow * self,
                                 gpointer klass)
{
	self->priv = xfmpc_main_window_get_instance_private (self);
}

static void
xfmpc_main_window_finalize (GObject * obj)
{
	XfmpcMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_MAIN_WINDOW, XfmpcMainWindow);
	_g_object_unref0 (self->priv->status_icon);
	_g_object_unref0 (self->priv->status_icon_menu);
	_g_object_unref0 (self->priv->interface);
	_g_object_unref0 (self->priv->extended_interface);
	_g_object_unref0 (self->priv->vbox);
	_g_object_unref0 (self->priv->action_group);
	_g_object_unref0 (self->priv->ui_manager);
	_g_object_unref0 (self->priv->statusbar);
	G_OBJECT_CLASS (xfmpc_main_window_parent_class)->finalize (obj);
}

static GType
xfmpc_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XfmpcMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcMainWindow), 0, (GInstanceInitFunc) xfmpc_main_window_instance_init, NULL };
	GType xfmpc_main_window_type_id;
	xfmpc_main_window_type_id = g_type_register_static (gtk_window_get_type (), "XfmpcMainWindow", &g_define_type_info, 0);
	XfmpcMainWindow_private_offset = g_type_add_instance_private (xfmpc_main_window_type_id, sizeof (XfmpcMainWindowPrivate));
	return xfmpc_main_window_type_id;
}

GType
xfmpc_main_window_get_type (void)
{
	static volatile gsize xfmpc_main_window_type_id__once = 0;
	if (g_once_init_enter (&xfmpc_main_window_type_id__once)) {
		GType xfmpc_main_window_type_id;
		xfmpc_main_window_type_id = xfmpc_main_window_get_type_once ();
		g_once_init_leave (&xfmpc_main_window_type_id__once, xfmpc_main_window_type_id);
	}
	return xfmpc_main_window_type_id__once;
}

