/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInheritance {
    private static List<ITestNGMethod> findMethodListSuperClass(Map<Class, List<ITestNGMethod>> map, Class<? extends ITestNGMethod> methodClass) {
        for (Class cls : map.keySet()) {
            if (!cls.isAssignableFrom(methodClass)) continue;
            return map.get(cls);
        }
        return null;
    }

    private static Class findSubClass(Map<Class, List<ITestNGMethod>> map, Class<? extends ITestNGMethod> methodClass) {
        for (Class cls : map.keySet()) {
            if (!methodClass.isAssignableFrom(cls)) continue;
            return cls;
        }
        return null;
    }

    public static void fixMethodInheritance(ITestNGMethod[] methods, boolean baseClassToChild) {
        HashMap<Class, List<ITestNGMethod>> map = new HashMap<Class, List<ITestNGMethod>>();
        for (ITestNGMethod m : methods) {
            String[] mdu = m.getMethodsDependedUpon();
            String[] groups = m.getGroupsDependedUpon();
            if ((mdu == null || mdu.length <= 0) && (groups == null || groups.length <= 0)) continue;
            return;
        }
        for (ITestNGMethod method : methods) {
            Class methodClass = method.getRealClass();
            List l = MethodInheritance.findMethodListSuperClass(map, methodClass);
            if (null != l) {
                l.add((ITestNGMethod)method);
                continue;
            }
            Class subClass = MethodInheritance.findSubClass(map, methodClass);
            if (null != subClass) {
                l = (List)map.get(subClass);
                l.add(method);
                map.remove(subClass);
                map.put(methodClass, l);
                continue;
            }
            l = new ArrayList<ITestNGMethod>();
            l.add(method);
            map.put(methodClass, l);
        }
        for (List l : map.values()) {
            ITestNGMethod m2;
            ITestNGMethod m1;
            int i;
            if (l.size() <= 1) continue;
            MethodInheritance.sortMethodsByInheritance(l, baseClassToChild);
            if (baseClassToChild) {
                for (i = 1; i < l.size(); ++i) {
                    m1 = (ITestNGMethod)l.get(i - 1);
                    if (MethodInheritance.equalsEffectiveClass(m1, m2 = (ITestNGMethod)l.get(i))) continue;
                    Utils.log("MethodInheritance", 4, m2 + " DEPENDS ON " + m1);
                    m2.addMethodDependedUpon(MethodHelper.calculateMethodCanonicalName(m1));
                }
                continue;
            }
            for (i = 0; i < l.size() - 1; ++i) {
                m1 = (ITestNGMethod)l.get(i);
                if (MethodInheritance.equalsEffectiveClass(m1, m2 = (ITestNGMethod)l.get(i + 1))) continue;
                m2.addMethodDependedUpon(MethodHelper.calculateMethodCanonicalName(m1));
                Utils.log("MethodInheritance", 4, m2 + " DEPENDS ON " + m1);
            }
        }
    }

    private static boolean equalsEffectiveClass(ITestNGMethod m1, ITestNGMethod m2) {
        try {
            Class c1 = m1.getRealClass();
            Class c2 = m2.getRealClass();
            boolean isEqual = c1 == null ? c2 == null : c1.equals(c2);
            return isEqual;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void sortMethodsByInheritance(List<ITestNGMethod> methods, boolean baseClassToChild) {
        Collections.sort(methods);
        if (!baseClassToChild) {
            Collections.reverse(methods);
        }
    }

    private static void ppp(String s) {
        System.out.println("[MethodInheritance] " + s);
    }
}

