/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.model;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.work.Synchronizer;

@ThreadSafe
public class StateTransitionController<T extends State> {
    private final DisplayName displayName;
    private final Synchronizer synchronizer;
    private volatile CurrentState<T> state;

    public StateTransitionController(DisplayName displayName, T initialState, Synchronizer synchronizer) {
        this.displayName = displayName;
        this.synchronizer = synchronizer;
        this.state = new InState<T>(displayName, initialState, null);
    }

    public void assertNotInState(T forbidden) {
        if (this.state.state == forbidden) {
            throw new IllegalStateException(this.displayName.getCapitalizedDisplayName() + " should not be in state " + forbidden + ".");
        }
    }

    public void assertInStateOrLater(T expected) {
        CurrentState<T> current = this.state;
        if (!current.hasSeenStateIgnoringTransitions(expected)) {
            throw new IllegalStateException(this.displayName.getCapitalizedDisplayName() + " should be in state " + expected + " or later.");
        }
    }

    public <S> S notInStateIgnoreOtherThreads(T forbidden, Supplier<S> supplier) {
        CurrentState<T> current = this.state;
        current.asResult().rethrow();
        current.assertNotInState(forbidden);
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            this.synchronizer.withLock(() -> {
                this.state = this.state.failed(ExecutionResult.failed(t));
            });
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
    }

    public void inState(T expected, Runnable action) {
        this.inState(expected, () -> {
            action.run();
            return null;
        });
    }

    public <S> S inState(T expected, Supplier<S> action) {
        return (S)this.synchronizer.withLock(() -> {
            CurrentState<State> current = this.state;
            current.assertInState((State)expected);
            try {
                return action.get();
            }
            catch (Throwable t) {
                this.state = current.failed(ExecutionResult.failed(t));
                throw this.state.rethrow();
            }
        });
    }

    public <S> S notInState(T forbidden, Supplier<S> action) {
        return (S)this.synchronizer.withLock(() -> {
            CurrentState<State> current = this.state;
            current.assertNotInState((State)forbidden);
            try {
                return action.get();
            }
            catch (Throwable t) {
                this.state = current.failed(ExecutionResult.failed(t));
                throw this.state.rethrow();
            }
        });
    }

    public void restart(T fromState, T toState, Runnable action) {
        this.synchronizer.withLock(() -> {
            CurrentState<State> current = this.state;
            current.assertCanTransition((State)fromState, (State)toState, true);
            action.run();
            this.state = new InState<State>(this.displayName, (State)toState, null);
        });
    }

    public void transition(T fromState, T toState, Runnable action) {
        this.synchronizer.withLock(() -> this.doTransition(fromState, toState, action));
    }

    public <S> S transition(T fromState, T toState, Supplier<? extends S> action) {
        return (S)this.synchronizer.withLock(() -> this.doTransition(fromState, toState, () -> StateTransitionController.lambda$transition$6((Supplier)action)).getValueOrRethrow());
    }

    public ExecutionResult<Void> tryTransition(T fromState, T toState, Supplier<ExecutionResult<Void>> action) {
        return (ExecutionResult)this.synchronizer.withLock(() -> this.doTransition(fromState, toState, action));
    }

    public void maybeTransition(T fromState, T toState, Runnable action) {
        this.synchronizer.withLock(() -> {
            if (this.state.inStateAndNotTransitioning((State)toState)) {
                return;
            }
            this.doTransition(fromState, toState, action);
        });
    }

    public void maybeTransitionIfNotCurrentlyTransitioning(T fromState, T toState, Runnable action) {
        this.synchronizer.withLock(() -> {
            if (this.state.inStateOrTransitioningTo((State)toState)) {
                return;
            }
            this.doTransition(fromState, toState, action);
        });
    }

    public void transitionIfNotPreviously(T fromState, T toState, Runnable action) {
        this.synchronizer.withLock(() -> {
            if (this.state.hasSeenStateAndNotTransitioning((State)toState)) {
                return;
            }
            this.doTransition(fromState, toState, action);
        });
    }

    public ExecutionResult<Void> transition(T fromState, T toState, Function<ExecutionResult<Void>, ExecutionResult<Void>> action) {
        return (ExecutionResult)this.synchronizer.withLock(() -> {
            CurrentState<State> current = this.state;
            current.assertCanTransition((State)fromState, (State)toState, true);
            return this.doTransitionWithFailures(toState, action, current);
        });
    }

    public ExecutionResult<Void> transition(List<T> fromStates, T toState, Function<ExecutionResult<Void>, ExecutionResult<Void>> action) {
        return (ExecutionResult)this.synchronizer.withLock(() -> {
            CurrentState<State> current = this.state;
            current.assertCanTransition((List<State>)fromStates, (State)toState, true);
            return this.doTransitionWithFailures(toState, action, current);
        });
    }

    private ExecutionResult<Void> doTransitionWithFailures(T toState, Function<ExecutionResult<Void>, ExecutionResult<Void>> action, CurrentState<T> current) {
        ExecutionResult<Void> result;
        ExecutionResult<Void> currentResult = current.asResult();
        this.state = current.transitioningTo(toState);
        try {
            result = action.apply(currentResult);
        }
        catch (Throwable t) {
            result = ExecutionResult.failed(t);
        }
        this.state = !result.getFailures().isEmpty() ? this.state.failed(result) : this.state.nextState(toState);
        return result;
    }

    private void doTransition(T fromState, T toState, Runnable action) {
        this.doTransition(fromState, toState, () -> {
            action.run();
            return ExecutionResult.succeeded();
        }).getValueOrRethrow();
    }

    private <S> ExecutionResult<S> doTransition(T fromState, T toState, Supplier<ExecutionResult<S>> action) {
        ExecutionResult<Object> result;
        CurrentState<T> current = this.state;
        current.assertCanTransition(fromState, toState);
        this.state = current.transitioningTo(toState);
        try {
            result = action.get();
        }
        catch (Throwable t) {
            result = ExecutionResult.failed(t);
        }
        this.state = !result.getFailures().isEmpty() ? this.state.failed(result) : this.state.nextState(toState);
        return result;
    }

    private static /* synthetic */ ExecutionResult lambda$transition$6(Supplier action) {
        return ExecutionResult.succeeded(action.get());
    }

    private static class InState<T>
    extends CurrentState<T> {
        private final DisplayName displayName;
        @Nullable
        private final InState<T> previous;

        public InState(DisplayName displayName, T state, @Nullable InState<T> previous) {
            super(displayName, state);
            this.displayName = displayName;
            this.previous = previous;
        }

        @Override
        public void assertInState(T expected) {
            if (this.state != expected) {
                throw new IllegalStateException("Expected " + this.displayName.getDisplayName() + " to be in state " + expected + " but is in state " + this.state + ".");
            }
        }

        @Override
        public void assertNotInState(T forbidden) {
            if (this.state == forbidden) {
                throw new IllegalStateException(this.displayName.getCapitalizedDisplayName() + " should not be in state " + forbidden + ".");
            }
        }

        @Override
        public void assertCanTransition(T fromState, T toState, boolean ignoreFailures) {
            if (this.state != fromState) {
                throw new IllegalStateException("Can only transition " + this.displayName.getCapitalizedDisplayName() + " to state " + toState + " from state " + fromState + " however it is currently in state " + this.state + ".");
            }
        }

        @Override
        public void assertCanTransition(List<T> fromStates, T toState, boolean ignoreFailures) {
            if (!fromStates.contains(this.state)) {
                throw new IllegalStateException("Can only transition " + this.displayName.getCapitalizedDisplayName() + " to state " + toState + " from states " + fromStates + " however it is currently in state " + this.state + ".");
            }
        }

        @Override
        public boolean inStateAndNotTransitioning(T toState) {
            return this.state == toState;
        }

        @Override
        public boolean inStateOrTransitioningTo(T toState) {
            return this.inStateAndNotTransitioning(toState);
        }

        @Override
        public boolean hasSeenStateAndNotTransitioning(T toState) {
            if (this.state == toState) {
                return true;
            }
            if (this.previous != null) {
                return this.previous.hasSeenStateAndNotTransitioning(toState);
            }
            return false;
        }

        @Override
        public boolean hasSeenStateIgnoringTransitions(T toState) {
            return this.hasSeenStateAndNotTransitioning(toState);
        }

        @Override
        public CurrentState<T> nextState(T toState) {
            return new InState<T>(this.displayName, toState, this);
        }
    }

    private static abstract class CurrentState<T> {
        final DisplayName displayName;
        final T state;

        public CurrentState(DisplayName displayName, T state) {
            this.displayName = displayName;
            this.state = state;
        }

        public abstract void assertInState(T var1);

        public abstract void assertNotInState(T var1);

        public void assertCanTransition(T fromState, T toState) {
            this.assertCanTransition(fromState, toState, false);
        }

        public abstract void assertCanTransition(T var1, T var2, boolean var3);

        public abstract void assertCanTransition(List<T> var1, T var2, boolean var3);

        public abstract boolean inStateAndNotTransitioning(T var1);

        public abstract boolean inStateOrTransitioningTo(T var1);

        public abstract boolean hasSeenStateAndNotTransitioning(T var1);

        public abstract boolean hasSeenStateIgnoringTransitions(T var1);

        public CurrentState<T> failed(ExecutionResult<?> failure) {
            return new Failed<T>(this.displayName, this.state, failure);
        }

        public RuntimeException rethrow() {
            throw new IllegalStateException();
        }

        public ExecutionResult<Void> asResult() {
            return ExecutionResult.succeeded();
        }

        public CurrentState<T> transitioningTo(T toState) {
            return new TransitioningToNewState<T>(toState, this);
        }

        public abstract CurrentState<T> nextState(T var1);
    }

    public static interface State {
    }

    private static class Failed<T>
    extends CurrentState<T> {
        final ExecutionResult<?> failure;

        public Failed(DisplayName displayName, T state, ExecutionResult<?> failure) {
            super(displayName, state);
            this.failure = failure;
        }

        public void throwFailure() {
            this.failure.rethrow();
        }

        @Override
        public void assertInState(T expected) {
            this.throwFailure();
        }

        @Override
        public void assertNotInState(T forbidden) {
            this.throwFailure();
        }

        @Override
        public void assertCanTransition(List<T> fromStates, T toState, boolean ignoreFailures) {
            if (!ignoreFailures) {
                this.throwFailure();
            }
        }

        @Override
        public void assertCanTransition(T fromState, T toState, boolean ignoreFailures) {
            if (!ignoreFailures) {
                this.throwFailure();
            }
        }

        @Override
        public boolean hasSeenStateAndNotTransitioning(T toState) {
            this.throwFailure();
            return false;
        }

        @Override
        public ExecutionResult<Void> asResult() {
            return this.failure.asFailure();
        }

        @Override
        public boolean inStateAndNotTransitioning(T toState) {
            this.throwFailure();
            return false;
        }

        @Override
        public boolean inStateOrTransitioningTo(T toState) {
            this.throwFailure();
            return false;
        }

        @Override
        public boolean hasSeenStateIgnoringTransitions(T toState) {
            this.throwFailure();
            return false;
        }

        @Override
        public RuntimeException rethrow() {
            this.failure.rethrow();
            throw new IllegalStateException();
        }

        @Override
        public CurrentState<T> failed(ExecutionResult<?> failure) {
            return new Failed<Object>(this.displayName, this.state, this.failure.withFailures(failure.asFailure()));
        }

        @Override
        public CurrentState<T> nextState(T toState) {
            return new Failed<T>(this.displayName, toState, this.failure);
        }
    }

    private static class TransitioningToNewState<T>
    extends CurrentState<T> {
        final T targetState;
        final CurrentState<T> fromState;

        public TransitioningToNewState(T targetState, CurrentState<T> fromState) {
            super(fromState.displayName, fromState.state);
            this.targetState = targetState;
            this.fromState = fromState;
        }

        @Override
        public boolean inStateAndNotTransitioning(T toState) {
            throw new IllegalStateException("Expected " + this.displayName.getDisplayName() + " to be in state " + toState + " but is in state " + this.state + " and transitioning to " + this.targetState + ".");
        }

        @Override
        public boolean inStateOrTransitioningTo(T toState) {
            if (this.targetState == toState) {
                return true;
            }
            throw new IllegalStateException("Expected " + this.displayName.getDisplayName() + " to be in state " + toState + " but is in state " + this.state + " and transitioning to " + this.targetState + ".");
        }

        @Override
        public void assertInState(T expected) {
            throw new IllegalStateException("Expected " + this.displayName.getDisplayName() + " to be in state " + expected + " but is in state " + this.state + " and transitioning to " + this.targetState + ".");
        }

        @Override
        public void assertNotInState(T forbidden) {
            throw new IllegalStateException(this.displayName.getCapitalizedDisplayName() + " should not be in state " + forbidden + " but is in state " + this.state + " and transitioning to " + this.targetState + ".");
        }

        @Override
        public void assertCanTransition(T fromState, T toState, boolean ignoreFailures) {
            this.failDueToTransition(toState);
        }

        @Override
        public void assertCanTransition(List<T> fromStates, T toState, boolean ignoreFailures) {
            this.failDueToTransition(toState);
        }

        private void failDueToTransition(T toState) {
            if (this.targetState == toState) {
                throw new IllegalStateException("Cannot transition " + this.displayName.getDisplayName() + " to state " + toState + " as already transitioning to this state.");
            }
            throw new IllegalStateException("Cannot transition " + this.displayName.getDisplayName() + " to state " + toState + " as already transitioning to state " + this.targetState + ".");
        }

        @Override
        public boolean hasSeenStateAndNotTransitioning(T toState) {
            throw new IllegalStateException("Expected " + this.displayName.getDisplayName() + " to be in state " + toState + " or later but is in state " + this.state + " and transitioning to " + this.targetState + ".");
        }

        @Override
        public boolean hasSeenStateIgnoringTransitions(T toState) {
            return this.fromState.hasSeenStateIgnoringTransitions(toState);
        }

        @Override
        public CurrentState<T> nextState(T toState) {
            return this.fromState.nextState(toState);
        }
    }
}

