/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state.heap.tree;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;

public class JvmTreeHeapFollowerAbstractState<StateT extends LatticeAbstractState<StateT>>
extends JvmTreeHeapAbstractState<StateT> {
    private JvmReferenceAbstractState principal;
    private final StateT defaultValue;

    public JvmTreeHeapFollowerAbstractState(JvmReferenceAbstractState principal, StateT defaultValue) {
        this(principal, defaultValue, new MapAbstractState<Reference, HeapNode<StateT>>());
    }

    private JvmTreeHeapFollowerAbstractState(JvmReferenceAbstractState principal, StateT defaultValue, MapAbstractState<Reference, HeapNode<StateT>> referenceToNode) {
        super(referenceToNode);
        this.principal = principal;
        this.defaultValue = defaultValue;
    }

    @Override
    public StateT getField(StateT object, String descriptor, StateT defaultValue) {
        return (StateT)this.getField((StateT)(object instanceof SetAbstractState ? (SetAbstractState<Reference>)object : this.getReferenceAbstractState()), descriptor, defaultValue);
    }

    @Override
    public void setField(StateT object, String descriptor, StateT value) {
        this.setField((StateT)this.getReferenceAbstractState(), descriptor, value);
    }

    @Override
    public StateT getArrayElementOrDefault(StateT array, StateT index, StateT defaultValue) {
        return (StateT)this.getArrayElementOrDefault((StateT)this.getReferenceAbstractState(), index, defaultValue);
    }

    @Override
    public void setArrayElement(StateT array, StateT index, StateT value) {
        this.setArrayElement((StateT)this.getReferenceAbstractState(), index, value);
    }

    @Override
    public StateT newObject(String className, JvmCfaNode creationCite) {
        return this.defaultValue;
    }

    @Override
    public StateT newArray(String type, List<StateT> dimensions, JvmCfaNode creationCite) {
        return this.defaultValue;
    }

    @Override
    public JvmTreeHeapFollowerAbstractState<StateT> join(JvmHeapAbstractState<StateT> abstractState) {
        JvmTreeHeapFollowerAbstractState other = (JvmTreeHeapFollowerAbstractState)abstractState;
        MapAbstractState<Reference, HeapNode<StateT>> newReferenceToNode = this.referenceToNode.join(other.referenceToNode);
        if (this.referenceToNode.equals(newReferenceToNode)) {
            return this;
        }
        if (other.referenceToNode.equals(newReferenceToNode)) {
            return other;
        }
        return new JvmTreeHeapFollowerAbstractState<StateT>(this.principal, this.defaultValue, newReferenceToNode);
    }

    @Override
    public boolean isLessOrEqual(JvmHeapAbstractState<StateT> abstractState) {
        return abstractState instanceof JvmTreeHeapFollowerAbstractState;
    }

    @Override
    public JvmTreeHeapFollowerAbstractState<StateT> copy() {
        return new JvmTreeHeapFollowerAbstractState<StateT>(this.principal, this.defaultValue, this.referenceToNode.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((HeapNode)e.getValue()).copy(), HeapNode::join, MapAbstractState::new)));
    }

    public void setPrincipalState(JvmReferenceAbstractState principal) {
        this.principal = principal;
    }

    private SetAbstractState<Reference> getReferenceAbstractState() {
        return new JvmStackLocation(((JvmInstructionCfaEdge)this.principal.getProgramLocation().getLeavingEdges().stream().findFirst().get()).getInstruction().stackPopCount(this.principal.getProgramLocation().getClazz()) - 1).extractValueOrDefault(this.principal, SetAbstractState.bottom);
    }
}

