---
title: Best Known Configuration
---

## Introduction

Component `<tag>`s are used both by OEMs and by customers to identify a *known-working* (or
commercially supported) set of firmware on the machine.

This allows two things:

* Factory recovery where a system in the field has been upgraded
* Ensuring a consistent set of vendor-tested firmware for a specific workload

The tags are either assigned in the firmware cabinet archive (the `.metainfo.xml` file) or added
post-upload on the LVFS and are then included in the public AppStream metadata.
A single firmware can be marked with multiple tags, and tags can be duplicated for different
firmwares.
This would allow an OEM to say *this set of firmware has been tested as a set for workload A,
and this other set of firmware has been tested for workload B* which is fairly typical for
enterprise deployments.

## LVFS

The LVFS added support for “vendor-defined” component `<tag>`s in 2021, which are also supported in
fwupd since version 1.7.3.
These tags are typically used by OEMs to identify a manifest of firmware for a specific machine SKU.
This is opt-in for each vendor, and so if you are a vendor reading this and want to use this feature,
let us know by [opening an issue](https://gitlab.com/fwupd/lvfs-website/-/issues).

## Client

When provisioning the client machine, we can set the BKC by setting `HostBkc=vendor-2021q1` in
`/etc/fwupd/fwupd.conf`.

Any invocation of `fwupdmgr sync` will install or downgrade firmware on all compatible devices
(e.g. UEFI, RAID, network adapter, & SAS HBA) to make the system match a compatible set.
The `fwupdmgr sync` command will also ensure that firmware is installed that matches the device
branch, if the device has one assigned.

Updating or downgrading firmware away from the *Best Known Configuration* or to different branches
is allowed, but the UI shows a warning.
Using `fwupdmgr sync` will undo any manual changes and bring the machine back to the BKC.

## Local metadata

To define a locally defined BKC, extra metadata is read from the `/usr/share/fwupd/local.d` and
`/var/lib/fwupd/local.d` directories. For instance:

For example:

    <?xml version='1.0' encoding='utf-8'?>
    <components origin="mycompanyname">
      <component merge="append">
        <provides>
          <firmware>3ef35d3b-ceeb-5e27-8c0a-ac25f90367ab</firmware>
          <firmware>2ef35d3b-ceeb-5e27-8c0a-ac25f90367ac</firmware>
          <firmware>1ef35d3b-ceeb-5e27-8c0a-ac25f90367ad</firmware>
        </provides>
        <releases>
          <release version="225.53.1649"/>
          <release version="224.48.1605"/>
        </releases>
        <tags>
          <tag>mycompanyname-2022q1</tag>
        </tags>
      </component>
    </components>

This then appears when getting the releases for that specific GUID:

    fwupdmgr get-releases --json 3ef35d3b-ceeb-5e27-8c0a-ac25f90367ab
    {
      "Releases" : [
        {
          ...
          "Version" : "225.53.1649",
          "Tags" : [
            "mycompanyname-2022q1"
          ],
          ...
        },
        {
          ...
          "Version" : "224.48.1605",
          "Tags" : [
            "mycompanyname-2022q1"
          ],
          ...
        },
        {
          ...
          "Version" : "224.45.1389",
          ...
        }
      ]
    }

..and can be synced on the command line:

    $ fwupdmgr sync
    ╔══════════════════════════════════════════════════════════════════════════════╗
    ║ Downgrade System Firmware from 225.52.1521 to 225.53.1649?                   ║
    ╠══════════════════════════════════════════════════════════════════════════════╣
    ║ This release sets the number of HBAs supported by the system to 1024.        ║
    ╚══════════════════════════════════════════════════════════════════════════════╝
    Perform operation? [Y|n]:

## Vendor Firmware Remotes

Tags can also be included in the `metainfo.xml` files included in `.cab` archives installed into
`/usr/share/fwupd/remotes.d/vendor/firmware/` -- although in most cases it makes sense to actually
*decouple* the tag assignment from the firmware binary by specifying local metadata.

If the tag is specific to the firmware build, then it can be included directly in the metadata:

    <?xml version="1.0" encoding="UTF-8"?>
    <component type="firmware">
      <id>org.fwupd.myproduct.firmware</id>
      ...
      <tags>
        <tag namespace="lvfs">product-mycompanyname-2022q1</tag>
      </tags>
    </component>

**NOTE:** the `namespace="lvfs"` is required for fwupd as the `<tag>` section is also used by other
software for different purposes. Forgetting the namespace will cause fwupd to ignore the tag!
