<h1 align="center">AtomicGo | cursor</h1>

<p align="center">
<img src="https://img.shields.io/endpoint?url=https%3A%2F%2Fatomicgo.dev%2Fapi%2Fshields%2Fcursor&style=flat-square" alt="Downloads">

<a href="https://github.com/atomicgo/cursor/releases">
<img src="https://img.shields.io/github/v/release/atomicgo/cursor?style=flat-square" alt="Latest Release">
</a>

<a href="https://codecov.io/gh/atomicgo/cursor" target="_blank">
<img src="https://img.shields.io/github/actions/workflow/status/atomicgo/cursor/go.yml?style=flat-square" alt="Tests">
</a>

<a href="https://codecov.io/gh/atomicgo/cursor" target="_blank">
<img src="https://img.shields.io/codecov/c/gh/atomicgo/cursor?color=magenta&logo=codecov&style=flat-square" alt="Coverage">
</a>

<a href="https://codecov.io/gh/atomicgo/cursor">
<!-- unittestcount:start --><img src="https://img.shields.io/badge/Unit_Tests-2-magenta?style=flat-square" alt="Unit test count"><!-- unittestcount:end -->
</a>

<a href="https://opensource.org/licenses/MIT" target="_blank">
<img src="https://img.shields.io/badge/License-MIT-yellow.svg?style=flat-square" alt="License: MIT">
</a>
  
<a href="https://goreportcard.com/report/github.com/atomicgo/cursor" target="_blank">
<img src="https://goreportcard.com/badge/github.com/atomicgo/cursor?style=flat-square" alt="Go report">
</a>   

</p>

---

<p align="center">
<strong><a href="https://pkg.go.dev/atomicgo.dev/cursor#section-documentation" target="_blank">Documentation</a></strong>
|
<strong><a href="https://github.com/atomicgo/atomicgo/blob/main/CONTRIBUTING.md" target="_blank">Contributing</a></strong>
|
<strong><a href="https://github.com/atomicgo/atomicgo/blob/main/CODE_OF_CONDUCT.md" target="_blank">Code of Conduct</a></strong>
</p>

---

<p align="center">
  <img src="https://raw.githubusercontent.com/atomicgo/atomicgo/main/assets/header.png" alt="AtomicGo">
</p>

<p align="center">
<table>
<tbody>
</tbody>
</table>
</p>
<h3  align="center"><pre>go get atomicgo.dev/cursor</pre></h3>
<p align="center">
<table>
<tbody>
</tbody>
</table>
</p>

<!-- gomarkdoc:embed:start -->

<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# cursor

```go
import "atomicgo.dev/cursor"
```

Package cursor contains cross\-platform methods to move the terminal cursor in different directions. This package can be used to create interactive CLI tools and games, live charts, algorithm visualizations and other updatable output of any kind.

Works niceley with https://github.com/atomicgo/keyboard

Special thanks to github.com/k0kubun/go\-ansi which this project is based on.

## Index

- [func Bottom\(\)](<#Bottom>)
- [func Clear\(\)](<#Clear>)
- [func ClearLine\(\)](<#ClearLine>)
- [func ClearLinesDown\(n int\)](<#ClearLinesDown>)
- [func ClearLinesUp\(n int\)](<#ClearLinesUp>)
- [func Down\(n int\)](<#Down>)
- [func DownAndClear\(n int\)](<#DownAndClear>)
- [func Hide\(\)](<#Hide>)
- [func HorizontalAbsolute\(n int\)](<#HorizontalAbsolute>)
- [func Left\(n int\)](<#Left>)
- [func Move\(x, y int\)](<#Move>)
- [func Right\(n int\)](<#Right>)
- [func SetTarget\(w Writer\)](<#SetTarget>)
- [func Show\(\)](<#Show>)
- [func StartOfLine\(\)](<#StartOfLine>)
- [func StartOfLineDown\(n int\)](<#StartOfLineDown>)
- [func StartOfLineUp\(n int\)](<#StartOfLineUp>)
- [func TestCustomIOWriter\(t \*testing.T\)](<#TestCustomIOWriter>)
- [func Up\(n int\)](<#Up>)
- [func UpAndClear\(n int\)](<#UpAndClear>)
- [type Area](<#Area>)
  - [func NewArea\(\) Area](<#NewArea>)
  - [func \(area \*Area\) Bottom\(\)](<#Area.Bottom>)
  - [func \(area \*Area\) Clear\(\)](<#Area.Clear>)
  - [func \(area \*Area\) ClearLinesDown\(n int\)](<#Area.ClearLinesDown>)
  - [func \(area \*Area\) ClearLinesUp\(n int\)](<#Area.ClearLinesUp>)
  - [func \(area \*Area\) Down\(n int\)](<#Area.Down>)
  - [func \(area \*Area\) DownAndClear\(n int\)](<#Area.DownAndClear>)
  - [func \(area \*Area\) Move\(x, y int\)](<#Area.Move>)
  - [func \(area \*Area\) StartOfLine\(\)](<#Area.StartOfLine>)
  - [func \(area \*Area\) StartOfLineDown\(n int\)](<#Area.StartOfLineDown>)
  - [func \(area \*Area\) StartOfLineUp\(n int\)](<#Area.StartOfLineUp>)
  - [func \(area \*Area\) Top\(\)](<#Area.Top>)
  - [func \(area \*Area\) Up\(n int\)](<#Area.Up>)
  - [func \(area \*Area\) UpAndClear\(n int\)](<#Area.UpAndClear>)
  - [func \(area \*Area\) Update\(content string\)](<#Area.Update>)
  - [func \(area Area\) WithWriter\(writer Writer\) Area](<#Area.WithWriter>)
- [type Cursor](<#Cursor>)
  - [func NewCursor\(\) \*Cursor](<#NewCursor>)
  - [func \(c \*Cursor\) Clear\(\)](<#Cursor.Clear>)
  - [func \(c \*Cursor\) ClearLine\(\)](<#Cursor.ClearLine>)
  - [func \(c \*Cursor\) Down\(n int\)](<#Cursor.Down>)
  - [func \(c \*Cursor\) Hide\(\)](<#Cursor.Hide>)
  - [func \(c \*Cursor\) HorizontalAbsolute\(n int\)](<#Cursor.HorizontalAbsolute>)
  - [func \(c \*Cursor\) Left\(n int\)](<#Cursor.Left>)
  - [func \(c \*Cursor\) Right\(n int\)](<#Cursor.Right>)
  - [func \(c \*Cursor\) Show\(\)](<#Cursor.Show>)
  - [func \(c \*Cursor\) Up\(n int\)](<#Cursor.Up>)
  - [func \(c \*Cursor\) WithWriter\(w Writer\) \*Cursor](<#Cursor.WithWriter>)
- [type Writer](<#Writer>)


<a name="Bottom"></a>
## func [Bottom](<https://github.com/atomicgo/cursor/blob/main/utils.go#L84>)

```go
func Bottom()
```

Bottom moves the cursor to the bottom of the terminal. This is done by calculating how many lines were moved by Up and Down.

<a name="Clear"></a>
## func [Clear](<https://github.com/atomicgo/cursor/blob/main/utils.go#L78>)

```go
func Clear()
```

Clear clears the current position and moves the cursor to the left.

<a name="ClearLine"></a>
## func [ClearLine](<https://github.com/atomicgo/cursor/blob/main/utils.go#L73>)

```go
func ClearLine()
```

ClearLine clears the current line and moves the cursor to it's start position.

<a name="ClearLinesDown"></a>
## func [ClearLinesDown](<https://github.com/atomicgo/cursor/blob/main/utils.go#L147>)

```go
func ClearLinesDown(n int)
```

ClearLinesDown clears n lines downwards from the current position and moves the cursor.

<a name="ClearLinesUp"></a>
## func [ClearLinesUp](<https://github.com/atomicgo/cursor/blob/main/utils.go#L140>)

```go
func ClearLinesUp(n int)
```

ClearLinesUp clears n lines upwards from the current position and moves the cursor.

<a name="Down"></a>
## func [Down](<https://github.com/atomicgo/cursor/blob/main/utils.go#L34>)

```go
func Down(n int)
```

Down moves the cursor n lines down relative to the current position.

<a name="DownAndClear"></a>
## func [DownAndClear](<https://github.com/atomicgo/cursor/blob/main/utils.go#L117>)

```go
func DownAndClear(n int)
```

DownAndClear moves the cursor down by n lines, then clears the line.

<a name="Hide"></a>
## func [Hide](<https://github.com/atomicgo/cursor/blob/main/utils.go#L68>)

```go
func Hide()
```

Hide the cursor. Don't forget to show the cursor at least at the end of your application with Show. Otherwise the user might have a terminal with a permanently hidden cursor, until they reopen the terminal.

<a name="HorizontalAbsolute"></a>
## func [HorizontalAbsolute](<https://github.com/atomicgo/cursor/blob/main/utils.go#L54>)

```go
func HorizontalAbsolute(n int)
```

HorizontalAbsolute moves the cursor to n horizontally. The position n is absolute to the start of the line.

<a name="Left"></a>
## func [Left](<https://github.com/atomicgo/cursor/blob/main/utils.go#L48>)

```go
func Left(n int)
```

Left moves the cursor n characters to the left relative to the current position.

<a name="Move"></a>
## func [Move](<https://github.com/atomicgo/cursor/blob/main/utils.go#L123>)

```go
func Move(x, y int)
```

Move moves the cursor relative by x and y.

<a name="Right"></a>
## func [Right](<https://github.com/atomicgo/cursor/blob/main/utils.go#L43>)

```go
func Right(n int)
```

Right moves the cursor n characters to the right relative to the current position.

<a name="SetTarget"></a>
## func [SetTarget](<https://github.com/atomicgo/cursor/blob/main/utils.go#L23>)

```go
func SetTarget(w Writer)
```

SetTarget sets to output target of the default curser to the provided cursor.Writer \(wrapping io.Writer\).

<a name="Show"></a>
## func [Show](<https://github.com/atomicgo/cursor/blob/main/utils.go#L61>)

```go
func Show()
```

Show the cursor if it was hidden previously. Don't forget to show the cursor at least at the end of your application. Otherwise the user might have a terminal with a permanently hidden cursor, until they reopen the terminal.

<a name="StartOfLine"></a>
## func [StartOfLine](<https://github.com/atomicgo/cursor/blob/main/utils.go#L94>)

```go
func StartOfLine()
```

StartOfLine moves the cursor to the start of the current line.

<a name="StartOfLineDown"></a>
## func [StartOfLineDown](<https://github.com/atomicgo/cursor/blob/main/utils.go#L99>)

```go
func StartOfLineDown(n int)
```

StartOfLineDown moves the cursor down by n lines, then moves to cursor to the start of the line.

<a name="StartOfLineUp"></a>
## func [StartOfLineUp](<https://github.com/atomicgo/cursor/blob/main/utils.go#L105>)

```go
func StartOfLineUp(n int)
```

StartOfLineUp moves the cursor up by n lines, then moves to cursor to the start of the line.

<a name="TestCustomIOWriter"></a>
## func [TestCustomIOWriter](<https://github.com/atomicgo/cursor/blob/main/cursor_test_linux.go#L10>)

```go
func TestCustomIOWriter(t *testing.T)
```

TestCustomIOWriter tests the cursor functions with a custom Writer.

<a name="Up"></a>
## func [Up](<https://github.com/atomicgo/cursor/blob/main/utils.go#L28>)

```go
func Up(n int)
```

Up moves the cursor n lines up relative to the current position.

<a name="UpAndClear"></a>
## func [UpAndClear](<https://github.com/atomicgo/cursor/blob/main/utils.go#L111>)

```go
func UpAndClear(n int)
```

UpAndClear moves the cursor up by n lines, then clears the line.

<a name="Area"></a>
## type [Area](<https://github.com/atomicgo/cursor/blob/main/area.go#L10-L15>)

Area displays content which can be updated on the fly. You can use this to create live output, charts, dropdowns, etc.

```go
type Area struct {
    // contains filtered or unexported fields
}
```

<a name="NewArea"></a>
### func [NewArea](<https://github.com/atomicgo/cursor/blob/main/area.go#L18>)

```go
func NewArea() Area
```

NewArea returns a new Area.

<a name="Area.Bottom"></a>
### func \(\*Area\) [Bottom](<https://github.com/atomicgo/cursor/blob/main/area.go#L86>)

```go
func (area *Area) Bottom()
```

Bottom moves the cursor to the bottom of the terminal. This is done by calculating how many lines were moved by Up and Down.

<a name="Area.Clear"></a>
### func \(\*Area\) [Clear](<https://github.com/atomicgo/cursor/blob/main/area.go#L36>)

```go
func (area *Area) Clear()
```

Clear clears the content of the Area.

<a name="Area.ClearLinesDown"></a>
### func \(\*Area\) [ClearLinesDown](<https://github.com/atomicgo/cursor/blob/main/area.go#L157>)

```go
func (area *Area) ClearLinesDown(n int)
```

ClearLinesDown clears n lines downwards from the current position and moves the cursor.

<a name="Area.ClearLinesUp"></a>
### func \(\*Area\) [ClearLinesUp](<https://github.com/atomicgo/cursor/blob/main/area.go#L147>)

```go
func (area *Area) ClearLinesUp(n int)
```

ClearLinesUp clears n lines upwards from the current position and moves the cursor.

<a name="Area.Down"></a>
### func \(\*Area\) [Down](<https://github.com/atomicgo/cursor/blob/main/area.go#L73>)

```go
func (area *Area) Down(n int)
```

Down moves the cursor of the area down one line.

<a name="Area.DownAndClear"></a>
### func \(\*Area\) [DownAndClear](<https://github.com/atomicgo/cursor/blob/main/area.go#L126>)

```go
func (area *Area) DownAndClear(n int)
```

DownAndClear moves the cursor down by n lines, then clears the line.

<a name="Area.Move"></a>
### func \(\*Area\) [Move](<https://github.com/atomicgo/cursor/blob/main/area.go#L132>)

```go
func (area *Area) Move(x, y int)
```

Move moves the cursor relative by x and y.

<a name="Area.StartOfLine"></a>
### func \(\*Area\) [StartOfLine](<https://github.com/atomicgo/cursor/blob/main/area.go#L103>)

```go
func (area *Area) StartOfLine()
```

StartOfLine moves the cursor to the start of the current line.

<a name="Area.StartOfLineDown"></a>
### func \(\*Area\) [StartOfLineDown](<https://github.com/atomicgo/cursor/blob/main/area.go#L108>)

```go
func (area *Area) StartOfLineDown(n int)
```

StartOfLineDown moves the cursor down by n lines, then moves to cursor to the start of the line.

<a name="Area.StartOfLineUp"></a>
### func \(\*Area\) [StartOfLineUp](<https://github.com/atomicgo/cursor/blob/main/area.go#L114>)

```go
func (area *Area) StartOfLineUp(n int)
```

StartOfLineUp moves the cursor up by n lines, then moves to cursor to the start of the line.

<a name="Area.Top"></a>
### func \(\*Area\) [Top](<https://github.com/atomicgo/cursor/blob/main/area.go#L95>)

```go
func (area *Area) Top()
```

Top moves the cursor to the top of the area. This is done by calculating how many lines were moved by Up and Down.

<a name="Area.Up"></a>
### func \(\*Area\) [Up](<https://github.com/atomicgo/cursor/blob/main/area.go#L61>)

```go
func (area *Area) Up(n int)
```

Up moves the cursor of the area up one line.

<a name="Area.UpAndClear"></a>
### func \(\*Area\) [UpAndClear](<https://github.com/atomicgo/cursor/blob/main/area.go#L120>)

```go
func (area *Area) UpAndClear(n int)
```

UpAndClear moves the cursor up by n lines, then clears the line.

<a name="Area.Update"></a>
### func \(\*Area\) [Update](<https://github.com/atomicgo/cursor/blob/main/area.go#L53>)

```go
func (area *Area) Update(content string)
```

Update overwrites the content of the Area and adjusts its height based on content.

<a name="Area.WithWriter"></a>
### func \(Area\) [WithWriter](<https://github.com/atomicgo/cursor/blob/main/area.go#L28>)

```go
func (area Area) WithWriter(writer Writer) Area
```

WithWriter sets the custom writer.

<a name="Cursor"></a>
## type [Cursor](<https://github.com/atomicgo/cursor/blob/main/cursor.go#L9-L11>)

Cursor displays content which can be updated on the fly. You can use this to create live output, charts, dropdowns, etc.

```go
type Cursor struct {
    // contains filtered or unexported fields
}
```

<a name="NewCursor"></a>
### func [NewCursor](<https://github.com/atomicgo/cursor/blob/main/cursor.go#L14>)

```go
func NewCursor() *Cursor
```

NewCursor creates a new Cursor instance writing to os.Stdout.

<a name="Cursor.Clear"></a>
### func \(\*Cursor\) [Clear](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L65>)

```go
func (c *Cursor) Clear()
```

Clear clears the current position and moves the cursor to the left.

<a name="Cursor.ClearLine"></a>
### func \(\*Cursor\) [ClearLine](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L60>)

```go
func (c *Cursor) ClearLine()
```

ClearLine clears the current line and moves the cursor to it's start position.

<a name="Cursor.Down"></a>
### func \(\*Cursor\) [Down](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L18>)

```go
func (c *Cursor) Down(n int)
```

Down moves the cursor n lines down relative to the current position.

<a name="Cursor.Hide"></a>
### func \(\*Cursor\) [Hide](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L55>)

```go
func (c *Cursor) Hide()
```

Hide the cursor. Don't forget to show the cursor at least at the end of your application with Show. Otherwise the user might have a terminal with a permanently hidden cursor, until they reopen the terminal.

<a name="Cursor.HorizontalAbsolute"></a>
### func \(\*Cursor\) [HorizontalAbsolute](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L40>)

```go
func (c *Cursor) HorizontalAbsolute(n int)
```

HorizontalAbsolute moves the cursor to n horizontally. The position n is absolute to the start of the line.

<a name="Cursor.Left"></a>
### func \(\*Cursor\) [Left](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L32>)

```go
func (c *Cursor) Left(n int)
```

Left moves the cursor n characters to the left relative to the current position.

<a name="Cursor.Right"></a>
### func \(\*Cursor\) [Right](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L25>)

```go
func (c *Cursor) Right(n int)
```

Right moves the cursor n characters to the right relative to the current position.

<a name="Cursor.Show"></a>
### func \(\*Cursor\) [Show](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L48>)

```go
func (c *Cursor) Show()
```

Show the cursor if it was hidden previously. Don't forget to show the cursor at least at the end of your application. Otherwise the user might have a terminal with a permanently hidden cursor, until they reopen the terminal.

<a name="Cursor.Up"></a>
### func \(\*Cursor\) [Up](<https://github.com/atomicgo/cursor/blob/main/cursor_other.go#L11>)

```go
func (c *Cursor) Up(n int)
```

Up moves the cursor n lines up relative to the current position.

<a name="Cursor.WithWriter"></a>
### func \(\*Cursor\) [WithWriter](<https://github.com/atomicgo/cursor/blob/main/cursor.go#L20>)

```go
func (c *Cursor) WithWriter(w Writer) *Cursor
```

WithWriter allows for any arbitrary Writer to be used for cursor movement abstracted.

<a name="Writer"></a>
## type [Writer](<https://github.com/atomicgo/cursor/blob/main/utils.go#L16-L19>)

Writer is an expanded io.Writer interface with a file descriptor.

```go
type Writer interface {
    io.Writer
    Fd() uintptr
}
```

Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)


<!-- gomarkdoc:embed:end -->

---

> [AtomicGo.dev](https://atomicgo.dev) &nbsp;&middot;&nbsp;
> with ❤️ by [@MarvinJWendt](https://github.com/MarvinJWendt) |
> [MarvinJWendt.com](https://marvinjwendt.com)
