// Code generated by 'go generate'; DO NOT EDIT.

package automation

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modoleaut32 = windows.NewLazySystemDLL("oleaut32.dll")

	procSysAllocString    = modoleaut32.NewProc("SysAllocString")
	procSysAllocStringLen = modoleaut32.NewProc("SysAllocStringLen")
	procSysFreeString     = modoleaut32.NewProc("SysFreeString")
	procSysStringLen      = modoleaut32.NewProc("SysStringLen")
)

func sysAllocString(str *uint16) (ret BSTR) {
	r0, _, _ := syscall.Syscall(procSysAllocString.Addr(), 1, uintptr(unsafe.Pointer(str)), 0, 0)
	ret = BSTR(r0)
	return
}

func sysAllocStringLen(str *uint16, strLen uint32) (ret BSTR) {
	r0, _, _ := syscall.Syscall(procSysAllocStringLen.Addr(), 2, uintptr(unsafe.Pointer(str)), uintptr(strLen), 0)
	ret = BSTR(r0)
	return
}

func sysFreeString(bstr BSTR) {
	syscall.Syscall(procSysFreeString.Addr(), 1, uintptr(bstr), 0, 0)
	return
}

func sysStringLen(bstr BSTR) (ret uint32) {
	r0, _, _ := syscall.Syscall(procSysStringLen.Addr(), 1, uintptr(bstr), 0, 0)
	ret = uint32(r0)
	return
}
