/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.collect.$BiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableBiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableMultimap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$LinkedListMultimap;
import autovalue.shaded.com.google$.common.collect.$Multimap;
import autovalue.shaded.com.google$.common.collect.$Sets;
import com.google.auto.value.processor.AutoValueProcessor;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.EclipseHack;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.Optionalish;
import com.google.auto.value.processor.PropertyBuilderClassifier;
import com.google.auto.value.processor.PropertyNames;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import com.google.auto.value.processor.TypeVariables;
import java.util.AbstractCollection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class BuilderMethodClassifier {
    private static final $Equivalence<TypeMirror> TYPE_EQUIVALENCE = $MoreTypes.equivalence();
    private final ErrorReporter errorReporter;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeElement autoValueClass;
    private final TypeElement builderType;
    private final $ImmutableBiMap<ExecutableElement, String> getterToPropertyName;
    private final $ImmutableMap<ExecutableElement, TypeMirror> getterToPropertyType;
    private final $ImmutableMap<String, ExecutableElement> getterNameToGetter;
    private final Set<ExecutableElement> buildMethods = new LinkedHashSet<ExecutableElement>();
    private final Map<String, BuilderSpec.PropertyGetter> builderGetters = new LinkedHashMap<String, BuilderSpec.PropertyGetter>();
    private final Map<String, PropertyBuilderClassifier.PropertyBuilder> propertyNameToPropertyBuilder = new LinkedHashMap<String, PropertyBuilderClassifier.PropertyBuilder>();
    private final $Multimap<String, ExecutableElement> propertyNameToPrefixedSetters = $LinkedListMultimap.create();
    private final $Multimap<String, ExecutableElement> propertyNameToUnprefixedSetters = $LinkedListMultimap.create();
    private final EclipseHack eclipseHack;
    private boolean settersPrefixed;

    private BuilderMethodClassifier(ErrorReporter errorReporter, ProcessingEnvironment processingEnv, TypeElement autoValueClass, TypeElement builderType, $ImmutableBiMap<ExecutableElement, String> getterToPropertyName, $ImmutableMap<ExecutableElement, TypeMirror> getterToPropertyType) {
        this.errorReporter = errorReporter;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.autoValueClass = autoValueClass;
        this.builderType = builderType;
        this.getterToPropertyName = getterToPropertyName;
        this.getterToPropertyType = getterToPropertyType;
        $ImmutableMap.Builder<String, ExecutableElement> getterToPropertyNameBuilder = $ImmutableMap.builder();
        for (ExecutableElement getter : getterToPropertyName.keySet()) {
            getterToPropertyNameBuilder.put(getter.getSimpleName().toString(), getter);
        }
        this.getterNameToGetter = getterToPropertyNameBuilder.build();
        this.eclipseHack = new EclipseHack(processingEnv);
    }

    static Optional<BuilderMethodClassifier> classify(Iterable<ExecutableElement> methods, ErrorReporter errorReporter, ProcessingEnvironment processingEnv, TypeElement autoValueClass, TypeElement builderType, $ImmutableBiMap<ExecutableElement, String> getterToPropertyName, $ImmutableMap<ExecutableElement, TypeMirror> getterToPropertyType, boolean autoValueHasToBuilder) {
        BuilderMethodClassifier classifier = new BuilderMethodClassifier(errorReporter, processingEnv, autoValueClass, builderType, getterToPropertyName, getterToPropertyType);
        if (classifier.classifyMethods(methods, autoValueHasToBuilder)) {
            return Optional.of(classifier);
        }
        return Optional.empty();
    }

    $ImmutableMultimap<String, ExecutableElement> propertyNameToSetters() {
        return $ImmutableMultimap.copyOf(this.settersPrefixed ? this.propertyNameToPrefixedSetters : this.propertyNameToUnprefixedSetters);
    }

    Map<String, PropertyBuilderClassifier.PropertyBuilder> propertyNameToPropertyBuilder() {
        return this.propertyNameToPropertyBuilder;
    }

    $ImmutableMap<String, BuilderSpec.PropertyGetter> builderGetters() {
        return $ImmutableMap.copyOf(this.builderGetters);
    }

    Set<ExecutableElement> buildMethods() {
        return $ImmutableSet.copyOf(this.buildMethods);
    }

    private boolean classifyMethods(Iterable<ExecutableElement> methods, boolean autoValueHasToBuilder) {
        $Multimap<String, ExecutableElement> propertyNameToSetter;
        int startErrorCount = this.errorReporter.errorCount();
        for (ExecutableElement method : methods) {
            this.classifyMethod(method);
        }
        if (this.errorReporter.errorCount() > startErrorCount) {
            return false;
        }
        if (this.propertyNameToPrefixedSetters.isEmpty()) {
            propertyNameToSetter = this.propertyNameToUnprefixedSetters;
            this.settersPrefixed = false;
        } else if (this.propertyNameToUnprefixedSetters.isEmpty()) {
            propertyNameToSetter = this.propertyNameToPrefixedSetters;
            this.settersPrefixed = true;
        } else {
            this.errorReporter.reportError("If any setter methods use the setFoo convention then all must", this.propertyNameToUnprefixedSetters.values().iterator().next());
            return false;
        }
        this.getterToPropertyName.forEach((getter, property) -> {
            boolean hasBuilder;
            TypeMirror propertyType = this.getterToPropertyType.get(getter);
            boolean hasSetter = propertyNameToSetter.containsKey(property);
            PropertyBuilderClassifier.PropertyBuilder propertyBuilder = this.propertyNameToPropertyBuilder.get(property);
            boolean bl = hasBuilder = propertyBuilder != null;
            if (hasBuilder) {
                boolean needToMakeBarBuilder;
                boolean canMakeBarBuilder = propertyBuilder.getBuiltToBuilder() != null || propertyBuilder.getCopyAll() != null;
                boolean bl2 = needToMakeBarBuilder = autoValueHasToBuilder || hasSetter;
                if (needToMakeBarBuilder && !canMakeBarBuilder) {
                    String error = String.format("Property builder method returns %1$s but there is no way to make that type from %2$s: %2$s does not have a non-static toBuilder() method that returns %1$s", propertyBuilder.getBuilderTypeMirror(), propertyType);
                    this.errorReporter.reportError(error, propertyBuilder.getPropertyBuilderMethod());
                }
            } else if (!hasSetter) {
                String setterName = this.settersPrefixed ? BuilderMethodClassifier.prefixWithSet(property) : property;
                String error = String.format("Expected a method with this signature: %s%s %s(%s), or a %sBuilder() method", this.builderType, this.typeParamsString(), setterName, propertyType, property);
                this.errorReporter.reportError(error, this.builderType);
            }
        });
        return this.errorReporter.errorCount() == startErrorCount;
    }

    private void classifyMethod(ExecutableElement method) {
        switch (method.getParameters().size()) {
            case 0: {
                this.classifyMethodNoArgs(method);
                break;
            }
            case 1: {
                this.classifyMethodOneArg(method);
                break;
            }
            default: {
                this.errorReporter.reportError("Builder methods must have 0 or 1 parameters", method);
            }
        }
    }

    private boolean classifyMethodNoArgs(ExecutableElement method) {
        String property;
        String methodName = method.getSimpleName().toString();
        TypeMirror returnType = this.builderMethodReturnType(method);
        ExecutableElement getter = this.getterNameToGetter.get(methodName);
        if (getter != null) {
            return this.classifyGetter(method, getter);
        }
        if (methodName.endsWith("Builder") && this.getterToPropertyName.containsValue(property = methodName.substring(0, methodName.length() - "Builder".length()))) {
            PropertyBuilderClassifier propertyBuilderClassifier = new PropertyBuilderClassifier(this.errorReporter, this.typeUtils, this.elementUtils, this, this.getterToPropertyName, this.eclipseHack);
            Optional<PropertyBuilderClassifier.PropertyBuilder> propertyBuilder = propertyBuilderClassifier.makePropertyBuilder(method, property);
            if (propertyBuilder.isPresent()) {
                this.propertyNameToPropertyBuilder.put(property, propertyBuilder.get());
                return true;
            }
            return false;
        }
        if (TYPE_EQUIVALENCE.equivalent(returnType, this.autoValueClass.asType())) {
            this.buildMethods.add(method);
            return true;
        }
        String error = String.format("Method without arguments should be a build method returning %1$s%2$s or a getter method with the same name and type as a getter method of %1$s", this.autoValueClass, this.typeParamsString());
        this.errorReporter.reportError(error, method);
        return false;
    }

    private boolean classifyGetter(ExecutableElement builderGetter, ExecutableElement originalGetter) {
        String propertyName = (String)this.getterToPropertyName.get(originalGetter);
        TypeMirror originalGetterType = this.getterToPropertyType.get(originalGetter);
        TypeMirror builderGetterType = this.builderMethodReturnType(builderGetter);
        String builderGetterTypeString = TypeEncoder.encodeWithAnnotations(builderGetterType);
        if (TYPE_EQUIVALENCE.equivalent(builderGetterType, originalGetterType)) {
            this.builderGetters.put(propertyName, new BuilderSpec.PropertyGetter(builderGetter, builderGetterTypeString, null));
            return true;
        }
        Optionalish optional = Optionalish.createIfOptional(builderGetterType);
        if (optional != null) {
            TypeMirror boxedOriginalType;
            TypeMirror containedType = optional.getContainedType(this.typeUtils);
            TypeMirror typeMirror = boxedOriginalType = originalGetterType.getKind().isPrimitive() ? this.typeUtils.boxedClass($MoreTypes.asPrimitiveType(originalGetterType)).asType() : null;
            if (TYPE_EQUIVALENCE.equivalent(containedType, originalGetterType) || TYPE_EQUIVALENCE.equivalent(containedType, boxedOriginalType)) {
                this.builderGetters.put(propertyName, new BuilderSpec.PropertyGetter(builderGetter, builderGetterTypeString, optional));
                return true;
            }
        }
        String error = String.format("Method matches a property of %1$s but has return type %2$s instead of %3$s or an Optional wrapping of %3$s", this.autoValueClass, builderGetterType, originalGetterType);
        this.errorReporter.reportError(error, builderGetter);
        return false;
    }

    private boolean classifyMethodOneArg(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        $BiMap propertyNameToGetter = this.getterToPropertyName.inverse();
        String propertyName = null;
        ExecutableElement valueGetter = (ExecutableElement)propertyNameToGetter.get(methodName);
        $Multimap<String, ExecutableElement> propertyNameToSetters = null;
        if (valueGetter != null) {
            propertyNameToSetters = this.propertyNameToUnprefixedSetters;
            propertyName = methodName;
        } else if (valueGetter == null && methodName.startsWith("set") && methodName.length() > 3) {
            propertyNameToSetters = this.propertyNameToPrefixedSetters;
            propertyName = PropertyNames.decapitalizeLikeJavaBeans(methodName.substring(3));
            valueGetter = (ExecutableElement)propertyNameToGetter.get(propertyName);
            if (valueGetter == null) {
                propertyName = PropertyNames.decapitalizeNormally(methodName.substring(3));
                valueGetter = (ExecutableElement)propertyNameToGetter.get(propertyName);
            }
        }
        if (valueGetter == null || propertyNameToSetters == null) {
            this.errorReporter.reportError("Method does not correspond to a property of " + this.autoValueClass, method);
            this.checkForFailedJavaBean(method);
            return false;
        }
        if (!this.checkSetterParameter(valueGetter, method)) {
            return false;
        }
        if (!TYPE_EQUIVALENCE.equivalent(this.builderMethodReturnType(method), this.builderType.asType())) {
            this.errorReporter.reportError("Setter methods must return " + this.builderType + this.typeParamsString(), method);
            return false;
        }
        propertyNameToSetters.put(propertyName, method);
        return true;
    }

    private void checkForFailedJavaBean(ExecutableElement rejectedSetter) {
        Set allGetters = this.getterToPropertyName.keySet();
        $ImmutableSet<ExecutableElement> prefixedGetters = AutoValueProcessor.prefixedGettersIn(allGetters);
        if (prefixedGetters.size() < ((AbstractCollection)((Object)allGetters)).size() && prefixedGetters.size() >= ((AbstractCollection)((Object)allGetters)).size() / 2) {
            String note = "This might be because you are using the getFoo() convention for some but not all methods. These methods don't follow the convention: " + $Sets.difference(allGetters, prefixedGetters);
            this.errorReporter.reportNote(note, rejectedSetter);
        }
    }

    private boolean checkSetterParameter(ExecutableElement valueGetter, ExecutableElement setter) {
        TypeMirror targetType = this.getterToPropertyType.get(valueGetter);
        ExecutableType finalSetter = $MoreTypes.asExecutable(this.typeUtils.asMemberOf($MoreTypes.asDeclared(this.builderType.asType()), setter));
        TypeMirror parameterType = finalSetter.getParameterTypes().get(0);
        if (this.typeUtils.isSameType(parameterType, targetType)) {
            return true;
        }
        $ImmutableList<ExecutableElement> copyOfMethods = this.copyOfMethods(targetType);
        if (!copyOfMethods.isEmpty()) {
            return this.canMakeCopyUsing(copyOfMethods, valueGetter, setter);
        }
        String error = String.format("Parameter type %s of setter method should be %s to match getter %s.%s", parameterType, targetType, this.autoValueClass, valueGetter.getSimpleName());
        this.errorReporter.reportError(error, setter);
        return false;
    }

    private boolean canMakeCopyUsing($ImmutableList<ExecutableElement> copyOfMethods, ExecutableElement valueGetter, ExecutableElement setter) {
        DeclaredType targetType = $MoreTypes.asDeclared(this.getterToPropertyType.get(valueGetter));
        TypeMirror parameterType = setter.getParameters().get(0).asType();
        for (ExecutableElement copyOfMethod : copyOfMethods) {
            if (!this.canMakeCopyUsing(copyOfMethod, targetType, parameterType)) continue;
            return true;
        }
        String targetTypeSimpleName = targetType.asElement().getSimpleName().toString();
        String error = String.format("Parameter type of setter method should be %s to match getter %s.%s, or it should be a type that can be passed to %s.%s to produce %s", targetType, this.autoValueClass, valueGetter.getSimpleName(), targetTypeSimpleName, ((ExecutableElement)copyOfMethods.get(0)).getSimpleName(), targetType);
        this.errorReporter.reportError(error, setter);
        return false;
    }

    private boolean canMakeCopyUsing(ExecutableElement copyOfMethod, DeclaredType targetType, TypeMirror parameterType) {
        return TypeVariables.canAssignStaticMethodResult(copyOfMethod, parameterType, targetType, this.typeUtils);
    }

    private $ImmutableList<ExecutableElement> copyOfMethods(TypeMirror targetType) {
        if (!targetType.getKind().equals((Object)TypeKind.DECLARED)) {
            return $ImmutableList.of();
        }
        String copyOf = Optionalish.isOptional(targetType) ? "of" : "copyOf";
        TypeElement targetTypeElement = $MoreElements.asType(this.typeUtils.asElement(targetType));
        $ImmutableList.Builder copyOfMethods = $ImmutableList.builder();
        for (ExecutableElement method : ElementFilter.methodsIn(targetTypeElement.getEnclosedElements())) {
            if (!method.getSimpleName().contentEquals(copyOf) || method.getParameters().size() != 1 || !method.getModifiers().contains((Object)Modifier.STATIC)) continue;
            copyOfMethods.add(method);
        }
        return copyOfMethods.build();
    }

    TypeMirror builderMethodReturnType(ExecutableElement builderMethod) {
        TypeMirror methodMirror;
        DeclaredType builderTypeMirror = $MoreTypes.asDeclared(this.builderType.asType());
        try {
            methodMirror = this.typeUtils.asMemberOf(builderTypeMirror, builderMethod);
        }
        catch (IllegalArgumentException e) {
            return builderMethod.getReturnType();
        }
        return $MoreTypes.asExecutable(methodMirror).getReturnType();
    }

    private static String prefixWithSet(String propertyName) {
        return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private String typeParamsString() {
        return TypeSimplifier.actualTypeParametersString(this.autoValueClass);
    }
}

