  $ ocamlc_where="$(ocamlc -where)"
  $ export BUILD_PATH_PREFIX_MAP="/OCAMLC_WHERE=$ocamlc_where:$BUILD_PATH_PREFIX_MAP"
  $ ocamlfind_libs="$(ocamlfind printconf path | while read line; do printf lib=${line}:; done)"
  $ export BUILD_PATH_PREFIX_MAP="$ocamlfind_libs:$BUILD_PATH_PREFIX_MAP"

We're going create a fake findlib library for use:

  $ mkdir -p _findlib/publicfoo
  $ cat >_findlib/publicfoo/META <<EOF
  > EOF
  $ export OCAMLPATH="$PWD/_findlib:$OCAMLPATH"

CRAM sanitization
  $ dune build ./exe/.merlin-conf/exe-x --profile release
  $ dune ocaml merlin dump-config $PWD/exe
  X: _build/default/exe/x
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_findlib/publicfoo)
   (B $TESTCASE_ROOT/_build/default/exe/.x.eobjs/byte)
   (B $TESTCASE_ROOT/_build/default/lib/.foo.objs/public_cmi)
   (S $TESTCASE_ROOT/_findlib/publicfoo)
   (S $TESTCASE_ROOT/exe)
   (S $TESTCASE_ROOT/lib)
   (FLG (-w -40 -g))
   (FLG (-pp $TESTCASE_ROOT/_build/default/pp/pp.exe))
   (UNIT_NAME x))
  X: _build/default/exe/x.ml
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_findlib/publicfoo)
   (B $TESTCASE_ROOT/_build/default/exe/.x.eobjs/byte)
   (B $TESTCASE_ROOT/_build/default/lib/.foo.objs/public_cmi)
   (S $TESTCASE_ROOT/_findlib/publicfoo)
   (S $TESTCASE_ROOT/exe)
   (S $TESTCASE_ROOT/lib)
   (FLG (-w -40 -g))
   (FLG (-pp $TESTCASE_ROOT/_build/default/pp/pp.exe))
   (UNIT_NAME x))

  $ dune build ./lib/.merlin-conf/lib-foo ./lib/.merlin-conf/lib-bar --profile release
  $ dune ocaml merlin dump-config $PWD/lib
  Bar: _build/default/lib/bar
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/lib/.bar.objs/byte)
   (S $TESTCASE_ROOT/lib)
   (S $TESTCASE_ROOT/lib/subdir)
   (FLG (-w -40 -g))
   (FLG (-ppx "$TESTCASE_ROOT/_build/default/.ppx/4128e43a9cfb141a37f547484cc9bf46/ppx.exe --as-ppx --cookie 'library-name="bar"'"))
   (UNIT_NAME bar))
  Bar: _build/default/lib/bar.ml-gen
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/lib/.bar.objs/byte)
   (S $TESTCASE_ROOT/lib)
   (S $TESTCASE_ROOT/lib/subdir)
   (FLG (-w -40 -g))
   (FLG (-ppx "$TESTCASE_ROOT/_build/default/.ppx/4128e43a9cfb141a37f547484cc9bf46/ppx.exe --as-ppx --cookie 'library-name="bar"'"))
   (UNIT_NAME bar))
  File: _build/default/lib/subdir/file
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/lib/.bar.objs/byte)
   (S $TESTCASE_ROOT/lib)
   (S $TESTCASE_ROOT/lib/subdir)
   (FLG (-w -40 -g))
   (FLG (-ppx "$TESTCASE_ROOT/_build/default/.ppx/4128e43a9cfb141a37f547484cc9bf46/ppx.exe --as-ppx --cookie 'library-name="bar"'"))
   (FLG (-open Bar))
   (UNIT_NAME bar__File))
  File: _build/default/lib/subdir/file.ml
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/lib/.bar.objs/byte)
   (S $TESTCASE_ROOT/lib)
   (S $TESTCASE_ROOT/lib/subdir)
   (FLG (-w -40 -g))
   (FLG (-ppx "$TESTCASE_ROOT/_build/default/.ppx/4128e43a9cfb141a37f547484cc9bf46/ppx.exe --as-ppx --cookie 'library-name="bar"'"))
   (FLG (-open Bar))
   (UNIT_NAME bar__File))
  Foo: _build/default/lib/foo
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_findlib/publicfoo)
   (B $TESTCASE_ROOT/_build/default/lib/.foo.objs/byte)
   (S $TESTCASE_ROOT/_findlib/publicfoo)
   (S $TESTCASE_ROOT/lib)
   (S $TESTCASE_ROOT/lib/subdir)
   (FLG (-w -40 -g))
   (FLG (-ppx "$TESTCASE_ROOT/_build/default/.ppx/4128e43a9cfb141a37f547484cc9bf46/ppx.exe --as-ppx --cookie 'library-name="foo"'"))
   (UNIT_NAME foo))
  Foo: _build/default/lib/foo.ml-gen
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_findlib/publicfoo)
   (B $TESTCASE_ROOT/_build/default/lib/.foo.objs/byte)
   (S $TESTCASE_ROOT/_findlib/publicfoo)
   (S $TESTCASE_ROOT/lib)
   (S $TESTCASE_ROOT/lib/subdir)
   (FLG (-w -40 -g))
   (FLG (-ppx "$TESTCASE_ROOT/_build/default/.ppx/4128e43a9cfb141a37f547484cc9bf46/ppx.exe --as-ppx --cookie 'library-name="foo"'"))
   (UNIT_NAME foo))
  Privmod: _build/default/lib/privmod
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_findlib/publicfoo)
   (B $TESTCASE_ROOT/_build/default/lib/.foo.objs/byte)
   (S $TESTCASE_ROOT/_findlib/publicfoo)
   (S $TESTCASE_ROOT/lib)
   (S $TESTCASE_ROOT/lib/subdir)
   (FLG (-w -40 -g))
   (FLG (-ppx "$TESTCASE_ROOT/_build/default/.ppx/4128e43a9cfb141a37f547484cc9bf46/ppx.exe --as-ppx --cookie 'library-name="foo"'"))
   (FLG (-open Foo))
   (UNIT_NAME foo__Privmod))
  Privmod: _build/default/lib/privmod.ml
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_findlib/publicfoo)
   (B $TESTCASE_ROOT/_build/default/lib/.foo.objs/byte)
   (S $TESTCASE_ROOT/_findlib/publicfoo)
   (S $TESTCASE_ROOT/lib)
   (S $TESTCASE_ROOT/lib/subdir)
   (FLG (-w -40 -g))
   (FLG (-ppx "$TESTCASE_ROOT/_build/default/.ppx/4128e43a9cfb141a37f547484cc9bf46/ppx.exe --as-ppx --cookie 'library-name="foo"'"))
   (FLG (-open Foo))
   (UNIT_NAME foo__Privmod))

Make sure a ppx directive is generated (if not, the [grep ppx] step fails)
  $ dune ocaml merlin dump-config $PWD/lib | grep ppx > /dev/null

Make sure pp flag is correct and variables are expanded

  $ dune build ./pp-with-expand/.merlin-conf/exe-foobar --profile release
  $ dune ocaml merlin dump-config $PWD/pp-with-expand
  Foobar: _build/default/pp-with-expand/foobar
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/byte)
   (S $TESTCASE_ROOT/pp-with-expand)
   (FLG (-w -40 -g))
   (FLG (-pp "$TESTCASE_ROOT/_build/default/pp/pp.exe -nothing"))
   (UNIT_NAME foobar))
  Foobar: _build/default/pp-with-expand/foobar.ml
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/byte)
   (S $TESTCASE_ROOT/pp-with-expand)
   (FLG (-w -40 -g))
   (FLG (-pp "$TESTCASE_ROOT/_build/default/pp/pp.exe -nothing"))
   (UNIT_NAME foobar))

Check hash of executables names if more than one
  $ dune build ./exes/.merlin-conf/exe-x-6562915302827c6dce0630390bfa68b7
  $ dune ocaml merlin dump-config $PWD/exes
  X: _build/default/exes/x
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/exes/.x.eobjs/byte)
   (S $TESTCASE_ROOT/exes)
   (FLG (-w @1..3@5..28@30..39@43@46..47@49..57@61..62-40 -strict-sequence -strict-formats -short-paths -keep-locs -g))
   (UNIT_NAME x))
  X: _build/default/exes/x.ml
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/exes/.x.eobjs/byte)
   (S $TESTCASE_ROOT/exes)
   (FLG (-w @1..3@5..28@30..39@43@46..47@49..57@61..62-40 -strict-sequence -strict-formats -short-paths -keep-locs -g))
   (UNIT_NAME x))
  Y: _build/default/exes/y
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/exes/.x.eobjs/byte)
   (S $TESTCASE_ROOT/exes)
   (FLG (-w @1..3@5..28@30..39@43@46..47@49..57@61..62-40 -strict-sequence -strict-formats -short-paths -keep-locs -g))
   (UNIT_NAME y))
  Y: _build/default/exes/y.ml
  ((INDEX $TESTCASE_ROOT/_build/default/exe/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/exes/.x.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.bar.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/lib/.foo.objs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp/.pp.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/pp-with-expand/.foobar.eobjs/cctx.ocaml-index)
   (INDEX $TESTCASE_ROOT/_build/default/ppx/.fooppx.objs/cctx.ocaml-index)
   (STDLIB /OCAMLC_WHERE)
   (SOURCE_ROOT $TESTCASE_ROOT)
   (EXCLUDE_QUERY_DIR)
   (B $TESTCASE_ROOT/_build/default/exes/.x.eobjs/byte)
   (S $TESTCASE_ROOT/exes)
   (FLG (-w @1..3@5..28@30..39@43@46..47@49..57@61..62-40 -strict-sequence -strict-formats -short-paths -keep-locs -g))
   (UNIT_NAME y))
