Example of illegal code:

```ada
package Q is
   X : Integer;
end Q;

package P is
   procedure Init;
end P;

with Q;
package body P is
   procedure Init is
   begin
      Q.X := 0;
   end Init;
begin
   Init; -- error: write to Q.X during elaboration of P
end P;
```

This error is issued on direct writes of variables, or indirect writes of
variables through procedure calls, during the elaboration of a package (the
evaluation of the declarations and body of the package), when the variable
written is declared outside of the package. Such a write violates legality rule
6 of [section 7.7.1 of SPARK Reference Manual].

The elaboration code of a package should only write to the variables of the
package, so that the `Initializes` and `Initial_Condition` contracts on the
package represent the state of the package at the end of elaboration, and the
behavior does not depend on the order of elaboration of packages chosen by the
compiler.

The fix is to delegate to each package the initialization of its variables, as
follows:

```ada
package Q is
   X : Integer := 0;
end Q;
```

[section 7.7.1 of SPARK Reference Manual]:
https://docs.adacore.com/live/wave/spark2014/html/spark2014_rm/packages.html#use-of-initial-condition-and-initializes-aspects
