/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.rundeck.client.api.model.ProjectNode;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.NodeFilterOptions;
import org.rundeck.client.tool.options.NodeOutputFormatOption;
import org.rundeck.client.tool.options.ProjectNameOptions;
import org.rundeck.client.util.Format;
import picocli.CommandLine;

@CommandLine.Command(description={"List node resources."}, name="nodes")
public class Nodes
extends BaseCommand {
    @CommandLine.Command(description={"List all nodes for a project.  You can use the -F/--filter to specify a node filter, or simply add the filter on the end of the command"})
    public void list(@CommandLine.Mixin ProjectNameOptions options, @CommandLine.Mixin NodeOutputFormatOption nodeOutputFormatOption, @CommandLine.Mixin NodeFilterOptions nodeFilterOptions) throws IOException, InputError {
        String project = this.getRdTool().projectOrEnv(options);
        Map body = (Map)this.apiCall(api -> api.listNodes(project, nodeFilterOptions.filterString()));
        if (!nodeOutputFormatOption.isOutputFormat()) {
            this.getRdOutput().info(String.format("%d Nodes%s in project %s:%n", body.size(), nodeFilterOptions.isFilter() ? " matching filter" : "", project));
        }
        Function<ProjectNode, Object> field = nodeOutputFormatOption.isOutputFormat() ? Format.formatter(nodeOutputFormatOption.getOutputFormat(), ProjectNode::getAttributes, "%", "") : (nodeOutputFormatOption.isVerbose() ? ProjectNode::getAttributes : ProjectNode::getName);
        this.getRdOutput().output(body.values().stream().map(field).collect(Collectors.toList()));
    }
}

