package security

import (
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
)

type MalwareEvidence struct {
    AlertEvidence
}
// NewMalwareEvidence instantiates a new MalwareEvidence and sets the default values.
func NewMalwareEvidence()(*MalwareEvidence) {
    m := &MalwareEvidence{
        AlertEvidence: *NewAlertEvidence(),
    }
    odataTypeValue := "#microsoft.graph.security.malwareEvidence"
    m.SetOdataType(&odataTypeValue)
    return m
}
// CreateMalwareEvidenceFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
// returns a Parsable when successful
func CreateMalwareEvidenceFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewMalwareEvidence(), nil
}
// GetCategory gets the category property value. The category property
// returns a *string when successful
func (m *MalwareEvidence) GetCategory()(*string) {
    val, err := m.GetBackingStore().Get("category")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
// returns a map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error) when successful
func (m *MalwareEvidence) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.AlertEvidence.GetFieldDeserializers()
    res["category"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCategory(val)
        }
        return nil
    }
    res["files"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateFileEvidenceFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]FileEvidenceable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(FileEvidenceable)
                }
            }
            m.SetFiles(res)
        }
        return nil
    }
    res["name"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetName(val)
        }
        return nil
    }
    res["processes"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateProcessEvidenceFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]ProcessEvidenceable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(ProcessEvidenceable)
                }
            }
            m.SetProcesses(res)
        }
        return nil
    }
    return res
}
// GetFiles gets the files property value. The files property
// returns a []FileEvidenceable when successful
func (m *MalwareEvidence) GetFiles()([]FileEvidenceable) {
    val, err := m.GetBackingStore().Get("files")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]FileEvidenceable)
    }
    return nil
}
// GetName gets the name property value. The name property
// returns a *string when successful
func (m *MalwareEvidence) GetName()(*string) {
    val, err := m.GetBackingStore().Get("name")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetProcesses gets the processes property value. The processes property
// returns a []ProcessEvidenceable when successful
func (m *MalwareEvidence) GetProcesses()([]ProcessEvidenceable) {
    val, err := m.GetBackingStore().Get("processes")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]ProcessEvidenceable)
    }
    return nil
}
// Serialize serializes information the current object
func (m *MalwareEvidence) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.AlertEvidence.Serialize(writer)
    if err != nil {
        return err
    }
    {
        err = writer.WriteStringValue("category", m.GetCategory())
        if err != nil {
            return err
        }
    }
    if m.GetFiles() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetFiles()))
        for i, v := range m.GetFiles() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("files", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("name", m.GetName())
        if err != nil {
            return err
        }
    }
    if m.GetProcesses() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetProcesses()))
        for i, v := range m.GetProcesses() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("processes", cast)
        if err != nil {
            return err
        }
    }
    return nil
}
// SetCategory sets the category property value. The category property
func (m *MalwareEvidence) SetCategory(value *string)() {
    err := m.GetBackingStore().Set("category", value)
    if err != nil {
        panic(err)
    }
}
// SetFiles sets the files property value. The files property
func (m *MalwareEvidence) SetFiles(value []FileEvidenceable)() {
    err := m.GetBackingStore().Set("files", value)
    if err != nil {
        panic(err)
    }
}
// SetName sets the name property value. The name property
func (m *MalwareEvidence) SetName(value *string)() {
    err := m.GetBackingStore().Set("name", value)
    if err != nil {
        panic(err)
    }
}
// SetProcesses sets the processes property value. The processes property
func (m *MalwareEvidence) SetProcesses(value []ProcessEvidenceable)() {
    err := m.GetBackingStore().Set("processes", value)
    if err != nil {
        panic(err)
    }
}
type MalwareEvidenceable interface {
    AlertEvidenceable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetCategory()(*string)
    GetFiles()([]FileEvidenceable)
    GetName()(*string)
    GetProcesses()([]ProcessEvidenceable)
    SetCategory(value *string)()
    SetFiles(value []FileEvidenceable)()
    SetName(value *string)()
    SetProcesses(value []ProcessEvidenceable)()
}
