// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeletePathsFilterParams creates a new DeletePathsFilterParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeletePathsFilterParams() *DeletePathsFilterParams {
	return &DeletePathsFilterParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeletePathsFilterParamsWithTimeout creates a new DeletePathsFilterParams object
// with the ability to set a timeout on a request.
func NewDeletePathsFilterParamsWithTimeout(timeout time.Duration) *DeletePathsFilterParams {
	return &DeletePathsFilterParams{
		timeout: timeout,
	}
}

// NewDeletePathsFilterParamsWithContext creates a new DeletePathsFilterParams object
// with the ability to set a context for a request.
func NewDeletePathsFilterParamsWithContext(ctx context.Context) *DeletePathsFilterParams {
	return &DeletePathsFilterParams{
		Context: ctx,
	}
}

// NewDeletePathsFilterParamsWithHTTPClient creates a new DeletePathsFilterParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeletePathsFilterParamsWithHTTPClient(client *http.Client) *DeletePathsFilterParams {
	return &DeletePathsFilterParams{
		HTTPClient: client,
	}
}

/*
DeletePathsFilterParams contains all the parameters to send to the API endpoint

	for the delete paths filter operation.

	Typically these are written to a http.Request.
*/
type DeletePathsFilterParams struct {

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete paths filter params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePathsFilterParams) WithDefaults() *DeletePathsFilterParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete paths filter params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePathsFilterParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete paths filter params
func (o *DeletePathsFilterParams) WithTimeout(timeout time.Duration) *DeletePathsFilterParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete paths filter params
func (o *DeletePathsFilterParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete paths filter params
func (o *DeletePathsFilterParams) WithContext(ctx context.Context) *DeletePathsFilterParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete paths filter params
func (o *DeletePathsFilterParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete paths filter params
func (o *DeletePathsFilterParams) WithHTTPClient(client *http.Client) *DeletePathsFilterParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete paths filter params
func (o *DeletePathsFilterParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the delete paths filter params
func (o *DeletePathsFilterParams) WithClusterID(clusterID string) *DeletePathsFilterParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the delete paths filter params
func (o *DeletePathsFilterParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the delete paths filter params
func (o *DeletePathsFilterParams) WithLocationOrganizationID(locationOrganizationID string) *DeletePathsFilterParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the delete paths filter params
func (o *DeletePathsFilterParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the delete paths filter params
func (o *DeletePathsFilterParams) WithLocationProjectID(locationProjectID string) *DeletePathsFilterParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the delete paths filter params
func (o *DeletePathsFilterParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the delete paths filter params
func (o *DeletePathsFilterParams) WithLocationRegionProvider(locationRegionProvider *string) *DeletePathsFilterParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the delete paths filter params
func (o *DeletePathsFilterParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the delete paths filter params
func (o *DeletePathsFilterParams) WithLocationRegionRegion(locationRegionRegion *string) *DeletePathsFilterParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the delete paths filter params
func (o *DeletePathsFilterParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *DeletePathsFilterParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
