// Code generated by go-swagger; DO NOT EDIT.

package iam_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// IamServicePingReader is a Reader for the IamServicePing structure.
type IamServicePingReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IamServicePingReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIamServicePingOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIamServicePingDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIamServicePingOK creates a IamServicePingOK with default headers values
func NewIamServicePingOK() *IamServicePingOK {
	return &IamServicePingOK{}
}

/*
IamServicePingOK describes a response with status code 200, with default header values.

A successful response.
*/
type IamServicePingOK struct {
	Payload models.HashicorpCloudIamPingResponse
}

// IsSuccess returns true when this iam service ping o k response has a 2xx status code
func (o *IamServicePingOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iam service ping o k response has a 3xx status code
func (o *IamServicePingOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iam service ping o k response has a 4xx status code
func (o *IamServicePingOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this iam service ping o k response has a 5xx status code
func (o *IamServicePingOK) IsServerError() bool {
	return false
}

// IsCode returns true when this iam service ping o k response a status code equal to that given
func (o *IamServicePingOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the iam service ping o k response
func (o *IamServicePingOK) Code() int {
	return 200
}

func (o *IamServicePingOK) Error() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/ping][%d] iamServicePingOK  %+v", 200, o.Payload)
}

func (o *IamServicePingOK) String() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/ping][%d] iamServicePingOK  %+v", 200, o.Payload)
}

func (o *IamServicePingOK) GetPayload() models.HashicorpCloudIamPingResponse {
	return o.Payload
}

func (o *IamServicePingOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIamServicePingDefault creates a IamServicePingDefault with default headers values
func NewIamServicePingDefault(code int) *IamServicePingDefault {
	return &IamServicePingDefault{
		_statusCode: code,
	}
}

/*
IamServicePingDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type IamServicePingDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this iam service ping default response has a 2xx status code
func (o *IamServicePingDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iam service ping default response has a 3xx status code
func (o *IamServicePingDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iam service ping default response has a 4xx status code
func (o *IamServicePingDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iam service ping default response has a 5xx status code
func (o *IamServicePingDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iam service ping default response a status code equal to that given
func (o *IamServicePingDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iam service ping default response
func (o *IamServicePingDefault) Code() int {
	return o._statusCode
}

func (o *IamServicePingDefault) Error() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/ping][%d] IamService_Ping default  %+v", o._statusCode, o.Payload)
}

func (o *IamServicePingDefault) String() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/ping][%d] IamService_Ping default  %+v", o._statusCode, o.Payload)
}

func (o *IamServicePingDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *IamServicePingDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
