// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p></p>
/// <p>A content block for selective guarding with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> API operations.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub enum GuardrailConverseContentBlock {
    /// <p>Image within converse content block to be evaluated by the guardrail.</p>
    Image(crate::types::GuardrailConverseImageBlock),
    /// <p>The text to guard.</p>
    Text(crate::types::GuardrailConverseTextBlock),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl GuardrailConverseContentBlock {
    /// Tries to convert the enum instance into [`Image`](crate::types::GuardrailConverseContentBlock::Image), extracting the inner [`GuardrailConverseImageBlock`](crate::types::GuardrailConverseImageBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_image(&self) -> ::std::result::Result<&crate::types::GuardrailConverseImageBlock, &Self> {
        if let GuardrailConverseContentBlock::Image(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Image`](crate::types::GuardrailConverseContentBlock::Image).
    pub fn is_image(&self) -> bool {
        self.as_image().is_ok()
    }
    /// Tries to convert the enum instance into [`Text`](crate::types::GuardrailConverseContentBlock::Text), extracting the inner [`GuardrailConverseTextBlock`](crate::types::GuardrailConverseTextBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_text(&self) -> ::std::result::Result<&crate::types::GuardrailConverseTextBlock, &Self> {
        if let GuardrailConverseContentBlock::Text(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Text`](crate::types::GuardrailConverseContentBlock::Text).
    pub fn is_text(&self) -> bool {
        self.as_text().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
impl ::std::fmt::Debug for GuardrailConverseContentBlock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GuardrailConverseContentBlock::Image(_) => f.debug_tuple("*** Sensitive Data Redacted ***").finish(),
            GuardrailConverseContentBlock::Text(val) => f.debug_tuple("Text").field(&val).finish(),
            GuardrailConverseContentBlock::Unknown => f.debug_tuple("Unknown").finish(),
        }
    }
}
