/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    long clientHandle;
    long labelHandle;
    String text = "";
    GdkRGBA foreground;

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    long clientHandle() {
        return this.clientHandle;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        Point size = super.computeSizeInPixels(wHint, hHint, changed);
        int width = this.computeNativeSize((long)this.handle, (int)-1, (int)-1, (boolean)false).x;
        size.x = Math.max(size.x, width);
        return size;
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        this.forceResize();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.clientHandle, allocation);
        int clientX = allocation.x;
        int clientY = allocation.y;
        return new Rectangle(x -= clientX, y -= clientY, width += clientX + clientX, height += clientX + clientY);
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle clientRectangle = super.getClientAreaInPixels();
        clientRectangle.x = 0;
        clientRectangle.y = 0;
        return clientRectangle;
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.display.COLOR_WIDGET_FOREGROUND_RGBA;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        return super.getContextBackgroundGdkRGBA();
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_surface_or_window(this.fixedHandle, true);
        this.handle = GTK.gtk_frame_new(null);
        if (this.handle == 0L) {
            this.error(2);
        }
        this.labelHandle = GTK.gtk_label_new(null);
        if (this.labelHandle == 0L) {
            this.error(2);
        }
        OS.g_object_ref_sink(this.labelHandle);
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.clientHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_surface_or_window(this.clientHandle, true);
        GTK.gtk_container_add(this.fixedHandle, this.handle);
        GTK.gtk_container_add(this.handle, this.clientHandle);
        if ((this.style & 4) != 0) {
            GTK.gtk_frame_set_shadow_type(this.handle, 1);
        }
        if ((this.style & 8) != 0) {
            GTK.gtk_frame_set_shadow_type(this.handle, 2);
        }
        if ((this.style & 0x10) != 0) {
            GTK.gtk_frame_set_shadow_type(this.handle, 3);
        }
        if ((this.style & 0x40) != 0) {
            GTK.gtk_frame_set_shadow_type(this.handle, 4);
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return 1;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.labelHandle);
    }

    @Override
    void enableWidget(boolean enabled) {
        GTK.gtk_widget_set_sensitive(this.labelHandle, enabled);
    }

    @Override
    long eventHandle() {
        return this.clientHandle;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0L) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            this.setFocus();
        }
        return result;
    }

    @Override
    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0L) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    @Override
    long parentingHandle() {
        return this.clientHandle;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.labelHandle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0L;
        this.clientHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.labelHandle != 0L) {
            OS.g_object_unref(this.labelHandle);
        }
        this.text = null;
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        this.setFontDescription(this.labelHandle, font);
    }

    @Override
    void setForegroundGdkRGBA(long handle, GdkRGBA rgba) {
        if (this.text != null && !this.text.isEmpty()) {
            super.setForegroundGdkRGBA(this.labelHandle, rgba);
        }
        this.foreground = rgba;
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        super.setForegroundGdkRGBA(rgba);
        this.setForegroundGdkRGBA(this.labelHandle, rgba);
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.labelHandle, dir);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            if (GTK.gtk_frame_get_label_widget(this.handle) == 0L) {
                GTK.gtk_frame_set_label_widget(this.handle, this.labelHandle);
            }
        } else {
            GTK.gtk_frame_set_label_widget(this.handle, 0L);
        }
        if (this.foreground != null) {
            this.setForegroundGdkRGBA(this.labelHandle, this.foreground);
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.clientHandle != 0L) {
            GTK.gtk_widget_show(this.clientHandle);
        }
        if (this.labelHandle != 0L) {
            GTK.gtk_widget_show(this.labelHandle);
        }
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        GtkRequisition requisition = new GtkRequisition();
        GTK.gtk_widget_get_preferred_size(this.handle, requisition, null);
        width = width - (requisition.width - width) < 0 ? requisition.width : width;
        height = height - (requisition.height - height) < 0 ? requisition.height : height;
        return super.setBounds(x, y, width, height, move, resize);
    }

    @Override
    long paintHandle() {
        if (GTK.GTK4) {
            return this.clientHandle;
        }
        long topHandle = this.topHandle();
        long paintHandle = this.clientHandle;
        while (paintHandle != topHandle && !this.gtk_widget_get_has_surface_or_window(paintHandle)) {
            paintHandle = GTK.gtk_widget_get_parent(paintHandle);
        }
        return paintHandle;
    }

    @Override
    long paintWindow() {
        long paintHandle = this.clientHandle;
        GTK.gtk_widget_realize(paintHandle);
        return this.gtk_widget_get_window(paintHandle);
    }

    @Override
    long paintSurface() {
        long paintHandle = this.clientHandle;
        GTK.gtk_widget_realize(paintHandle);
        return this.gtk_widget_get_surface(paintHandle);
    }
}

