/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.events.java;

import org.apiguardian.api.API;
import org.opentest4j.reporting.events.api.ChildElement;
import org.opentest4j.reporting.events.api.Context;
import org.opentest4j.reporting.events.core.Sources;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * The {@code packageSource} element of the Java namespace.
 *
 * @since 0.1.0
 */
@API(status = EXPERIMENTAL, since = "0.1.0")
public class PackageSource extends ChildElement<Sources, PackageSource> {

	private static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_JAVA, "packageSource");
	private static final QualifiedName NAME = QualifiedName.of(Namespace.REPORTING_JAVA, "name");

	PackageSource(Context context) {
		super(context, PackageSource.ELEMENT);
	}

	PackageSource withName(String className) {
		withAttribute(NAME, className);
		return this;
	}
}
