
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Using replaceChild on an Entity node attempt to replace its Text child with new Text,
 *  Comment, ProcessingInstruction and CDATASection nodes and in each case verify if 
 *  a NO_MODIFICATION_ALLOWED_ERR is raised.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-785887307">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-785887307</a>
*/
public final class nodereplacechild38 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodereplacechild38(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      DocumentType docType;
      NamedNodeMap entitiesMap;
      Entity ent;
      Text oldChild;
      EntityReference entRef;
      Text txt;
      Element elem;
      Comment comment;
      ProcessingInstruction pi;
      CDATASection cdata;
      Node replaced;
      doc = (Document) load("hc_staff", true);
      docType = doc.getDoctype();
      entitiesMap = docType.getEntities();
      ent = (Entity) entitiesMap.getNamedItem("alpha");
      assertNotNull("alphaEntity", ent);
      oldChild = (Text) ent.getFirstChild();
      assertNotNull("alphaText", oldChild);
      cdata = doc.createCDATASection("CDATASection");
      
      {
         boolean success = false;
         try {
            replaced = ent.replaceChild(cdata, oldChild);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
         }
         assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR1", success);
      }
pi = doc.createProcessingInstruction("target", "data");
      
      {
         boolean success = false;
         try {
            replaced = ent.replaceChild(pi, oldChild);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
         }
         assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR2", success);
      }
comment = doc.createComment("Comment");
      
      {
         boolean success = false;
         try {
            replaced = ent.replaceChild(comment, oldChild);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
         }
         assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR3", success);
      }
txt = doc.createTextNode("Text");
      
      {
         boolean success = false;
         try {
            replaced = ent.replaceChild(txt, oldChild);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
         }
         assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR4", success);
      }
elem = doc.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:p");
      
      {
         boolean success = false;
         try {
            replaced = ent.replaceChild(elem, oldChild);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
         }
         assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR5", success);
      }
entRef = doc.createEntityReference("delta");
      
      {
         boolean success = false;
         try {
            replaced = ent.replaceChild(entRef, oldChild);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
         }
         assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR6", success);
      }
}
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodereplacechild38";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodereplacechild38.class, args);
   }
}

