/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.sax;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.serializer.Serializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public final class XmlHandlerContentHandler
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    private final XmlHandler handler;
    private final boolean expandEntityReferences;
    private String dtdName;
    private String dtdPublicId;
    private String dtdSystemId;
    private StringWriter internalSubset;
    private Serializer internalSubsetSerializer;
    private Map<String, String> entities;
    private boolean inExternalSubset;
    private String[] namespaces = new String[16];
    private int namespaceCount;
    private boolean inEntityReference;
    private int entityReferenceDepth;

    public XmlHandlerContentHandler(XmlHandler handler, boolean expandEntityReferences) {
        this.handler = handler;
        this.expandEntityReferences = expandEntityReferences;
    }

    private static SAXException toSAXException(StreamException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof SAXException) {
            return (SAXException)cause;
        }
        return new SAXException(ex);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.handler.startDocument(null, "1.0", null, null);
        }
        catch (StreamException ex) {
            throw XmlHandlerContentHandler.toSAXException(ex);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.handler.completed();
        }
        catch (StreamException ex) {
            throw XmlHandlerContentHandler.toSAXException(ex);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dtdName = name;
        this.dtdPublicId = publicId;
        this.dtdSystemId = systemId;
        this.internalSubset = new StringWriter();
        this.internalSubsetSerializer = new Serializer(this.internalSubset);
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        if (!this.inExternalSubset) {
            try {
                this.internalSubsetSerializer.elementDecl(name, model);
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (!this.inExternalSubset) {
            try {
                this.internalSubsetSerializer.attributeDecl(eName, aName, type, mode, value);
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (!this.inExternalSubset) {
            try {
                this.internalSubsetSerializer.externalEntityDecl(name, publicId, systemId);
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.entities == null) {
            this.entities = new HashMap<String, String>();
        }
        this.entities.put(name, value);
        if (!this.inExternalSubset) {
            try {
                this.internalSubsetSerializer.internalEntityDecl(name, value);
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (!this.inExternalSubset) {
            try {
                this.internalSubsetSerializer.notationDecl(name, publicId, systemId);
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (!this.inExternalSubset) {
            try {
                this.internalSubsetSerializer.unparsedEntityDecl(name, publicId, systemId, notationName);
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.internalSubset == null) {
            throw new IllegalStateException("endDTD without startDTD");
        }
        try {
            String internalSubset = this.internalSubset.toString();
            this.handler.processDocumentTypeDeclaration(this.dtdName, this.dtdPublicId, this.dtdSystemId, internalSubset.length() == 0 ? null : internalSubset);
        }
        catch (StreamException ex) {
            throw XmlHandlerContentHandler.toSAXException(ex);
        }
        this.internalSubset = null;
        this.internalSubsetSerializer = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.inEntityReference) {
            int index = this.namespaceCount * 2;
            if (index == this.namespaces.length) {
                String[] newNamespaces = new String[this.namespaces.length * 2];
                System.arraycopy(this.namespaces, 0, newNamespaces, 0, this.namespaces.length);
                this.namespaces = newNamespaces;
            }
            this.namespaces[index] = prefix;
            this.namespaces[index + 1] = uri;
            ++this.namespaceCount;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.inEntityReference) {
            return;
        }
        try {
            int idx;
            if (localName == null || localName.trim().equals("")) {
                localName = qName.substring(qName.indexOf(58) + 1);
            }
            String prefix = (idx = qName.indexOf(58)) == -1 ? "" : qName.substring(0, idx);
            this.handler.startElement(namespaceURI, localName, prefix);
            for (int i = 0; i < this.namespaceCount; ++i) {
                this.handler.processNamespaceDeclaration(this.namespaces[2 * i], this.namespaces[2 * i + 1]);
            }
            this.namespaceCount = 0;
            int j = atts.getLength();
            for (int i = 0; i < j; ++i) {
                String attrQName = atts.getQName(i);
                if (attrQName.startsWith("xmlns")) continue;
                idx = attrQName.indexOf(58);
                String attrPrefix = idx == -1 ? "" : attrQName.substring(0, idx);
                this.handler.processAttribute(atts.getURI(i), atts.getLocalName(i), attrPrefix, atts.getValue(i), atts.getType(i), true);
            }
            this.handler.attributesCompleted();
        }
        catch (StreamException ex) {
            throw XmlHandlerContentHandler.toSAXException(ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.inEntityReference) {
            try {
                this.handler.endElement();
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (!this.inEntityReference) {
            try {
                this.handler.startCDATASection();
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (!this.inEntityReference) {
            try {
                this.handler.endCDATASection();
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.inEntityReference) {
            try {
                this.handler.processCharacterData(new String(ch, start, length), false);
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.inEntityReference) {
            try {
                this.handler.processCharacterData(new String(ch, start, length), true);
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void processingInstruction(String piTarget, String data) throws SAXException {
        if (!this.inEntityReference) {
            try {
                this.handler.startProcessingInstruction(piTarget);
                this.handler.processCharacterData(data, false);
                this.handler.endProcessingInstruction();
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.inEntityReference) {
            try {
                this.handler.startComment();
                this.handler.processCharacterData(new String(ch, start, length), false);
                this.handler.endComment();
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            this.handler.processEntityReference(name, null);
        }
        catch (StreamException ex) {
            throw XmlHandlerContentHandler.toSAXException(ex);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.inEntityReference) {
            ++this.entityReferenceDepth;
        } else if (name.equals("[dtd]")) {
            this.inExternalSubset = true;
        } else if (!this.expandEntityReferences) {
            try {
                this.handler.processEntityReference(name, this.entities == null ? null : this.entities.get(name));
            }
            catch (StreamException ex) {
                throw XmlHandlerContentHandler.toSAXException(ex);
            }
            this.inEntityReference = true;
            this.entityReferenceDepth = 1;
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.inEntityReference) {
            --this.entityReferenceDepth;
            if (this.entityReferenceDepth == 0) {
                this.inEntityReference = false;
            }
        } else if (name.equals("[dtd]")) {
            this.inExternalSubset = false;
        }
    }
}

