/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.AbstractPartialPageRequestHandler;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.handler.logger.PageLogData;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.page.PartialPageUpdate;
import org.apache.wicket.page.XmlPartialPageUpdate;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.encoding.UrlDecoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class AjaxRequestHandler
extends AbstractPartialPageRequestHandler
implements AjaxRequestTarget {
    private final PartialPageUpdate update;
    private Set<AjaxRequestTarget.IListener> listeners = null;
    private final Set<AjaxRequestTarget.ITargetRespondListener> respondListeners = new HashSet<AjaxRequestTarget.ITargetRespondListener>();
    protected transient boolean respondersFrozen;
    protected transient boolean listenersFrozen;
    private PageLogData logData;

    public AjaxRequestHandler(Page page) {
        super(page);
        this.update = new XmlPartialPageUpdate(page){

            @Override
            protected void onBeforeRespond(Response response) {
                AjaxRequestHandler.this.listenersFrozen = true;
                if (AjaxRequestHandler.this.listeners != null) {
                    for (AjaxRequestTarget.IListener listener : AjaxRequestHandler.this.listeners) {
                        listener.onBeforeRespond(this.markupIdToComponent, AjaxRequestHandler.this);
                    }
                }
                AjaxRequestHandler.this.listenersFrozen = false;
            }

            @Override
            protected void onAfterRespond(Response response) {
                AjaxRequestHandler.this.listenersFrozen = true;
                if (AjaxRequestHandler.this.listeners != null) {
                    Map<String, Component> components = Collections.unmodifiableMap(this.markupIdToComponent);
                    for (AjaxRequestTarget.IListener listener : AjaxRequestHandler.this.listeners) {
                        listener.onAfterRespond(components, AjaxRequestHandler.this);
                    }
                }
            }
        };
    }

    @Override
    public void addListener(AjaxRequestTarget.IListener listener) throws IllegalStateException {
        Args.notNull((Object)listener, (String)"listener");
        this.assertListenersNotFrozen();
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet<AjaxRequestTarget.IListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public PartialPageUpdate getUpdate() {
        return this.update;
    }

    @Override
    public final Collection<? extends Component> getComponents() {
        return this.update.getComponents();
    }

    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new PageLogData(this.getPage());
        }
        this.update.detach(requestCycle);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AjaxRequestHandler) {
            AjaxRequestHandler that = (AjaxRequestHandler)obj;
            return this.update.equals(that.update);
        }
        return false;
    }

    public int hashCode() {
        int result = "AjaxRequestHandler".hashCode();
        return result += this.update.hashCode() * 17;
    }

    @Override
    public void registerRespondListener(AjaxRequestTarget.ITargetRespondListener listener) {
        this.assertRespondersNotFrozen();
        this.respondListeners.add(listener);
    }

    public final void respond(IRequestCycle requestCycle) {
        RequestCycle rc = (RequestCycle)requestCycle;
        WebResponse response = (WebResponse)requestCycle.getResponse();
        Page page = this.getPage();
        if (this.shouldRedirectToPage(requestCycle)) {
            RenderPageRequestHandler handler = new RenderPageRequestHandler(new PageProvider(page));
            String url = rc.urlFor(handler).toString();
            response.sendRedirect(url);
            return;
        }
        this.respondersFrozen = true;
        for (AjaxRequestTarget.ITargetRespondListener listener : this.respondListeners) {
            listener.onTargetRespond(this);
        }
        Application app = page.getApplication();
        page.send(app, Broadcast.BREADTH, this);
        String encoding = app.getRequestCycleSettings().getResponseRequestEncoding();
        this.update.setContentType(response, encoding);
        response.disableCaching();
        List<IResponseFilter> filters = Application.get().getRequestCycleSettings().getResponseFilters();
        StringResponse bodyResponse = new StringResponse();
        this.update.writeTo(bodyResponse, encoding);
        if (filters == null || filters.isEmpty()) {
            response.write(bodyResponse.getBuffer());
        } else {
            CharSequence filteredResponse = this.invokeResponseFilters(bodyResponse, filters);
            response.write(filteredResponse);
        }
    }

    private boolean shouldRedirectToPage(IRequestCycle requestCycle) {
        if (this.update.containsPage()) {
            return true;
        }
        return !((WebRequest)requestCycle.getRequest()).isAjax();
    }

    private CharSequence invokeResponseFilters(StringResponse contentResponse, List<IResponseFilter> responseFilters) {
        AppendingStringBuffer responseBuffer = new AppendingStringBuffer(contentResponse.getBuffer());
        for (IResponseFilter filter : responseFilters) {
            responseBuffer = filter.filter(responseBuffer);
        }
        return responseBuffer;
    }

    public String toString() {
        return "[AjaxRequestHandler@" + this.hashCode() + " responseObject [" + this.update + "]";
    }

    @Override
    public String getLastFocusedElementId() {
        WebRequest request = (WebRequest)this.getPage().getRequest();
        String id = request.getHeader("Wicket-FocusedElementId");
        return Strings.isEmpty((String)id) ? null : UrlDecoder.QUERY_INSTANCE.decode(id, request.getCharset());
    }

    public PageLogData getLogData() {
        return this.logData;
    }

    private void assertNotFrozen(boolean frozen, Class<?> clazz) {
        if (frozen) {
            throw new IllegalStateException(Classes.simpleName(clazz) + "s can no longer be added");
        }
    }

    private void assertRespondersNotFrozen() {
        this.assertNotFrozen(this.respondersFrozen, AjaxRequestTarget.ITargetRespondListener.class);
    }

    private void assertListenersNotFrozen() {
        this.assertNotFrozen(this.listenersFrozen, AjaxRequestTarget.IListener.class);
    }
}

