/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.core.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.string.Strings;

public class BookmarkableMapper
extends AbstractBookmarkableMapper {
    public BookmarkableMapper() {
        this((IPageParametersEncoder)new PageParametersEncoder());
    }

    public BookmarkableMapper(IPageParametersEncoder pageParametersEncoder) {
        super("notUsed", pageParametersEncoder);
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Url url = new Url();
        url.getSegments().add(this.getContext().getNamespace());
        url.getSegments().add(this.getContext().getBookmarkableIdentifier());
        url.getSegments().add(info.getPageClass().getName());
        this.encodePageComponentInfo(url, info.getPageComponentInfo());
        return this.encodePageParameters(url, info.getPageParameters(), this.pageParametersEncoder);
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        if (Application.exists() && Application.get().getSecuritySettings().getEnforceMounts()) {
            return null;
        }
        if (this.matches(request)) {
            Url url = request.getUrl();
            PageComponentInfo info = this.getPageComponentInfo(url);
            List segments = url.getSegments();
            String className = segments.size() >= 3 ? (String)segments.get(2) : (String)segments.get(1);
            if (Strings.isEmpty((CharSequence)className)) {
                return null;
            }
            Class<? extends IRequestablePage> pageClass = this.getPageClass(className);
            if (pageClass != null && IRequestablePage.class.isAssignableFrom(pageClass)) {
                PageParameters pageParameters = this.extractPageParameters(request, 3, this.pageParametersEncoder);
                if (pageParameters != null) {
                    pageParameters.setLocale(this.resolveLocale());
                }
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return true;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        int score = 0;
        if (this.matches(request)) {
            score = Integer.MAX_VALUE;
        }
        return score;
    }

    private boolean matches(Request request) {
        boolean matches = false;
        Url url = request.getUrl();
        Url baseUrl = request.getClientUrl();
        String namespace = this.getContext().getNamespace();
        String bookmarkableIdentifier = this.getContext().getBookmarkableIdentifier();
        String pageIdentifier = this.getContext().getPageIdentifier();
        List segments = url.getSegments();
        int segmentsSize = segments.size();
        if (segmentsSize >= 3 && this.urlStartsWithAndHasPageClass(url, namespace, bookmarkableIdentifier)) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 3 && this.urlStartsWith(baseUrl, new String[]{namespace, bookmarkableIdentifier}) && segmentsSize >= 2 && this.urlStartsWithAndHasPageClass(url, bookmarkableIdentifier)) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 2 && this.urlStartsWith(baseUrl, new String[]{bookmarkableIdentifier}) && segmentsSize == 2 && this.urlStartsWithAndHasPageClass(url, bookmarkableIdentifier)) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 2 && this.urlStartsWith(baseUrl, new String[]{namespace, pageIdentifier}) && segmentsSize >= 2 && this.urlStartsWithAndHasPageClass(url, bookmarkableIdentifier)) {
            matches = true;
        }
        return matches;
    }

    protected boolean urlStartsWithAndHasPageClass(Url url, String ... segments) {
        boolean result = this.urlStartsWith(url, segments);
        if (result) {
            List urlSegments = url.getSegments();
            if (urlSegments.size() == segments.length) {
                result = false;
            } else {
                String pageClassSegment = (String)urlSegments.get(segments.length);
                if (Strings.isEmpty((CharSequence)pageClassSegment)) {
                    result = false;
                }
            }
        }
        return result;
    }
}

